/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.client.GuiTools;
import mcjty.lib.client.RenderHelper;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.GuiSideWindow;
import mcjty.lib.gui.IKeyReceiver;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.WindowManager;
import mcjty.lib.gui.WindowTools;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.EnergyBar;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.network.PacketSendServerCommand;
import mcjty.lib.network.PacketServerCommandTyped;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.ComponentFactory;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SafeClientTools;
import mcjty.lib.varia.Tools;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.network.simple.SimpleChannel;

public abstract class GenericGuiContainer<T extends GenericTileEntity, C extends AbstractContainerMenu>
extends AbstractContainerScreen<C>
implements IKeyReceiver {
    protected Window window;
    private WindowManager windowManager;
    protected final T tileEntity;
    private final GuiSideWindow sideWindow;

    public void setWindowDimensions(int x, int y) {
        this.f_97726_ = x;
        this.f_97727_ = y;
    }

    public GenericGuiContainer(T tileEntity, C container, Inventory inventory, ManualEntry manualEntry) {
        super(container, inventory, (Component)ComponentFactory.literal("test"));
        this.tileEntity = tileEntity;
        this.sideWindow = new GuiSideWindow(manualEntry.manual(), manualEntry.entry(), manualEntry.page());
        this.windowManager = null;
    }

    public List<Rect2i> getExtraWindowBounds() {
        if (this.sideWindow.getWindow() == null || this.sideWindow.getWindow().getToplevel() == null) {
            Logging.getLogger().error((Object)new RuntimeException("Internal error! getExtraWindowBounds() called before initGui!"));
            return Collections.emptyList();
        }
        ArrayList<Rect2i> bounds = new ArrayList<Rect2i>();
        Rectangle r1 = this.sideWindow.getWindow().getToplevel().getBounds();
        bounds.add(new Rect2i(r1.x, r1.y, r1.width, r1.height));
        if (this.windowManager != null) {
            for (Window w : this.windowManager.getWindows()) {
                Rectangle r = w.getToplevel().getBounds();
                bounds.add(new Rect2i(r.x, r.y, r.width, r.height));
            }
        }
        return bounds;
    }

    public void m_7856_() {
        this.windowManager = null;
        super.m_7856_();
        this.sideWindow.initGui(this.f_96541_, (Screen)this, this.f_97735_, this.f_97736_, this.f_97726_, this.f_97727_);
    }

    protected void registerWindows(WindowManager mgr) {
    }

    protected WindowManager getWindowManager() {
        if (this.windowManager == null) {
            if (this.sideWindow.getWindow() == null) {
                RuntimeException e = new RuntimeException("Internal error! getWindowManager() called before initGui!");
                Logging.getLogger().error((Object)e);
                throw e;
            }
            this.windowManager = new WindowManager((Screen)this);
            this.windowManager.addWindow(this.sideWindow.getWindow());
            this.windowManager.addWindow(this.window);
            this.registerWindows(this.windowManager);
        }
        return this.windowManager;
    }

    protected void m_280003_(@Nonnull GuiGraphics graphics, int p_230451_2_, int p_230451_3_) {
        this.getWindowManager().drawTooltips(graphics);
    }

    public void drawHoveringText(GuiGraphics graphics, List<String> textLines, List<ItemStack> items, int x, int y, Font font) {
        if (!textLines.isEmpty()) {
            PoseStack matrixStack = graphics.m_280168_();
            matrixStack.m_85836_();
            RenderSystem.disableDepthTest();
            int i = 0;
            int linesWithItemStacks = 0;
            for (String s : textLines) {
                int j;
                if (s != null && items != null && s.contains("@") && !items.isEmpty()) {
                    List<Object> list = WindowTools.parseString(s, items);
                    boolean lineHasItemStacks = false;
                    j = 0;
                    for (Object o : list) {
                        if (o instanceof String) {
                            j += font.m_92895_((String)o);
                            continue;
                        }
                        j += 20;
                        lineHasItemStacks = true;
                    }
                    if (lineHasItemStacks) {
                        ++linesWithItemStacks;
                    }
                } else {
                    j = font.m_92895_(s);
                }
                if (j <= i) continue;
                i = j;
            }
            int xx = x + 12;
            int yy = y - 12;
            int k = 8;
            if (textLines.size() > 1) {
                k += 2 + (textLines.size() - 1) * 10 + linesWithItemStacks * 8;
            }
            if (xx > this.f_96543_ - this.f_97735_ - i - 5) {
                xx -= 28 + i;
            }
            if (xx < 4 - this.f_97735_) {
                xx = 4 - this.f_97735_;
            }
            if (yy > this.f_96544_ - this.f_97736_ - k - 4) {
                yy = this.f_96544_ - this.f_97736_ - k - 4;
            } else if (yy < 4 - this.f_97736_) {
                yy = 4 - this.f_97736_;
            }
            int l = -267386864;
            graphics.m_280024_(xx - 3, yy - 4, xx + i + 3, yy - 3, l, l);
            graphics.m_280024_(xx - 3, yy + k + 3, xx + i + 3, yy + k + 4, l, l);
            graphics.m_280024_(xx - 3, yy - 3, xx + i + 3, yy + k + 3, l, l);
            graphics.m_280024_(xx - 4, yy - 3, xx - 3, yy + k + 3, l, l);
            graphics.m_280024_(xx + i + 3, yy - 3, xx + i + 4, yy + k + 3, l, l);
            int i1 = 0x505000FF;
            int j1 = (i1 & 0xFEFEFE) >> 1 | i1 & 0xFF000000;
            graphics.m_280024_(xx - 3, yy - 3 + 1, xx - 3 + 1, yy + k + 3 - 1, i1, j1);
            graphics.m_280024_(xx + i + 2, yy - 3 + 1, xx + i + 3, yy + k + 3 - 1, i1, j1);
            graphics.m_280024_(xx - 3, yy - 3, xx + i + 3, yy - 3 + 1, i1, i1);
            graphics.m_280024_(xx - 3, yy + k + 2, xx + i + 3, yy + k + 3, j1, j1);
            matrixStack.m_85837_(0.0, 0.0, 300.0);
            this.renderTextLines(graphics, textLines, items, font, xx, yy);
            RenderSystem.enableDepthTest();
            matrixStack.m_85849_();
        }
    }

    private void renderTextLines(GuiGraphics graphics, List<String> textLines, List<ItemStack> items, Font font, int xx, int yy) {
        for (int i = 0; i < textLines.size(); ++i) {
            String s1 = textLines.get(i);
            if (s1 != null && items != null && s1.contains("@") && !items.isEmpty()) {
                List<Object> list = WindowTools.parseString(s1, items);
                int curx = xx;
                boolean lineHasItemStacks = false;
                for (Object o : list) {
                    if (o instanceof String) {
                        String s2 = (String)o;
                        font.m_271703_(s2, (float)curx, (float)yy, 0xFFFFFF, true, graphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)graphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
                        curx += font.m_92895_(s2);
                        continue;
                    }
                    RenderHelper.renderObject(graphics, curx + 1, yy, o, false);
                    curx += 20;
                    lineHasItemStacks = true;
                }
                if (lineHasItemStacks) {
                    yy += 8;
                }
            } else {
                font.m_271703_(s1, (float)xx, (float)yy, 0xFFFFFF, true, graphics.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)graphics.m_280091_(), Font.DisplayMode.NORMAL, 0, 0xF000F0);
            }
            if (i == 0) {
                yy += 2;
            }
            yy += 10;
        }
    }

    protected void m_7286_(@Nonnull GuiGraphics graphics, float partialTicks, int x, int y) {
        this.drawWindow(graphics);
    }

    protected void drawWindow(GuiGraphics graphics) {
        if (this.window == null) {
            return;
        }
        this.m_280273_(graphics);
        this.getWindowManager().syncBindings(this.tileEntity);
        this.getWindowManager().draw(graphics);
    }

    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.window == null) {
            return;
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        this.m_280072_(graphics, mouseX, mouseY);
        this.drawStackTooltips(graphics, mouseX, mouseY);
    }

    public void m_280092_(@Nonnull GuiGraphics graphics, @Nonnull Slot slot) {
        if (!this.isPartiallyCoveredByModalWindow(slot)) {
            super.m_280092_(graphics, slot);
        }
    }

    @Nullable
    public Slot getSlotUnderMouse() {
        Slot slot = super.getSlotUnderMouse();
        if (slot == null) {
            return null;
        }
        if (this.isPartiallyCoveredByModalWindow(slot)) {
            return null;
        }
        return slot;
    }

    public boolean m_97774_(@Nonnull Slot slotIn, double mouseX, double mouseY) {
        if (this.isPartiallyCoveredByModalWindow(slotIn)) {
            return false;
        }
        return super.m_97774_(slotIn, mouseX, mouseY);
    }

    private boolean isPartiallyCoveredByModalWindow(Slot slotIn) {
        int xPos = slotIn.f_40220_ + this.window.getToplevel().getBounds().x;
        int yPos = slotIn.f_40221_ + this.window.getToplevel().getBounds().y;
        return this.getWindowManager().getModalWindows().anyMatch(window -> window.getToplevel().getBounds().intersects(new Rectangle(xPos, yPos, 18, 18)));
    }

    protected void drawStackTooltips(GuiGraphics graphics, int mouseX, int mouseY) {
        BlockRender blockRender;
        Object renderItem;
        ItemStack itemStack;
        int x = GuiTools.getRelativeX(this.window.getGui());
        int y = GuiTools.getRelativeY(this.window.getGui());
        Widget<?> widget = this.window.getToplevel().getWidgetAtPosition(x, y);
        if (widget instanceof BlockRender && !(itemStack = (renderItem = (blockRender = (BlockRender)widget).getRenderItem()) instanceof ItemStack ? (ItemStack)renderItem : (renderItem instanceof Block ? new ItemStack((ItemLike)((Block)renderItem)) : (renderItem instanceof Item ? new ItemStack((ItemLike)((Item)renderItem)) : ItemStack.f_41583_))).m_41619_()) {
            this.customRenderToolTip(graphics, blockRender, itemStack, mouseX, mouseY);
        }
    }

    protected List<Component> addCustomLines(List<Component> oldList, BlockRender blockRender, ItemStack stack) {
        return oldList;
    }

    protected void customRenderToolTip(GuiGraphics graphics, BlockRender blockRender, ItemStack stack, int x, int y) {
        List<Object> list;
        if (stack.m_41720_() == null) {
            list = new ArrayList<Component>();
        } else {
            TooltipFlag.Default flag = this.getMinecraft().f_91066_.f_92125_ ? TooltipFlag.Default.f_256730_ : TooltipFlag.Default.f_256752_;
            list = stack.m_41651_((Player)this.getMinecraft().f_91074_, (TooltipFlag)flag);
        }
        list = this.addCustomLines(list, blockRender, stack);
        graphics.renderTooltip(this.getMinecraft().f_91062_, list, Optional.empty(), stack, x, y);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_7861_() {
        super.m_7861_();
    }

    public boolean m_6375_(double x, double y, int button) {
        boolean rc = super.m_6375_(x, y, button);
        if (this.window != null) {
            this.getWindowManager().mouseClicked(x, y, button);
        }
        return rc;
    }

    public boolean m_7979_(double x, double y, int button, double scaledX, double scaledY) {
        boolean rc = super.m_7979_(x, y, button, scaledX, scaledY);
        if (this.window != null) {
            this.getWindowManager().mouseDragged(x, y, button);
        }
        return rc;
    }

    public boolean m_6050_(double x, double y, double amount) {
        boolean rc = super.m_6050_(x, y, amount);
        if (this.window != null) {
            this.getWindowManager().mouseScrolled(x, y, amount);
        }
        return false;
    }

    public boolean m_6348_(double x, double y, int button) {
        boolean rc = super.m_6348_(x, y, button);
        if (this.window != null) {
            this.getWindowManager().mouseReleased(x, y, button);
        }
        return rc;
    }

    @Override
    public Window getWindow() {
        return this.window;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        boolean b;
        boolean bl = b = this.window == null || this.getWindowManager().keyTyped(keyCode, scanCode);
        if (b) {
            return super.m_7933_(keyCode, scanCode, modifiers);
        }
        return false;
    }

    @Override
    public boolean mouseClickedFromEvent(double x, double y, int button) {
        WindowManager manager = this.getWindow().getWindowManager();
        manager.mouseClicked(x, y, button);
        return true;
    }

    @Override
    public boolean mouseReleasedFromEvent(double x, double y, int button) {
        WindowManager manager = this.getWindow().getWindowManager();
        manager.mouseReleased(x, y, button);
        return true;
    }

    @Override
    public boolean mouseScrolledFromEvent(double x, double y, double amount) {
        WindowManager manager = this.getWindow().getWindowManager();
        manager.mouseScrolled(x, y, amount);
        return true;
    }

    @Override
    public void keyTypedFromEvent(int keyCode, int scanCode) {
        if (this.window != null && this.getWindowManager().keyTyped(keyCode, scanCode)) {
            super.m_7933_(keyCode, scanCode, 0);
        }
    }

    @Override
    public void charTypedFromEvent(char codePoint) {
        if (this.window == null || this.getWindowManager().charTyped(codePoint)) {
            // empty if block
        }
    }

    public <T> void setValue(SimpleChannel channel, Value<?, T> value, T v) {
        this.sendServerCommandTyped(channel, ((GenericTileEntity)((Object)this.tileEntity)).getDimension(), GenericTileEntity.COMMAND_SYNC_BINDING.name(), TypedMap.builder().put(value.key(), v).build());
    }

    public void sendServerCommandTyped(SimpleChannel network, String command, TypedMap params) {
        network.sendToServer((Object)new PacketServerCommandTyped(this.tileEntity.m_58899_(), ((GenericTileEntity)((Object)this.tileEntity)).getDimension(), command, params));
    }

    public void sendServerCommandTyped(SimpleChannel network, Command<?> command, TypedMap params) {
        network.sendToServer((Object)new PacketServerCommandTyped(this.tileEntity.m_58899_(), ((GenericTileEntity)((Object)this.tileEntity)).getDimension(), command.name(), params));
    }

    public void sendServerCommandTyped(SimpleChannel network, ResourceKey<Level> dimensionId, String command, TypedMap params) {
        network.sendToServer((Object)new PacketServerCommandTyped(this.tileEntity.m_58899_(), dimensionId, command, params));
    }

    public void sendServerCommand(SimpleChannel network, String modid, String command, @Nonnull TypedMap arguments) {
        network.sendToServer((Object)new PacketSendServerCommand(modid, command, arguments));
    }

    public void sendServerCommand(SimpleChannel network, String modid, String command) {
        network.sendToServer((Object)new PacketSendServerCommand(modid, command, TypedMap.EMPTY));
    }

    public static <C extends GenericContainer, S extends GenericGuiContainer<T, C>, T extends GenericTileEntity> void register(MenuType<C> type, GuiSupplier<C, S, T> guiSupplier) {
        MenuScreens.ScreenConstructor factory = (container, inventory, title) -> {
            BlockEntity te = SafeClientTools.getClientWorld().m_7702_(container.getPos());
            return Tools.safeMap(te, tile -> guiSupplier.create(tile, container, inventory), "Invalid tile entity!");
        };
        MenuScreens.m_96206_(type, (MenuScreens.ScreenConstructor)factory);
    }

    protected void updateEnergyBar(EnergyBar energyBar) {
        this.tileEntity.getCapability(ForgeCapabilities.ENERGY).ifPresent(e -> {
            energyBar.maxValue(((GenericEnergyStorage)e).getCapacity());
            energyBar.value(((GenericEnergyStorage)e).getEnergy());
        });
    }

    @FunctionalInterface
    public static interface GuiSupplier<C extends GenericContainer, S extends GenericGuiContainer, T extends GenericTileEntity> {
        public S create(T var1, C var2, Inventory var3);
    }
}

