/*
 * Decompiled with CFR 0.152.
 */
package me.dinnerbeef.compressium;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import me.dinnerbeef.compressium.CompressibleBlock;
import me.dinnerbeef.compressium.CompressiumClient;
import me.dinnerbeef.compressium.DefaultCompressiumBlocks;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod(value="compressium")
public class Compressium {
    public static final String MODID = "compressium";
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BLOCKS, (String)"compressium");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.ITEMS, (String)"compressium");
    public static final DeferredRegister<CreativeModeTab> COMPRESSIUM_TAB = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"compressium");
    public static final RegistryObject<CreativeModeTab> TAB = COMPRESSIUM_TAB.register("compressium", () -> new CreativeModeTab.Builder(CreativeModeTab.Row.TOP, 1).m_257737_(() -> new ItemStack((ItemLike)Items.f_42594_)).m_257941_((Component)Component.m_237115_((String)"itemGroup.compressium")).m_257501_((config, builder) -> ITEMS.getEntries().forEach(entry -> builder.m_246326_((ItemLike)entry.get()))).m_257652_());
    public static final HashMap<CompressibleBlock, List<Supplier<Block>>> REGISTERED_BLOCKS = new HashMap();
    private static final Logger LOGGER = LogUtils.getLogger();

    public Compressium() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(eventBus);
        BLOCKS.register(eventBus);
        COMPRESSIUM_TAB.register(eventBus);
        eventBus.addListener(this::clientSetup);
        this.loadBlocksFromConfig();
    }

    /*
     * Unable to fully structure code
     */
    private void loadBlocksFromConfig() {
        Compressium.LOGGER.info("Loading compressible blocks from data store config/compressiumblocks.json");
        config = FMLPaths.CONFIGDIR.get().resolve("compressiumblocks.json");
        compressedBlocks = new ArrayList<CompressibleBlock>();
        if (Files.exists(config, new LinkOption[0])) {
            try {
                compressableBlocks = (CompressibleBlock[])new Gson().fromJson(Files.readString(config), CompressibleBlock[].class);
                compressedBlocks.addAll(Arrays.asList(compressableBlocks));
                foundBlocks = compressedBlocks.stream().map((Function<CompressibleBlock, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$loadBlocksFromConfig$4(me.dinnerbeef.compressium.CompressibleBlock ), (Lme/dinnerbeef/compressium/CompressibleBlock;)Ljava/lang/String;)()).toList();
                missingDefaultBlocks = DefaultCompressiumBlocks.VALUES.stream().filter((Predicate<DefaultCompressiumBlocks>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$loadBlocksFromConfig$5(java.util.List me.dinnerbeef.compressium.DefaultCompressiumBlocks ), (Lme/dinnerbeef/compressium/DefaultCompressiumBlocks;)Z)(foundBlocks)).toList();
                if (missingDefaultBlocks.size() <= 0) ** GOTO lbl33
                Compressium.LOGGER.warn("Found a missing block from the default compressible blocks, adding it back.");
                Compressium.LOGGER.warn("We do not support dynamically removing default blocks to prevent basic registry issues.");
                compressedBlocks.addAll(missingDefaultBlocks.stream().map((Function<DefaultCompressiumBlocks, CompressibleBlock>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$loadBlocksFromConfig$6(me.dinnerbeef.compressium.DefaultCompressiumBlocks ), (Lme/dinnerbeef/compressium/DefaultCompressiumBlocks;)Lme/dinnerbeef/compressium/CompressibleBlock;)()).toList());
                Files.writeString(config, (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson(compressedBlocks), new OpenOption[0]);
            }
            catch (IOException e) {
                Compressium.LOGGER.error("Unable to read json file for compressible blocks data!");
                throw new RuntimeException(e);
            }
        } else {
            Compressium.LOGGER.info("Compressible blocks json not found. Creating a new one!");
            try {
                defaultBlocks = Arrays.stream(DefaultCompressiumBlocks.values()).map((Function<DefaultCompressiumBlocks, CompressibleBlock>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$loadBlocksFromConfig$7(me.dinnerbeef.compressium.DefaultCompressiumBlocks ), (Lme/dinnerbeef/compressium/DefaultCompressiumBlocks;)Lme/dinnerbeef/compressium/CompressibleBlock;)()).toList();
                compressedBlocks.addAll(defaultBlocks);
                Files.writeString(config, (CharSequence)new GsonBuilder().setPrettyPrinting().create().toJson(defaultBlocks), new OpenOption[0]);
            }
            catch (IOException e) {
                Compressium.LOGGER.error("Unable to write json file for compressible blocks data!");
                throw new RuntimeException(e);
            }
        }
lbl33:
        // 4 sources

        for (CompressibleBlock block : compressedBlocks) {
            registeredBlocks = new ArrayList<RegistryObject>();
            for (i = 0; i < block.getNestedDepth(); ++i) {
                name = block.name().toLowerCase() + "_" + (i + 1);
                blockSupplier = Compressium.BLOCKS.register(name, (Supplier<Block>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$loadBlocksFromConfig$8(me.dinnerbeef.compressium.CompressibleBlock ), ()Lnet/minecraft/world/level/block/Block;)((CompressibleBlock)block));
                Compressium.ITEMS.register(name, (Supplier<BlockItem>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$loadBlocksFromConfig$9(java.util.function.Supplier ), ()Lnet/minecraft/world/item/BlockItem;)((Supplier)blockSupplier));
                registeredBlocks.add(blockSupplier);
            }
            Compressium.REGISTERED_BLOCKS.put(block, registeredBlocks);
        }
    }

    private void clientSetup(FMLClientSetupEvent event) {
        CompressiumClient.setupItemVar();
    }

    private static /* synthetic */ BlockItem lambda$loadBlocksFromConfig$9(Supplier blockSupplier) {
        return new BlockItem((Block)blockSupplier.get(), new Item.Properties());
    }

    private static /* synthetic */ Block lambda$loadBlocksFromConfig$8(CompressibleBlock block) {
        return block.type().getConstructor().get();
    }

    private static /* synthetic */ CompressibleBlock lambda$loadBlocksFromConfig$7(DefaultCompressiumBlocks e) {
        return e.block;
    }

    private static /* synthetic */ CompressibleBlock lambda$loadBlocksFromConfig$6(DefaultCompressiumBlocks e) {
        return e.block;
    }

    private static /* synthetic */ boolean lambda$loadBlocksFromConfig$5(List foundBlocks, DefaultCompressiumBlocks e) {
        return !foundBlocks.contains(e.name().toLowerCase());
    }

    private static /* synthetic */ String lambda$loadBlocksFromConfig$4(CompressibleBlock e) {
        return e.name().toLowerCase();
    }
}

