/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.client.gui.widgets.lists;

import caeruleusTait.world.preview.client.WorldPreviewClient;
import caeruleusTait.world.preview.client.gui.PreviewDisplayDataProvider;
import caeruleusTait.world.preview.client.gui.screens.PreviewContainer;
import caeruleusTait.world.preview.client.gui.widgets.ToggleButton;
import caeruleusTait.world.preview.client.gui.widgets.lists.BaseObjectSelectionList;
import com.mojang.blaze3d.platform.NativeImage;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructuresList
extends BaseObjectSelectionList<StructureEntry> {
    public StructuresList(Minecraft minecraft, int width, int height, int x, int y) {
        super(minecraft, width, height, x, y, 24);
    }

    public StructureEntry createEntry(short id, ResourceLocation resourceLocation, NativeImage icon, Item item, String name, boolean show, boolean showByDefault) {
        return new StructureEntry(id, resourceLocation, icon, item, name, show, showByDefault);
    }

    @Override
    public void m_5988_(Collection<StructureEntry> entryList) {
        super.m_5988_(entryList);
        double maxScroll = Math.max(0.0, (double)(super.m_5773_() * this.f_93387_ - this.f_93389_));
        if (super.m_93517_() > maxScroll) {
            super.m_93410_(maxScroll);
        }
    }

    public class StructureEntry
    extends BaseObjectSelectionList.Entry<StructureEntry>
    implements PreviewDisplayDataProvider.StructureRenderInfo {
        private final short id;
        private final NativeImage icon;
        private final Item item;
        private final ItemStack itemStack;
        private final DynamicTexture iconTexture;
        private final int iconWidth;
        private final int iconHeight;
        private final String name;
        private final Tooltip tooltip;
        private final boolean showByDefault;
        private final boolean isPrimaryNamespace;
        private boolean show;
        public final ToggleButton toggleVisible;

        public StructureEntry(short id, @NotNull ResourceLocation resourceLocation, @Nullable NativeImage icon, Item item, String name, boolean show, boolean showByDefault) {
            this.id = id;
            this.item = item;
            this.itemStack = this.item == null ? null : new ItemStack((ItemLike)this.item, 1);
            this.icon = icon;
            this.iconTexture = new DynamicTexture(this.icon);
            this.iconWidth = this.icon.m_84982_();
            this.iconHeight = this.icon.m_85084_();
            this.showByDefault = showByDefault;
            this.show = show;
            this.toggleVisible = new ToggleButton(0, 0, 20, 20, 140, 20, 20, 20, PreviewContainer.BUTTONS_TEXTURE, 320, 60, this::toggleVisible);
            this.iconTexture.m_117985_();
            this.toggleVisible.selected = show;
            this.isPrimaryNamespace = resourceLocation.m_135827_().equals("minecraft");
            this.name = Objects.equals(resourceLocation.toString(), name) || name == null ? WorldPreviewClient.toTitleCase(resourceLocation.m_135815_().replace("_", " ")) : name;
            String tag = "\u00a75\u00a7o" + resourceLocation.m_135827_() + "\u00a7r\n\u00a79" + resourceLocation.m_135815_() + "\u00a7r";
            this.tooltip = Tooltip.m_257550_((Component)Component.m_237113_((String)(this.name + "\n\n" + tag)));
        }

        public void reset() {
            this.toggleVisible.selected = this.show = this.showByDefault;
        }

        private void toggleVisible(Button btn) {
            this.show = this.toggleVisible.selected;
        }

        public void setVisible(boolean show) {
            this.show = show;
        }

        @Override
        public Tooltip tooltip() {
            return this.tooltip;
        }

        @NotNull
        public Component m_142172_() {
            return Component.m_237119_();
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean bl, float partialTick) {
            int xMin = left + 2;
            int yMin = top + 2;
            int xMax = xMin + this.iconWidth;
            int yMax = yMin + this.iconHeight;
            if (this.item != null) {
                guiGraphics.m_280480_(this.itemStack, xMin, yMin);
            } else {
                WorldPreviewClient.renderTexture((AbstractTexture)this.iconTexture, xMin, yMin, xMax, yMax);
            }
            Object formatName = this.isPrimaryNamespace ? this.name : "\u00a7o" + this.name;
            guiGraphics.m_280488_(((StructuresList)StructuresList.this).f_93386_.f_91062_, (String)formatName, left + 16 + 4, top + 6, 0xFFFFFF);
            this.toggleVisible.m_264152_(StructuresList.this.m_93520_() - 22, top);
            this.toggleVisible.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            StructuresList.this.f_93386_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            if (this.toggleVisible.m_5953_(mouseX, mouseY)) {
                this.toggleVisible.m_5716_(mouseX, mouseY);
            }
            return true;
        }

        public String name() {
            return this.name;
        }

        public boolean showByDefault() {
            return this.showByDefault;
        }

        @Override
        public boolean show() {
            return this.show;
        }

        public short id() {
            return this.id;
        }

        public Item item() {
            return this.item;
        }

        public ItemStack itemStack() {
            return this.itemStack;
        }
    }
}

