/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.client.gui.screens.settings;

import caeruleusTait.world.preview.WorldPreview;
import caeruleusTait.world.preview.backend.color.PreviewData;
import caeruleusTait.world.preview.client.WorldPreviewComponents;
import caeruleusTait.world.preview.client.gui.screens.PreviewContainer;
import caeruleusTait.world.preview.client.gui.widgets.ColorChooser;
import caeruleusTait.world.preview.client.gui.widgets.WGCheckbox;
import caeruleusTait.world.preview.client.gui.widgets.WGLabel;
import caeruleusTait.world.preview.client.gui.widgets.lists.AbstractSelectionListHolder;
import caeruleusTait.world.preview.client.gui.widgets.lists.BiomesList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.layouts.FrameLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.dimension.LevelStem;
import org.jetbrains.annotations.NotNull;

public class BiomesTab
implements Tab {
    private final PreviewContainer previewContainer;
    private final Minecraft minecraft;
    private final GridLayout layout = new GridLayout();
    private final BiomesList biomesList;
    private final AbstractSelectionListHolder<BiomesList.BiomeEntry, BiomesList> biomesListHolder;
    private final CycleButton<BiomeListFilter> filterCycleButton;
    private final List<AbstractWidget> toRender = new ArrayList<AbstractWidget>();
    private final ColorChooser colorChooser;
    private BiomesList.BiomeEntry selectedEntry;
    private boolean blockUpdates = false;
    private final Button resetBtn;
    private final Button applyBtn;
    private final WGCheckbox isCaveCB;

    public BiomesTab(Minecraft _minecraft, PreviewContainer _previewTab) {
        this.previewContainer = _previewTab;
        this.minecraft = _minecraft;
        Font font = this.minecraft.f_91062_;
        this.biomesList = new BiomesList(this.previewContainer, this.minecraft, 100, 100, 0, 0, false);
        this.biomesListHolder = new AbstractSelectionListHolder(this.biomesList, 0, 0, 100, 100, WorldPreviewComponents.SETTINGS_BIOMES_TITLE);
        this.toRender.add(this.biomesListHolder);
        this.colorChooser = new ColorChooser(0, 0);
        this.toRender.add(this.colorChooser);
        int EDIT_WIDTH = 36;
        int LABEL_WIDTH = 75;
        int COLUMN_SPACING = 8;
        int FULL_WIDTH = 120;
        this.filterCycleButton = CycleButton.m_168894_(BiomeListFilter::toComponent).m_168961_((Object[])BiomeListFilter.values()).m_168948_((Object)BiomeListFilter.DIMENSION).m_168936_(0, 0, 120, 20, WorldPreviewComponents.COLOR_LIST_FILTER, (b, v) -> this.biomesList.m_5988_((Collection<BiomesList.BiomeEntry>)v.apply(this.previewContainer.allBiomes())));
        this.toRender.add((AbstractWidget)this.filterCycleButton);
        WGLabel statusLabel = new WGLabel(font, 0, 0, 120, 20, WGLabel.TextAlignment.CENTER, (Component)Component.m_237113_((String)""), -5592406);
        EditBox hueBox = new EditBox(font, 0, 0, 36, 20, WorldPreviewComponents.COLOR_HUE);
        EditBox satBox = new EditBox(font, 0, 0, 36, 20, WorldPreviewComponents.COLOR_SAT);
        EditBox valBox = new EditBox(font, 0, 0, 36, 20, WorldPreviewComponents.COLOR_VAL);
        this.isCaveCB = new WGCheckbox(0, 0, 120, 20, WorldPreviewComponents.COLOR_CAVE, x -> this.updateStatus(), false);
        this.resetBtn = Button.m_253074_((Component)WorldPreviewComponents.COLOR_RESET, x -> {
            this.selectedEntry.reset();
            this.isCaveCB.setSelected(this.selectedEntry.isCave());
            this.colorChooser.updateRGB(this.selectedEntry.color());
            statusLabel.setText(this.selectedEntry.statusComponent());
        }).m_252780_(120).m_253136_();
        this.applyBtn = Button.m_253074_((Component)WorldPreviewComponents.COLOR_APPLY, x -> {
            this.selectedEntry.changeColor(this.colorChooser.colorRGB());
            this.selectedEntry.setCave(this.isCaveCB.m_93840_());
            this.colorChooser.updateRGB(this.selectedEntry.color());
            statusLabel.setText(this.selectedEntry.statusComponent());
        }).m_252780_(120).m_253136_();
        hueBox.m_94153_(x -> this.validateMaxInt((String)x, 360));
        satBox.m_94153_(x -> this.validateMaxInt((String)x, 100));
        valBox.m_94153_(x -> this.validateMaxInt((String)x, 100));
        Consumer<String> hsvConsumer = x -> {
            if (!this.blockUpdates) {
                this.colorChooser.updateHSV(this.intOrZero(hueBox.m_94155_()), this.intOrZero(satBox.m_94155_()), this.intOrZero(valBox.m_94155_()));
                this.colorChooser.runUpdater();
            }
        };
        hueBox.m_94151_(hsvConsumer);
        satBox.m_94151_(hsvConsumer);
        valBox.m_94151_(hsvConsumer);
        this.colorChooser.setUpdater((h, s, v) -> {
            try {
                this.blockUpdates = true;
                this.updateIfChanged(hueBox, h);
                this.updateIfChanged(satBox, s);
                this.updateIfChanged(valBox, v);
                this.updateStatus();
            }
            finally {
                this.blockUpdates = false;
            }
        });
        this.biomesList.setBiomeChangeListener(biomeEntry -> {
            this.selectedEntry = biomeEntry;
            if (this.selectedEntry != null) {
                this.colorChooser.updateRGB(this.selectedEntry.color());
                this.isCaveCB.setSelected(this.selectedEntry.isCave());
                statusLabel.setText(this.selectedEntry.statusComponent());
            }
        });
        this.biomesList.setSelected(this.previewContainer.allBiomes().isEmpty() ? null : this.previewContainer.allBiomes().get(0));
        this.layout.m_267750_(4).m_267749_(8);
        GridLayout.RowHelper rowHelper = this.layout.m_264606_(2);
        rowHelper.m_264139_((LayoutElement)new WGLabel(font, 0, 0, 75, 20, WGLabel.TextAlignment.LEFT, WorldPreviewComponents.COLOR_HUE, -1));
        rowHelper.m_264139_((LayoutElement)hueBox);
        rowHelper.m_264139_((LayoutElement)new WGLabel(font, 0, 0, 75, 20, WGLabel.TextAlignment.LEFT, WorldPreviewComponents.COLOR_SAT, -1));
        rowHelper.m_264139_((LayoutElement)satBox);
        rowHelper.m_264139_((LayoutElement)new WGLabel(font, 0, 0, 75, 20, WGLabel.TextAlignment.LEFT, WorldPreviewComponents.COLOR_VAL, -1));
        rowHelper.m_264139_((LayoutElement)valBox);
        rowHelper.m_264139_((LayoutElement)new WGLabel(font, 0, 0, 75, 10, WGLabel.TextAlignment.LEFT, (Component)Component.m_237113_((String)""), 0xFFFFFF));
        rowHelper.m_264108_((LayoutElement)this.isCaveCB, 2);
        rowHelper.m_264108_((LayoutElement)this.resetBtn, 2);
        rowHelper.m_264108_((LayoutElement)this.applyBtn, 2);
        rowHelper.m_264139_((LayoutElement)new WGLabel(font, 0, 0, 75, 10, WGLabel.TextAlignment.LEFT, (Component)Component.m_237113_((String)""), 0xFFFFFF));
        rowHelper.m_264108_((LayoutElement)statusLabel, 2);
    }

    private void updateStatus() {
        if (this.selectedEntry != null) {
            this.resetBtn.f_93623_ = this.selectedEntry.color() != this.colorChooser.colorRGB() || this.selectedEntry.isCave() != this.isCaveCB.m_93840_() || this.selectedEntry.dataSource() == PreviewData.DataSource.CONFIG;
            this.applyBtn.f_93623_ = this.selectedEntry.color() != this.colorChooser.colorRGB() || this.selectedEntry.isCave() != this.isCaveCB.m_93840_();
            this.isCaveCB.f_93623_ = true;
        } else {
            this.resetBtn.f_93623_ = false;
            this.applyBtn.f_93623_ = false;
            this.isCaveCB.f_93623_ = false;
        }
    }

    @NotNull
    public Component m_267600_() {
        return WorldPreviewComponents.SETTINGS_BIOMES_TITLE;
    }

    public void m_267609_(Consumer<AbstractWidget> consumer) {
        this.toRender.forEach(consumer);
        this.layout.m_264134_(consumer);
    }

    public void m_267697_(ScreenRectangle screenRectangle) {
        int leftWidth = screenRectangle.f_263770_() / 3;
        int left = screenRectangle.m_274563_() + 3;
        int top = screenRectangle.m_274449_() + 2;
        int bottom = screenRectangle.m_274349_() - 8;
        this.filterCycleButton.m_264152_(left, top);
        this.filterCycleButton.m_93674_(leftWidth);
        int listTop = top + 20 + 4;
        this.biomesListHolder.m_264152_(left, listTop);
        this.biomesListHolder.setSize(leftWidth, bottom - listTop - 4);
        this.biomesList.m_93488_(true);
        this.biomesList.m_93496_(false);
        this.biomesList.m_5988_((Collection<BiomesList.BiomeEntry>)((BiomeListFilter)((Object)this.filterCycleButton.m_168883_())).apply(this.previewContainer.allBiomes()));
        this.colorChooser.setSquareSize(screenRectangle.f_263770_() / 4);
        this.colorChooser.m_264152_(left + leftWidth + 8, top + (bottom - top) / 2 - this.colorChooser.m_93694_() / 2);
        this.layout.m_264036_();
        left = this.colorChooser.m_252754_() + this.colorChooser.m_5711_();
        ScreenRectangle controlRectangle = new ScreenRectangle(left, top + 2, screenRectangle.m_274445_() - left + 16, bottom - top - 2);
        FrameLayout.m_274605_((LayoutElement)this.layout, (ScreenRectangle)controlRectangle, (float)0.5f, (float)0.5f);
    }

    private boolean validateMaxInt(String in, int max) {
        if (in.isBlank()) {
            return true;
        }
        try {
            int i = Integer.parseInt(in);
            return i >= 0 && i <= max;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private int intOrZero(String src) {
        return src.isBlank() ? 0 : Integer.parseInt(src);
    }

    private void updateIfChanged(EditBox box, int value) {
        String strValue = String.valueOf(value);
        if (!box.m_94155_().equals(strValue)) {
            box.m_94144_(strValue);
        }
    }

    public static enum BiomeListFilter {
        DIMENSION(x -> {
            LevelStem levelStem = (LevelStem)x.previewTab().levelStemRegistry().m_7745_(WorldPreview.get().renderSettings().dimension);
            if (levelStem == null) {
                return true;
            }
            Set supportedBiomes = levelStem.f_63976_().m_62218_().m_207840_().stream().map(Holder::m_203543_).map(Optional::orElseThrow).map(ResourceKey::m_135782_).collect(Collectors.toSet());
            return supportedBiomes.contains(x.entry().m_205785_().m_135782_());
        }),
        ALL(x -> true),
        MISSING(x -> x.dataSource() == PreviewData.DataSource.MISSING),
        CUSTOM(x -> x.dataSource() == PreviewData.DataSource.CONFIG),
        MISSING_CUSTOM(x -> x.dataSource() == PreviewData.DataSource.MISSING || x.dataSource() == PreviewData.DataSource.CONFIG),
        DATA_PACK(x -> x.dataSource() == PreviewData.DataSource.RESOURCE),
        DATA_PACK_CUSTOM(x -> x.dataSource() == PreviewData.DataSource.RESOURCE || x.dataSource() == PreviewData.DataSource.CONFIG);

        private final Predicate<BiomesList.BiomeEntry> filterFn;

        private BiomeListFilter(Predicate<BiomesList.BiomeEntry> filterFn) {
            this.filterFn = filterFn;
        }

        public List<BiomesList.BiomeEntry> apply(List<BiomesList.BiomeEntry> orig) {
            return orig.stream().filter(this.filterFn).toList();
        }

        public static Component toComponent(BiomeListFilter x) {
            return Component.m_237115_((String)("world_preview.settings.biomes.filter." + x.name()));
        }
    }
}

