/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.client.gui.screens;

import caeruleusTait.world.preview.RenderSettings;
import caeruleusTait.world.preview.WorldPreview;
import caeruleusTait.world.preview.WorldPreviewConfig;
import caeruleusTait.world.preview.backend.WorkManager;
import caeruleusTait.world.preview.backend.color.ColorMap;
import caeruleusTait.world.preview.backend.color.PreviewData;
import caeruleusTait.world.preview.backend.color.PreviewMappingData;
import caeruleusTait.world.preview.client.WorldPreviewComponents;
import caeruleusTait.world.preview.client.gui.PreviewContainerDataProvider;
import caeruleusTait.world.preview.client.gui.PreviewDisplayDataProvider;
import caeruleusTait.world.preview.client.gui.screens.SettingsScreen;
import caeruleusTait.world.preview.client.gui.widgets.PreviewDisplay;
import caeruleusTait.world.preview.client.gui.widgets.ToggleButton;
import caeruleusTait.world.preview.client.gui.widgets.lists.AbstractSelectionListHolder;
import caeruleusTait.world.preview.client.gui.widgets.lists.BiomesList;
import caeruleusTait.world.preview.client.gui.widgets.lists.SeedsList;
import caeruleusTait.world.preview.client.gui.widgets.lists.StructuresList;
import caeruleusTait.world.preview.mixin.client.ScreenAccessor;
import com.mojang.blaze3d.platform.NativeImage;
import it.unimi.dsi.fastutil.shorts.Short2LongMap;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.worldselection.WorldCreationContext;
import net.minecraft.core.Holder;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.jetbrains.annotations.Nullable;

public class PreviewContainer
implements AutoCloseable,
PreviewDisplayDataProvider {
    public static final TagKey<Biome> C_CAVE = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("c", "caves"));
    public static final TagKey<Biome> C_IS_CAVE = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("c", "is_cave"));
    public static final TagKey<Biome> FORGE_CAVE = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("forge", "caves"));
    public static final TagKey<Biome> FORGE_IS_CAVE = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("forge", "is_cave"));
    public static final TagKey<Structure> DISPLAY_BY_DEFAULT = TagKey.m_203882_((ResourceKey)Registries.f_256944_, (ResourceLocation)new ResourceLocation("c", "display_on_map_by_default"));
    public static final ResourceLocation BUTTONS_TEXTURE = new ResourceLocation("world_preview:textures/gui/buttons.png");
    public static final int BUTTONS_TEX_WIDTH = 320;
    public static final int BUTTONS_TEX_HEIGHT = 60;
    public static final int LINE_HEIGHT = 20;
    public static final int LINE_VSPACE = 4;
    private final PreviewContainerDataProvider dataProvider;
    private final Minecraft minecraft;
    private final WorldPreview worldPreview;
    private final WorldPreviewConfig cfg;
    private final WorkManager workManager;
    private final RenderSettings renderSettings;
    private final PreviewMappingData previewMappingData;
    private PreviewData previewData;
    private List<ResourceLocation> levelStemKeys;
    private Registry<LevelStem> levelStemRegistry;
    private final EditBox seedEdit;
    private final Button randomSeedButton;
    private final Button saveSeed;
    private final Button settings;
    private final Button resetToZeroZero;
    private final ToggleButton toggleCaves;
    private final ToggleButton toggleShowStructures;
    private final ToggleButton toggleHeightmap;
    private final ToggleButton toggleIntersections;
    private final Button resetDefaultStructureVisibility;
    private final Button switchBiomes;
    private final Button switchStructures;
    private final Button switchSeeds;
    private final PreviewDisplay previewDisplay;
    private final BiomesList biomesList;
    private final StructuresList structuresList;
    private final SeedsList seedsList;
    private final AbstractSelectionListHolder<BiomesList.BiomeEntry, BiomesList> biomesListHolder;
    private final AbstractSelectionListHolder<StructuresList.StructureEntry, StructuresList> structuresListHolder;
    private final AbstractSelectionListHolder<SeedsList.SeedEntry, SeedsList> seedsListHolder;
    private BiomesList.BiomeEntry[] allBiomes;
    private StructuresList.StructureEntry[] allStructures;
    private NativeImage[] allStructureIcons;
    private List<SeedsList.SeedEntry> seedEntries;
    private boolean inhibitUpdates = true;
    private boolean isUpdating = false;
    private final Executor reloadExecutor = Executors.newSingleThreadExecutor();
    private final AtomicInteger reloadRevision = new AtomicInteger(0);
    private final List<AbstractWidget> toRender = new ArrayList<AbstractWidget>();

    public PreviewContainer(Screen screen, PreviewContainerDataProvider previewContainerDataProvider) {
        Font font = ((ScreenAccessor)screen).getFont();
        this.dataProvider = previewContainerDataProvider;
        this.minecraft = ((ScreenAccessor)screen).getMinecraft();
        this.allBiomes = new BiomesList.BiomeEntry[0];
        this.worldPreview = WorldPreview.get();
        this.cfg = this.worldPreview.cfg();
        this.workManager = this.worldPreview.workManager();
        this.previewMappingData = this.worldPreview.biomeColorMap();
        this.renderSettings = this.worldPreview.renderSettings();
        this.seedEdit = new EditBox(font, 0, 0, 100, 18, WorldPreviewComponents.SEED_FIELD);
        this.seedEdit.m_257771_(WorldPreviewComponents.SEED_FIELD);
        this.seedEdit.m_94144_(this.dataProvider.seed());
        this.seedEdit.m_94151_(this::setSeed);
        this.seedEdit.m_257544_(Tooltip.m_257550_((Component)WorldPreviewComponents.SEED_LABEL));
        this.seedEdit.f_93623_ = this.dataProvider.seedIsEditable();
        this.toRender.add((AbstractWidget)this.seedEdit);
        this.randomSeedButton = new ImageButton(0, 0, 20, 20, 0, 20, 20, BUTTONS_TEXTURE, 320, 60, this::randomizeSeed);
        this.randomSeedButton.m_257544_(Tooltip.m_257550_((Component)WorldPreviewComponents.BTN_RANDOM));
        this.randomSeedButton.f_93623_ = this.dataProvider.seedIsEditable();
        this.toRender.add((AbstractWidget)this.randomSeedButton);
        this.saveSeed = new ImageButton(0, 0, 20, 20, 20, 20, 20, BUTTONS_TEXTURE, 320, 60, this::saveCurrentSeed);
        this.saveSeed.m_257544_(Tooltip.m_257550_((Component)WorldPreviewComponents.BTN_SAVE_SEED));
        this.saveSeed.f_93623_ = false;
        this.toRender.add((AbstractWidget)this.saveSeed);
        this.settings = new ImageButton(0, 0, 20, 20, 60, 20, 20, BUTTONS_TEXTURE, 320, 60, x -> {
            this.workManager.cancel();
            this.minecraft.m_91152_((Screen)new SettingsScreen(screen, this));
        });
        this.settings.m_257544_(Tooltip.m_257550_((Component)WorldPreviewComponents.BTN_SETTINGS));
        this.settings.f_93623_ = false;
        this.toRender.add((AbstractWidget)this.settings);
        this.resetToZeroZero = new ImageButton(0, 0, 20, 20, 120, 20, 20, BUTTONS_TEXTURE, 320, 60, x -> this.renderSettings.resetCenter());
        this.resetToZeroZero.m_257544_(Tooltip.m_257550_((Component)WorldPreviewComponents.BTN_HOME));
        this.toRender.add((AbstractWidget)this.resetToZeroZero);
        this.resetDefaultStructureVisibility = Button.m_253074_((Component)WorldPreviewComponents.BTN_RESET_STRUCTURES, x -> Arrays.stream(this.allStructures).forEach(StructuresList.StructureEntry::reset)).m_253136_();
        this.resetDefaultStructureVisibility.m_257544_(Tooltip.m_257550_((Component)WorldPreviewComponents.BTN_RESET_STRUCTURES_TOOLTIP));
        this.resetDefaultStructureVisibility.f_93624_ = false;
        this.toRender.add((AbstractWidget)this.resetDefaultStructureVisibility);
        this.switchBiomes = Button.m_253074_((Component)DisplayType.BIOMES.component(), x -> this.onTabButtonChange(x, DisplayType.BIOMES)).m_253046_(100, 20).m_253136_();
        this.switchStructures = Button.m_253074_((Component)DisplayType.STRUCTURES.component(), x -> this.onTabButtonChange(x, DisplayType.STRUCTURES)).m_253046_(100, 20).m_253136_();
        this.switchSeeds = Button.m_253074_((Component)DisplayType.SEEDS.component(), x -> this.onTabButtonChange(x, DisplayType.SEEDS)).m_253046_(100, 20).m_253136_();
        this.toRender.add((AbstractWidget)this.switchBiomes);
        this.toRender.add((AbstractWidget)this.switchStructures);
        this.toRender.add((AbstractWidget)this.switchSeeds);
        this.biomesList = new BiomesList(this, this.minecraft, 200, 300, 4, 100, true);
        this.biomesListHolder = new AbstractSelectionListHolder(this.biomesList, 0, 0, screen.f_96543_, screen.f_96544_, WorldPreviewComponents.TITLE);
        this.biomesListHolder.f_93624_ = true;
        this.toRender.add(this.biomesListHolder);
        this.structuresList = new StructuresList(this.minecraft, 200, 300, 4, 100);
        this.structuresListHolder = new AbstractSelectionListHolder(this.structuresList, 0, 0, screen.f_96543_, screen.f_96544_, WorldPreviewComponents.TITLE);
        this.structuresListHolder.f_93624_ = false;
        this.toRender.add(this.structuresListHolder);
        this.seedsList = new SeedsList(this.minecraft, this);
        this.seedsListHolder = new AbstractSelectionListHolder(this.seedsList, 0, 0, screen.f_96543_, screen.f_96544_, WorldPreviewComponents.TITLE);
        this.seedsListHolder.f_93624_ = false;
        this.updateSeedListWidget();
        this.toRender.add(this.seedsListHolder);
        this.previewDisplay = new PreviewDisplay(this.minecraft, this, WorldPreviewComponents.TITLE);
        this.toRender.add(this.previewDisplay);
        this.toggleCaves = new ToggleButton(0, 0, 20, 20, 80, 20, 20, 20, BUTTONS_TEXTURE, 320, 60, x -> {
            this.biomesList.setSelected(null);
            this.previewDisplay.setSelectedBiomeId((short)-1);
            this.previewDisplay.setHighlightCaves(((ToggleButton)x).selected);
        });
        this.toggleCaves.m_257544_(Tooltip.m_257550_((Component)WorldPreviewComponents.BTN_CAVES));
        this.toRender.add((AbstractWidget)this.toggleCaves);
        this.toggleShowStructures = new ToggleButton(0, 0, 20, 20, 140, 20, 20, 20, BUTTONS_TEXTURE, 320, 60, x -> {
            this.renderSettings.hideAllStructures = !((ToggleButton)x).selected;
        });
        this.toggleShowStructures.selected = true;
        this.toggleShowStructures.f_93623_ = false;
        this.toRender.add((AbstractWidget)this.toggleShowStructures);
        this.toggleHeightmap = new ToggleButton(0, 0, 20, 20, 200, 20, 20, 20, BUTTONS_TEXTURE, 320, 60, x -> {
            this.renderSettings.showHeightMap = ((ToggleButton)x).selected;
            if (this.renderSettings.showHeightMap) {
                this.renderSettings.showIntersections = false;
                this.toggleIntersections().selected = false;
            }
        });
        this.toggleHeightmap.selected = false;
        this.toggleHeightmap.f_93623_ = false;
        this.toRender.add((AbstractWidget)this.toggleHeightmap);
        this.toggleIntersections = new ToggleButton(0, 0, 20, 20, 240, 20, 20, 20, BUTTONS_TEXTURE, 320, 60, x -> {
            this.renderSettings.showIntersections = ((ToggleButton)x).selected;
            if (this.renderSettings.showIntersections) {
                this.renderSettings.showHeightMap = false;
                this.toggleHeightmap().selected = false;
            }
        });
        this.toggleIntersections.selected = false;
        this.toggleIntersections.f_93623_ = false;
        this.toRender.add((AbstractWidget)this.toggleIntersections);
        this.biomesList.setBiomeChangeListener(x -> {
            this.previewDisplay.setSelectedBiomeId(x == null ? (short)-1 : (short)x.id());
            this.toggleCaves.selected = x == null && this.toggleCaves.selected;
            this.previewDisplay.setHighlightCaves(x == null && this.toggleCaves.selected);
        });
        this.dataProvider.registerSettingsChangeListener(this::updateSettings);
        this.onTabButtonChange(this.switchBiomes, DisplayType.BIOMES);
    }

    public void patchColorData() {
        Map<ResourceLocation, PreviewMappingData.ColorEntry> configured = Arrays.stream(this.allBiomes).filter(x -> x.dataSource() == PreviewData.DataSource.CONFIG).collect(Collectors.toMap(x -> x.entry().m_205785_().m_135782_(), x -> new PreviewMappingData.ColorEntry(PreviewData.DataSource.MISSING, x.color(), x.isCave(), x.name())));
        Map<ResourceLocation, PreviewMappingData.ColorEntry> defaults = Arrays.stream(this.allBiomes).filter(x -> x.dataSource() == PreviewData.DataSource.RESOURCE).collect(Collectors.toMap(x -> x.entry().m_205785_().m_135782_(), x -> new PreviewMappingData.ColorEntry(PreviewData.DataSource.RESOURCE, x.color(), x.isCave(), x.name())));
        Map<ResourceLocation, PreviewMappingData.ColorEntry> missing = Arrays.stream(this.allBiomes).filter(x -> x.dataSource() == PreviewData.DataSource.MISSING).collect(Collectors.toMap(x -> x.entry().m_205785_().m_135782_(), x -> new PreviewMappingData.ColorEntry(PreviewData.DataSource.CONFIG, x.color(), x.isCave(), x.name())));
        this.previewMappingData.update(missing);
        this.previewMappingData.update(defaults);
        this.previewMappingData.update(configured);
        this.updateSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateSettings() {
        if (this.inhibitUpdates) {
            return;
        }
        this.inhibitUpdates = true;
        try {
            int revision;
            AtomicInteger atomicInteger = this.reloadRevision;
            synchronized (atomicInteger) {
                revision = this.reloadRevision.incrementAndGet();
            }
            this.isUpdating = true;
            CompletableFuture.supplyAsync(() -> {
                if (this.reloadRevision.get() > revision) {
                    return null;
                }
                try {
                    return this.dataProvider.previewWorldCreationContext();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    throw e;
                }
            }, this.reloadExecutor).thenAcceptAsync(x -> {
                if (this.reloadRevision.get() > revision) {
                    return;
                }
                try {
                    this.updateSettings_real((WorldCreationContext)x);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    throw e;
                }
                AtomicInteger atomicInteger = this.reloadRevision;
                synchronized (atomicInteger) {
                    if (this.reloadRevision.get() <= revision) {
                        this.isUpdating = false;
                    }
                }
            }, (Executor)this.minecraft);
        }
        finally {
            this.inhibitUpdates = false;
        }
    }

    private void updateSettings_real(@Nullable WorldCreationContext wcContext) {
        this.saveSeed.f_93623_ = !this.dataProvider.seed().isEmpty() && !this.cfg.savedSeeds.contains(this.dataProvider.seed());
        this.updateSeedListWidget();
        this.seedEdit.m_94144_(this.dataProvider.seed());
        if (!this.seedEdit.m_93696_()) {
            this.seedEdit.m_94198_();
        }
        if (this.cfg.heightmapMinY == this.cfg.heightmapMaxY) {
            ++this.cfg.heightmapMaxY;
        } else if (this.cfg.heightmapMaxY < this.cfg.heightmapMinY) {
            int tmp = this.cfg.heightmapMaxY;
            this.cfg.heightmapMaxY = this.cfg.heightmapMinY;
            this.cfg.heightmapMinY = tmp;
        }
        WorldDataConfiguration worldDataConfiguration = this.dataProvider.worldDataConfiguration(wcContext);
        Registry biomeRegistry = this.dataProvider.registryAccess(wcContext).m_175515_(Registries.f_256952_);
        Registry strucutreRegistry = this.dataProvider.registryAccess(wcContext).m_175515_(Registries.f_256944_);
        this.levelStemRegistry = this.dataProvider.levelStemRegistry(wcContext);
        this.levelStemKeys = this.levelStemRegistry.m_6566_().stream().sorted(Comparator.comparing(Object::toString)).toList();
        this.settings.f_93623_ = true;
        if (this.renderSettings.dimension == null || !this.levelStemRegistry.m_7804_(this.renderSettings.dimension)) {
            this.renderSettings.dimension = this.levelStemRegistry.m_142003_(LevelStem.f_63971_) ? LevelStem.f_63971_.m_135782_() : (ResourceLocation)this.levelStemRegistry.m_6566_().iterator().next();
        }
        LevelStem levelStem = (LevelStem)this.levelStemRegistry.m_7745_(this.renderSettings.dimension);
        HashSet<ResourceLocation> caveBiomes = new HashSet<ResourceLocation>();
        for (TagKey<Biome> tagKey : List.of(C_CAVE, C_IS_CAVE, FORGE_CAVE, FORGE_IS_CAVE)) {
            caveBiomes.addAll(StreamSupport.stream(biomeRegistry.m_206058_(tagKey).spliterator(), false).map(x -> ((ResourceKey)x.m_203543_().orElseThrow()).m_135782_()).toList());
        }
        this.previewData = this.previewMappingData.generateMapData(biomeRegistry.m_6566_(), caveBiomes, strucutreRegistry.m_6566_(), StreamSupport.stream(strucutreRegistry.m_206058_(DISPLAY_BY_DEFAULT).spliterator(), false).map(x -> ((ResourceKey)x.m_203543_().orElseThrow()).m_135782_()).collect(Collectors.toSet()));
        ColorMap colorMap = this.previewData.colorMaps().get(this.cfg.colorMap);
        if (colorMap == null) {
            this.cfg.colorMap = "world_preview:inferno";
        }
        LayeredRegistryAccess<RegistryLayer> layeredRegistryAccess = this.dataProvider.layeredRegistryAccess(wcContext);
        this.workManager.cancel();
        this.workManager.changeWorldGenState(levelStem, layeredRegistryAccess, this.previewData, this.dataProvider.worldOptions(wcContext), worldDataConfiguration, this.minecraft.m_91096_(), this.dataProvider.tempDataPackDir(), this.dataProvider.minecraftServer());
        List<String> missing = Arrays.stream(this.previewData.biomeId2BiomeData()).filter(x -> x.dataSource() == PreviewData.DataSource.MISSING).map(PreviewData.BiomeData::tag).map(ResourceLocation::toString).toList();
        this.worldPreview.writeMissingColors(missing);
        this.allBiomes = (BiomesList.BiomeEntry[])biomeRegistry.m_203611_().map(x -> {
            short id = this.previewData.biome2Id().getShort((Object)x.m_205785_().m_135782_().toString());
            PreviewData.BiomeData biomeData = this.previewData.biomeId2BiomeData()[id];
            int color = biomeData.color();
            int initialColor = biomeData.resourceOnlyColor();
            boolean isCave = biomeData.isCave();
            boolean initialIsCave = biomeData.resourceOnlyIsCave();
            String explicitName = biomeData.name();
            PreviewData.DataSource dataSource = biomeData.dataSource();
            return this.biomesList.createEntry((Holder.Reference<Biome>)x, id, color, initialColor, isCave, initialIsCave, explicitName, dataSource);
        }).sorted(Comparator.comparing(BiomesList.BiomeEntry::id)).toArray(BiomesList.BiomeEntry[]::new);
        this.biomesList.m_5988_((Collection<BiomesList.BiomeEntry>)new ArrayList<BiomesList.BiomeEntry>());
        this.biomesList.setSelected(null);
        missing = Arrays.stream(this.previewData.structId2StructData()).filter(x -> x.dataSource() == PreviewData.DataSource.MISSING).map(PreviewData.StructureData::tag).map(ResourceLocation::toString).toList();
        this.worldPreview.writeMissingStructures(missing);
        this.freeStructureIcons();
        ResourceManager builtinResourceManager = this.minecraft.m_91098_();
        HashMap<ResourceLocation, NativeImage> icons = new HashMap<ResourceLocation, NativeImage>();
        this.allStructureIcons = new NativeImage[this.previewData.structId2StructData().length];
        for (int i = 0; i < this.previewData.structId2StructData().length; ++i) {
            PreviewData.StructureData data = this.previewData.structId2StructData()[i];
            this.allStructureIcons[i] = icons.computeIfAbsent(data.icon(), x -> {
                NativeImage nativeImage;
                block12: {
                    Optional resource;
                    if (x == null) {
                        x = new ResourceLocation("world_preview:textures/structure/unknown.png");
                    }
                    if ((resource = builtinResourceManager.m_213713_(x)).isEmpty()) {
                        resource = this.workManager.sampleResourceManager().m_213713_(x);
                    }
                    if (resource.isEmpty()) {
                        WorldPreview.LOGGER.error("Failed to load structure icon: '{}'", x);
                        resource = builtinResourceManager.m_213713_(new ResourceLocation("world_preview:textures/structure/unknown.png"));
                    }
                    if (resource.isEmpty()) {
                        WorldPreview.LOGGER.error("FATAL ERROR LOADING: '{}' -- unable to load fallback!", x);
                        return null;
                    }
                    InputStream in = ((Resource)resource.get()).m_215507_();
                    try {
                        nativeImage = NativeImage.m_85058_((InputStream)in);
                        if (in == null) break block12;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            return null;
                        }
                    }
                    in.close();
                }
                return nativeImage;
            });
        }
        Registry itemRegistry = layeredRegistryAccess.m_247579_().m_175515_(Registries.f_256913_);
        this.allStructures = (StructuresList.StructureEntry[])strucutreRegistry.m_203611_().map(x -> {
            short id = this.previewData.struct2Id().getShort((Object)x.m_205785_().m_135782_().toString());
            PreviewData.StructureData structureData = this.previewData.structId2StructData()[id];
            return this.structuresList.createEntry(id, x.m_205785_().m_135782_(), this.allStructureIcons[id], structureData.item() == null ? null : (Item)itemRegistry.m_7745_(structureData.item()), structureData.name(), structureData.showByDefault(), structureData.showByDefault());
        }).sorted(Comparator.comparing(StructuresList.StructureEntry::id)).toArray(StructuresList.StructureEntry[]::new);
        this.structuresList.m_5988_((Collection<StructuresList.StructureEntry>)new ArrayList<StructuresList.StructureEntry>());
        this.renderSettings.resetCenter();
        if (this.cfg.sampleStructures) {
            this.toggleShowStructures.f_93623_ = true;
            this.toggleShowStructures.m_257544_(Tooltip.m_257550_((Component)WorldPreviewComponents.BTN_TOGGLE_STRUCTURES));
        } else {
            this.toggleShowStructures.f_93623_ = false;
            this.toggleShowStructures.m_257544_(Tooltip.m_257550_((Component)WorldPreviewComponents.BTN_TOGGLE_STRUCTURES_DISABLED));
        }
        if (this.cfg.sampleHeightmap) {
            this.toggleHeightmap.f_93623_ = true;
            this.toggleHeightmap.m_257544_(Tooltip.m_257550_((Component)WorldPreviewComponents.BTN_TOGGLE_HEIGHTMAP));
        } else {
            this.toggleHeightmap.f_93623_ = false;
            this.toggleHeightmap.m_257544_(Tooltip.m_257550_((Component)WorldPreviewComponents.BTN_TOGGLE_HEIGHTMAP_DISABLED));
            this.renderSettings.showHeightMap = false;
        }
        if (this.cfg.sampleIntersections) {
            this.toggleIntersections.f_93623_ = true;
            this.toggleIntersections.m_257544_(Tooltip.m_257550_((Component)WorldPreviewComponents.BTN_TOGGLE_INTERSECT));
        } else {
            this.toggleIntersections.f_93623_ = false;
            this.toggleIntersections.m_257544_(Tooltip.m_257550_((Component)WorldPreviewComponents.BTN_TOGGLE_INTERSECT_DISABLED));
            this.renderSettings.showIntersections = false;
        }
        this.previewDisplay.reloadData();
        this.previewDisplay.setSelectedBiomeId((short)-1);
        this.previewDisplay.setHighlightCaves(false);
        this.toggleCaves.selected = false;
    }

    @Override
    public void onVisibleBiomesChanged(Short2LongMap visibleBiomes) {
        List<BiomesList.BiomeEntry> res = visibleBiomes.short2LongEntrySet().stream().sorted(Comparator.comparing(Short2LongMap.Entry::getLongValue).reversed()).map(Short2LongMap.Entry::getShortKey).map(x -> this.allBiomes[x]).toList();
        this.biomesList.m_5988_((Collection<BiomesList.BiomeEntry>)res);
    }

    @Override
    public void onVisibleStructuresChanged(Short2LongMap visibleStructures) {
        List<StructuresList.StructureEntry> res = visibleStructures.short2LongEntrySet().stream().sorted(Comparator.comparing(Short2LongMap.Entry::getLongValue)).map(Short2LongMap.Entry::getShortKey).map(x -> this.allStructures[x]).toList();
        this.structuresList.m_5988_((Collection<StructuresList.StructureEntry>)res);
    }

    private void randomizeSeed(Button btn) {
        UUID uuid = UUID.randomUUID();
        ByteBuffer bb = ByteBuffer.allocate(16);
        bb.putLong(uuid.getMostSignificantBits());
        bb.putLong(uuid.getLeastSignificantBits());
        String uuidSeed = Base64.getEncoder().encodeToString(bb.array()).substring(0, 16);
        this.setSeed(uuidSeed);
    }

    private void saveCurrentSeed(Button btn) {
        this.cfg.savedSeeds.add(this.dataProvider.seed());
        this.saveSeed.f_93623_ = false;
        this.updateSeedListWidget();
    }

    public void deleteSeed(String seed) {
        this.cfg.savedSeeds.remove(seed);
        this.updateSeedListWidget();
    }

    public void setSeed(String seed) {
        if (Objects.equals(this.dataProvider.seed(), seed) || !this.dataProvider.seedIsEditable()) {
            return;
        }
        boolean initialInhibitUpdates = this.inhibitUpdates;
        this.inhibitUpdates = true;
        try {
            this.dataProvider.updateSeed(seed);
        }
        finally {
            this.inhibitUpdates = initialInhibitUpdates;
        }
        this.updateSettings();
    }

    private void updateSeedListWidget() {
        this.seedEntries = this.cfg.savedSeeds.stream().map(this.seedsList::createEntry).toList();
        this.seedsList.m_5988_(this.seedEntries);
        int idx = this.cfg.savedSeeds.indexOf(this.dataProvider.seed());
        if (idx >= 0) {
            this.seedsList.m_6987_((AbstractSelectionList.Entry)this.seedEntries.get(idx));
        }
    }

    public void resetTabs() {
        this.onTabButtonChange(this.switchBiomes, DisplayType.BIOMES);
    }

    private void onTabButtonChange(Button btn, DisplayType type) {
        this.biomesListHolder.f_93624_ = false;
        this.structuresListHolder.f_93624_ = false;
        this.seedsListHolder.f_93624_ = false;
        this.switchBiomes.f_93623_ = true;
        this.switchStructures.f_93623_ = true;
        this.switchSeeds.f_93623_ = true;
        this.resetDefaultStructureVisibility.f_93624_ = false;
        if (this.cfg.sampleStructures) {
            this.switchStructures.m_257544_(null);
        } else {
            this.switchStructures.m_257544_(Tooltip.m_257550_((Component)WorldPreviewComponents.BTN_SWITCH_STRUCT_DISABLED));
            this.switchStructures.f_93623_ = false;
        }
        btn.f_93623_ = false;
        switch (type) {
            case BIOMES: {
                this.biomesListHolder.f_93624_ = true;
                break;
            }
            case STRUCTURES: {
                this.resetDefaultStructureVisibility.f_93624_ = true;
                this.structuresListHolder.f_93624_ = true;
                break;
            }
            case SEEDS: {
                this.seedsListHolder.f_93624_ = true;
            }
        }
    }

    public synchronized void start() {
        WorldPreview.LOGGER.info("Start generating biome data...");
        if (this.dataProvider.seed().isEmpty()) {
            this.randomizeSeed(null);
        }
        this.inhibitUpdates = false;
        this.updateSettings();
    }

    public synchronized void stop() {
        WorldPreview.LOGGER.info("Stop generating biome data...");
        this.inhibitUpdates = true;
        this.workManager.cancel();
    }

    public void doLayout(ScreenRectangle screenRectangle) {
        int leftWidth = Math.max(130, Math.min(180, screenRectangle.f_263770_() / 3));
        int left = screenRectangle.m_274563_() + 3;
        int top = screenRectangle.m_274449_() + 2;
        int bottom = screenRectangle.m_274349_() - 32;
        this.previewDisplay.m_264152_(left + leftWidth + 3, top + 1);
        this.previewDisplay.setSize(screenRectangle.m_274445_() - this.previewDisplay.m_252754_() - 4, screenRectangle.m_274349_() - this.previewDisplay.m_252907_() - 14);
        this.seedEdit.m_93674_(leftWidth - 1 - 44);
        this.seedEdit.m_252865_(left);
        this.seedEdit.m_253211_(bottom + 1);
        this.randomSeedButton.m_252865_(left + leftWidth - 20);
        this.randomSeedButton.m_253211_(bottom);
        this.saveSeed.m_252865_(left + leftWidth - 22 - 20);
        this.saveSeed.m_253211_(bottom);
        int cycleWith = leftWidth - 110;
        int btnStart = left + cycleWith + 2;
        this.settings.m_264152_(left, top);
        int i = 0;
        this.toggleIntersections.m_264152_(btnStart + 22 * i++, top);
        this.toggleHeightmap.m_264152_(btnStart + 22 * i++, top);
        this.toggleShowStructures.m_264152_(btnStart + 22 * i++, top);
        this.toggleCaves.m_264152_(btnStart + 22 * i++, top);
        this.resetToZeroZero.m_264152_(btnStart + 22 * i++, top);
        int switchBiomesWidth = 45;
        int switchSeedsWidth = 45;
        int switchStructuresWidth = leftWidth - switchBiomesWidth - switchSeedsWidth - 4;
        this.switchBiomes.m_264152_(left, top += 24);
        this.switchStructures.m_264152_(left + switchBiomesWidth + 2, top);
        this.switchSeeds.m_264152_(left + switchBiomesWidth + switchStructuresWidth + 4, top);
        this.switchBiomes.m_93674_(switchBiomesWidth);
        this.switchStructures.m_93674_(switchStructuresWidth);
        this.switchSeeds.m_93674_(switchSeedsWidth);
        this.biomesListHolder.m_264152_(left, top += 24);
        this.biomesListHolder.setSize(leftWidth, bottom - top - 4);
        this.biomesList.m_93488_(true);
        this.biomesList.m_93496_(false);
        this.seedsListHolder.m_264152_(left, top);
        this.seedsListHolder.setSize(leftWidth, bottom - top - 4);
        this.seedsList.m_93488_(true);
        this.seedsList.m_93496_(false);
        this.resetDefaultStructureVisibility.m_264152_(left, bottom -= 24);
        this.resetDefaultStructureVisibility.m_93674_(leftWidth);
        this.structuresListHolder.m_264152_(left, top);
        this.structuresListHolder.setSize(leftWidth, bottom - top - 4);
        this.structuresList.m_93488_(true);
        this.structuresList.m_93496_(false);
    }

    @Override
    public void close() {
        this.workManager.cancel();
        this.previewDisplay.close();
        this.freeStructureIcons();
    }

    private void freeStructureIcons() {
        if (this.allStructureIcons == null) {
            return;
        }
        Arrays.stream(this.allStructureIcons).filter(Objects::nonNull).forEach(NativeImage::close);
    }

    public List<BiomesList.BiomeEntry> allBiomes() {
        return Arrays.stream(this.allBiomes).sorted(Comparator.comparing(BiomesList.BiomeEntry::name)).toList();
    }

    public List<ResourceLocation> levelStemKeys() {
        return this.levelStemKeys;
    }

    public Registry<LevelStem> levelStemRegistry() {
        return this.levelStemRegistry;
    }

    @Override
    public BiomesList.BiomeEntry biome4Id(int id) {
        return this.allBiomes[id];
    }

    @Override
    public StructuresList.StructureEntry structure4Id(int id) {
        return this.allStructures[id];
    }

    @Override
    public NativeImage[] structureIcons() {
        return this.allStructureIcons;
    }

    @Override
    public ItemStack[] structureItems() {
        return (ItemStack[])Arrays.stream(this.allStructures).map(StructuresList.StructureEntry::itemStack).toArray(ItemStack[]::new);
    }

    @Override
    public void onBiomeVisuallySelected(BiomesList.BiomeEntry entry) {
        this.biomesList.setSelected(entry, true);
        this.toggleCaves.selected = false;
        this.previewDisplay.setHighlightCaves(false);
    }

    @Override
    public PreviewData previewData() {
        return this.previewData;
    }

    @Override
    public PreviewDisplayDataProvider.StructureRenderInfo[] renderStructureMap() {
        return this.allStructures;
    }

    @Override
    public int[] heightColorMap() {
        ColorMap colorMap = this.previewData.colorMaps().get(this.cfg.colorMap);
        if (colorMap == null) {
            int[] black = new int[this.workManager.yMax() - this.workManager.yMin()];
            Arrays.fill(black, -16777216);
            return black;
        }
        return colorMap.bake(this.workManager.yMin(), this.workManager.yMax(), this.cfg.heightmapMinY, this.cfg.heightmapMaxY);
    }

    @Override
    public int yMin() {
        return this.workManager.yMin();
    }

    @Override
    public int yMax() {
        return this.workManager.yMax();
    }

    @Override
    public boolean isUpdating() {
        return this.isUpdating;
    }

    public ToggleButton toggleCaves() {
        return this.toggleCaves;
    }

    public ToggleButton toggleShowStructures() {
        return this.toggleShowStructures;
    }

    public ToggleButton toggleHeightmap() {
        return this.toggleHeightmap;
    }

    public ToggleButton toggleIntersections() {
        return this.toggleIntersections;
    }

    public PreviewContainerDataProvider dataProvider() {
        return this.dataProvider;
    }

    public List<AbstractWidget> widgets() {
        return this.toRender;
    }

    public static enum DisplayType {
        BIOMES,
        STRUCTURES,
        SEEDS;


        public Component component() {
            return DisplayType.toComponent(this);
        }

        public static Component toComponent(DisplayType x) {
            return Component.m_237115_((String)("world_preview.preview.btn-cycle." + x.name()));
        }
    }
}

