/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.backend.worker;

import caeruleusTait.world.preview.WorldPreview;
import caeruleusTait.world.preview.backend.storage.PreviewLevel;
import caeruleusTait.world.preview.backend.stubs.DummyMinecraftServer;
import caeruleusTait.world.preview.backend.stubs.EmptyAquifer;
import caeruleusTait.world.preview.mixin.MinecraftServerAccessor;
import caeruleusTait.world.preview.mixin.NoiseBasedChunkGeneratorAccessor;
import caeruleusTait.world.preview.mixin.NoiseChunkAccessor;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Lifecycle;
import java.io.File;
import java.io.IOException;
import java.net.Proxy;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.FileUtil;
import net.minecraft.Util;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.Services;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.repository.ServerPacksSource;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.datafix.DataFixers;
import net.minecraft.world.Difficulty;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelSettings;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureCheck;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.PrimaryLevelData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.validation.DirectoryValidator;
import net.minecraft.world.level.validation.PathAllowList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SampleUtils
implements AutoCloseable {
    private final Path tempDir;
    private final DataFixer dataFixer;
    private final LevelStorageSource.LevelStorageAccess levelStorageAccess;
    private final LevelHeightAccessor levelHeightAccessor;
    private final CloseableResourceManager resourceManager;
    private final BiomeSource biomeSource;
    private final RandomState randomState;
    private final ChunkGenerator chunkGenerator;
    private final RegistryAccess registryAccess;
    private final ChunkGeneratorStructureState chunkGeneratorStructureState;
    private final StructureCheck structureCheck;
    private final StructureManager structureManager;
    private final StructureTemplateManager structureTemplateManager;
    private final PreviewLevel previewLevel;
    private final Registry<Structure> structureRegistry;
    private final NoiseGeneratorSettings noiseGeneratorSettings;
    private final MinecraftServer minecraftServer;

    public SampleUtils(@NotNull MinecraftServer server, BiomeSource biomeSource, RandomState randomState, ChunkGenerator chunkGenerator, WorldOptions worldOptions, LevelStem levelStem, LevelHeightAccessor levelHeightAccessor) throws IOException {
        this.tempDir = null;
        this.minecraftServer = server;
        this.dataFixer = this.minecraftServer.m_129933_();
        this.levelStorageAccess = ((MinecraftServerAccessor)this.minecraftServer).getStorageSource();
        this.levelHeightAccessor = levelHeightAccessor;
        this.resourceManager = (CloseableResourceManager)this.minecraftServer.m_177941_();
        this.biomeSource = biomeSource;
        this.randomState = randomState;
        this.chunkGenerator = chunkGenerator;
        this.registryAccess = this.minecraftServer.m_206579_();
        this.structureRegistry = this.registryAccess.m_175515_(Registries.f_256944_);
        this.structureTemplateManager = this.minecraftServer.m_236738_();
        this.previewLevel = new PreviewLevel(this.registryAccess, this.levelHeightAccessor);
        ResourceKey levelStemResourceKey = (ResourceKey)this.registryAccess.m_175515_(Registries.f_256862_).m_7854_((Object)levelStem).orElseThrow();
        ResourceKey levelResourceKey = Registries.m_257551_((ResourceKey)levelStemResourceKey);
        this.structureCheck = new StructureCheck(null, this.registryAccess, this.structureTemplateManager, levelResourceKey, this.chunkGenerator, this.randomState, this.levelHeightAccessor, chunkGenerator.m_62218_(), worldOptions.m_245499_(), this.dataFixer);
        this.structureManager = new StructureManager((LevelAccessor)this.previewLevel, worldOptions, this.structureCheck);
        this.chunkGeneratorStructureState = this.chunkGenerator.m_255169_((HolderLookup)this.registryAccess.m_255025_(Registries.f_256998_), this.randomState, worldOptions.m_245499_());
        if (chunkGenerator instanceof NoiseBasedChunkGenerator) {
            NoiseBasedChunkGenerator noiseBasedChunkGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
            this.noiseGeneratorSettings = (NoiseGeneratorSettings)noiseBasedChunkGenerator.m_224341_().m_203334_();
        } else {
            this.noiseGeneratorSettings = null;
        }
    }

    public SampleUtils(BiomeSource biomeSource, RandomState randomState, ChunkGenerator chunkGenerator, LayeredRegistryAccess<RegistryLayer> layeredRegistryAccess, WorldOptions worldOptions, LevelStem levelStem, LevelHeightAccessor levelHeightAccessor, WorldDataConfiguration worldDataConfiguration, Proxy proxy, @Nullable Path tempDataPackDir) throws IOException {
        try {
            this.tempDir = Files.createTempDirectory("world_preview", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.dataFixer = DataFixers.m_14512_();
        LevelStorageSource levelStorageSource = new LevelStorageSource(this.tempDir, this.tempDir.resolve("backups"), new DirectoryValidator(new PathAllowList(List.of())), this.dataFixer);
        this.levelStorageAccess = levelStorageSource.m_78260_("world_preview");
        this.levelHeightAccessor = levelHeightAccessor;
        Path dataPackDir = this.levelStorageAccess.m_78283_(LevelResource.f_78180_);
        FileUtil.m_257659_((Path)dataPackDir);
        if (tempDataPackDir != null) {
            try (Stream<Path> stream = Files.walk(tempDataPackDir, new FileVisitOption[0]);){
                stream.filter(x -> !x.equals(tempDataPackDir)).forEach(x -> {
                    try {
                        Util.m_137563_((Path)tempDataPackDir, (Path)dataPackDir, (Path)x);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                });
            }
        }
        this.biomeSource = biomeSource;
        this.randomState = randomState;
        this.chunkGenerator = chunkGenerator;
        this.registryAccess = layeredRegistryAccess.m_247579_();
        this.structureRegistry = this.registryAccess.m_175515_(Registries.f_256944_);
        this.previewLevel = new PreviewLevel(this.registryAccess, this.levelHeightAccessor);
        this.chunkGeneratorStructureState = this.chunkGenerator.m_255169_((HolderLookup)this.registryAccess.m_255025_(Registries.f_256998_), this.randomState, worldOptions.m_245499_());
        PackRepository packRepository = ServerPacksSource.m_247728_((LevelStorageSource.LevelStorageAccess)this.levelStorageAccess);
        this.resourceManager = (CloseableResourceManager)new WorldLoader.PackConfig(packRepository, worldDataConfiguration, false, false).m_214399_().getSecond();
        HolderLookup holderGetter = this.registryAccess.m_175515_(Registries.f_256747_).m_255303_().m_245140_(worldDataConfiguration.f_243973_());
        this.structureTemplateManager = new StructureTemplateManager((ResourceManager)this.resourceManager, this.levelStorageAccess, this.dataFixer, (HolderGetter)holderGetter);
        ResourceKey levelStemResourceKey = (ResourceKey)this.registryAccess.m_175515_(Registries.f_256862_).m_7854_((Object)levelStem).orElseThrow();
        ResourceKey levelResourceKey = Registries.m_257551_((ResourceKey)levelStemResourceKey);
        this.structureCheck = new StructureCheck(null, this.registryAccess, this.structureTemplateManager, levelResourceKey, this.chunkGenerator, this.randomState, this.levelHeightAccessor, chunkGenerator.m_62218_(), worldOptions.m_245499_(), this.dataFixer);
        this.structureManager = new StructureManager((LevelAccessor)this.previewLevel, worldOptions, this.structureCheck);
        LevelSettings levelSettings = new LevelSettings("temp", GameType.CREATIVE, false, Difficulty.NORMAL, true, new GameRules(), worldDataConfiguration);
        PrimaryLevelData primaryLevelData = new PrimaryLevelData(levelSettings, worldOptions, PrimaryLevelData.SpecialWorldProperty.NONE, Lifecycle.stable());
        ReloadableServerResources reloadableServerResources = new ReloadableServerResources(layeredRegistryAccess.m_247579_(), FeatureFlagSet.m_246902_(), Commands.CommandSelection.ALL, 0);
        WorldStem worldStem = new WorldStem(this.resourceManager, reloadableServerResources, layeredRegistryAccess, (WorldData)primaryLevelData);
        this.minecraftServer = new DummyMinecraftServer(null, this.levelStorageAccess, packRepository, worldStem, proxy, this.dataFixer, new Services(null, null, null, null), i -> new ChunkProgressListener(){

            public void m_7647_(ChunkPos center) {
            }

            public void m_5511_(ChunkPos chunkPosition, @Nullable ChunkStatus newStatus) {
            }

            public void m_9662_() {
            }

            public void m_7646_() {
            }
        });
        if (chunkGenerator instanceof NoiseBasedChunkGenerator) {
            NoiseBasedChunkGenerator noiseBasedChunkGenerator = (NoiseBasedChunkGenerator)chunkGenerator;
            this.noiseGeneratorSettings = (NoiseGeneratorSettings)noiseBasedChunkGenerator.m_224341_().m_203334_();
        } else {
            this.noiseGeneratorSettings = null;
        }
        WorldPreview.get().loaderSpecificSetup(this.minecraftServer);
        this.chunkGeneratorStructureState.m_254958_();
    }

    public ResourceKey<Biome> doSample(BlockPos pos) {
        return (ResourceKey)this.biomeSource.m_203407_(QuartPos.m_175400_((int)pos.m_123341_()), QuartPos.m_175400_((int)pos.m_123342_()), QuartPos.m_175400_((int)pos.m_123343_()), this.randomState.m_224579_()).m_203543_().orElseThrow();
    }

    public List<Pair<ResourceLocation, StructureStart>> doStructures(ChunkPos chunkPos) {
        ProtoChunk protoChunk = (ProtoChunk)this.previewLevel.m_6522_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62326_, false);
        this.chunkGenerator.m_255037_(this.registryAccess, this.chunkGeneratorStructureState, this.structureManager, (ChunkAccess)protoChunk, this.structureTemplateManager);
        Map raw = protoChunk.m_6633_();
        ArrayList<Pair<ResourceLocation, StructureStart>> res = new ArrayList<Pair<ResourceLocation, StructureStart>>(raw.size());
        for (Map.Entry x : protoChunk.m_6633_().entrySet()) {
            res.add((Pair<ResourceLocation, StructureStart>)new Pair((Object)this.structureRegistry.m_7981_((Object)((Structure)x.getKey())), (Object)((StructureStart)x.getValue())));
        }
        return res;
    }

    public NoiseChunk getNoiseChunk(ChunkPos startChunk, int numChunks, boolean keepAquifer) {
        NoiseSettings noiseSettings = this.noiseGeneratorSettings.f_64439_();
        NoiseChunk noiseChunk = new NoiseChunk(numChunks * 16 / noiseSettings.m_189213_(), this.randomState, startChunk.m_45604_(), startChunk.m_45605_(), noiseSettings, (DensityFunctions.BeardifierOrMarker)DensityFunctions.BeardifierMarker.INSTANCE, this.noiseGeneratorSettings, ((NoiseBasedChunkGeneratorAccessor)this.chunkGenerator).getGlobalFluidPicker().get(), Blender.m_190153_());
        if (!keepAquifer) {
            ((NoiseChunkAccessor)noiseChunk).setAquifer(new EmptyAquifer());
        }
        return noiseChunk;
    }

    public NoiseGeneratorSettings noiseGeneratorSettings() {
        return this.noiseGeneratorSettings;
    }

    public short doHeightSlow(BlockPos pos) {
        return (short)this.chunkGenerator.m_214096_(pos.m_123341_(), pos.m_123343_(), Heightmap.Types.OCEAN_FLOOR_WG, this.levelHeightAccessor, this.randomState);
    }

    public NoiseColumn doIntersectionsSlow(BlockPos pos) {
        return this.chunkGenerator.m_214184_(pos.m_123341_(), pos.m_123343_(), this.levelHeightAccessor, this.randomState);
    }

    @Override
    public void close() throws Exception {
        if (this.minecraftServer instanceof DummyMinecraftServer) {
            WorldPreview.get().loaderSpecificTeardown(this.minecraftServer);
        }
        if (this.tempDir != null) {
            SampleUtils.deleteDirectoryLegacyIO(this.tempDir.toFile());
        }
    }

    public static void deleteDirectoryLegacyIO(File file) {
        File[] list = file.listFiles();
        if (list != null) {
            for (File temp : list) {
                SampleUtils.deleteDirectoryLegacyIO(temp);
            }
        }
        if (!file.delete()) {
            WorldPreview.LOGGER.warn("Unable to delete file or directory : {}", (Object)file);
        }
    }

    public CloseableResourceManager resourceManager() {
        return this.resourceManager;
    }

    public RegistryAccess registryAccess() {
        return this.registryAccess;
    }
}

