/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.backend.worker;

import caeruleusTait.world.preview.backend.color.PreviewData;
import caeruleusTait.world.preview.backend.sampler.ChunkSampler;
import caeruleusTait.world.preview.backend.worker.SampleUtils;
import caeruleusTait.world.preview.backend.worker.WorkResult;
import caeruleusTait.world.preview.backend.worker.WorkUnit;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;

public class FullChunkWorkUnit
extends WorkUnit {
    private final ChunkSampler sampler;
    private final int yMin;
    private final int yMax;
    private final int yStride;

    public FullChunkWorkUnit(ChunkSampler sampler, ChunkPos pos, SampleUtils sampleUtils, PreviewData previewData, int yMin, int yMax, int yStride) {
        super(sampleUtils, pos, previewData, 0);
        this.sampler = sampler;
        this.yMin = yMin;
        this.yMax = yMax;
        this.yStride = yStride;
    }

    @Override
    protected List<WorkResult> doWork() {
        ArrayList<WorkResult> results = new ArrayList<WorkResult>((this.yMax - this.yMin) / this.yStride);
        for (int y = this.yMin; y <= this.yMax; y += this.yStride) {
            WorkResult res = new WorkResult(this, QuartPos.m_175400_((int)y), y == this.y ? this.primarySection : this.storage.section4(this.chunkPos, y, this.flags()), new ArrayList<WorkResult.BlockResult>(16), List.of());
            for (BlockPos p : this.sampler.blocksForChunk(this.chunkPos, y)) {
                ResourceKey<Biome> biome = this.sampleUtils.doSample(p);
                this.sampler.expandRaw(p, this.biomeIdFrom(biome), res);
            }
            results.add(res);
        }
        return results;
    }

    @Override
    public long flags() {
        return 0L;
    }
}

