/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.backend.storage;

import caeruleusTait.world.preview.RenderSettings;
import caeruleusTait.world.preview.backend.storage.PreviewSection;
import caeruleusTait.world.preview.backend.storage.PreviewSectionFull;
import caeruleusTait.world.preview.backend.storage.PreviewSectionHalf;
import caeruleusTait.world.preview.backend.storage.PreviewSectionQuarter;
import caeruleusTait.world.preview.backend.storage.PreviewSectionStructure;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.ChunkPos;

public class PreviewStorage {
    public static final long FLAG_BITS = 4L;
    public static final long FLAG_MASK = 15L;
    public static final long XZ_BITS = 30L;
    public static final long XZ_MASK = 0x3FFFFFFFL;
    public static final long XZ_OFFSET = 0x20000000L;
    public static final long FLAG_SHIFT = 0L;
    public static final long Z_SHIFT = 4L;
    public static final long X_SHIFT = 34L;
    public static final long FLAG_BIOME = 0L;
    public static final long FLAG_STRUCT_START = 1L;
    public static final long FLAG_HEIGHT = 2L;
    public static final long FLAG_INTERSECT = 3L;
    public static final long FLAG_STRUCT_REF = 15L;
    private final Long2ObjectMap<PreviewSection>[] sections;
    private final RenderSettings renderSettings;
    private final int yMin;
    private final int yMax;

    public PreviewStorage(RenderSettings renderSettings, int yMin, int yMax) {
        this.sections = new Long2ObjectMap[(yMax - yMin >> 3) + 1];
        for (int i = 0; i < this.sections.length; ++i) {
            this.sections[i] = new Long2ObjectOpenHashMap(1024, 0.5f);
        }
        this.renderSettings = renderSettings;
        this.yMin = yMin;
        this.yMax = yMax;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreviewSection section4(BlockPos bp, long flags) {
        int quartX = QuartPos.m_175400_((int)bp.m_123341_());
        int indexY = bp.m_123342_() - this.yMin >> 3;
        int quartZ = QuartPos.m_175400_((int)bp.m_123343_());
        Long2ObjectMap<PreviewSection> long2ObjectMap = this.sections[indexY];
        synchronized (long2ObjectMap) {
            return (PreviewSection)this.sections[indexY].computeIfAbsent(PreviewStorage.quartPosToSectionLong(quartX, quartZ, flags), x -> this.sectionFactory(quartX, quartZ, flags));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreviewSection section4(ChunkPos chunkPos, int y, long flags) {
        int quartX = QuartPos.m_175404_((int)chunkPos.f_45578_);
        int indexY = y - this.yMin >> 3;
        int quartZ = QuartPos.m_175404_((int)chunkPos.f_45579_);
        Long2ObjectMap<PreviewSection> long2ObjectMap = this.sections[indexY];
        synchronized (long2ObjectMap) {
            return (PreviewSection)this.sections[indexY].computeIfAbsent(PreviewStorage.quartPosToSectionLong(quartX, quartZ, flags), x -> this.sectionFactory(quartX, quartZ, flags));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreviewSection section4(int quartX, int quartY, int quartZ, long flags) {
        int indexY = QuartPos.m_175402_((int)quartY) - this.yMin >> 3;
        Long2ObjectMap<PreviewSection> long2ObjectMap = this.sections[indexY];
        synchronized (long2ObjectMap) {
            return (PreviewSection)this.sections[indexY].computeIfAbsent(PreviewStorage.quartPosToSectionLong(quartX, quartZ, flags), x -> this.sectionFactory(quartX, quartZ, flags));
        }
    }

    private PreviewSection sectionFactory(int quartX, int quartZ, long flags) {
        if (flags == 1L) {
            return new PreviewSectionStructure(quartX, quartZ);
        }
        return switch (this.renderSettings.quartStride()) {
            case 1 -> new PreviewSectionFull(quartX, quartZ);
            case 2 -> new PreviewSectionHalf(quartX, quartZ);
            case 4 -> new PreviewSectionQuarter(quartX, quartZ);
            default -> throw new IllegalStateException("Unexpected quartStride value: " + this.renderSettings.quartStride());
        };
    }

    public short getBiome4(BlockPos bp) {
        int quartX = QuartPos.m_175400_((int)bp.m_123341_());
        int quartY = QuartPos.m_175400_((int)bp.m_123342_());
        int quartZ = QuartPos.m_175400_((int)bp.m_123343_());
        return this.getRawData4(quartX, quartY, quartZ, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getRawData4(int quartX, int quartY, int quartZ, long flags) {
        PreviewSection section;
        int indexY = QuartPos.m_175402_((int)quartY) - this.yMin >> 3;
        Long2ObjectMap<PreviewSection> long2ObjectMap = this.sections[indexY];
        synchronized (long2ObjectMap) {
            section = (PreviewSection)this.sections[indexY].get(PreviewStorage.quartPosToSectionLong(quartX, quartZ, flags));
        }
        if (section == null) {
            return Short.MIN_VALUE;
        }
        return section.get(quartX - section.quartX(), quartZ - section.quartZ());
    }

    public static long blockPos2SectionLong(BlockPos bp, long flags) {
        return PreviewStorage.quartPosToSectionLong(QuartPos.m_175400_((int)bp.m_123341_()), QuartPos.m_175400_((int)bp.m_123343_()), flags);
    }

    public static long quartPosToSectionLong(long quartX, long quartZ, long flags) {
        long sX = quartX >> 8;
        long sZ = quartZ >> 8;
        return (sX & 0x3FFFFFFFL) << 34 | (sZ & 0x3FFFFFFFL) << 4 | (flags & 0xFL) << 0;
    }

    public static long compressXYZ(long x, long z, long flags) {
        return (x & 0x3FFFFFFFL) << 34 | (z & 0x3FFFFFFFL) << 4 | (flags & 0xFL) << 0;
    }
}

