/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.backend.storage;

import java.util.BitSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public abstract class PreviewSection {
    public static final int SHIFT = 8;
    public static final int SIZE = 256;
    public static final int OFFSET = 128;
    public static final int MASK = -256;
    public static final int HALF_SHIFT = 1;
    public static final int HALF_SIZE = 128;
    public static final int QUART_TO_SECTION_SHIFT = 2;
    public static final int SECTION_SIZE = 64;
    private final int quartX;
    private final int quartZ;
    private final int chunkX;
    private final int chunkZ;
    private final BitSet completed = new BitSet(8192);

    protected PreviewSection(int quartX, int quartZ) {
        this.quartX = quartX & 0xFFFFFF00;
        this.quartZ = quartZ & 0xFFFFFF00;
        this.chunkX = this.quartX >> 2;
        this.chunkZ = this.quartZ >> 2;
    }

    public abstract int size();

    public abstract short get(int var1, int var2);

    public abstract void set(int var1, int var2, short var3);

    public abstract List<PreviewStruct> structures();

    public abstract void addStructure(PreviewStruct var1);

    public synchronized boolean isCompleted(ChunkPos chunkPos) {
        return this.completed.get((chunkPos.f_45578_ - this.chunkX) * 64 + (chunkPos.f_45579_ - this.chunkZ));
    }

    public synchronized void markCompleted(ChunkPos chunkPos) {
        this.completed.set((chunkPos.f_45578_ - this.chunkX) * 64 + (chunkPos.f_45579_ - this.chunkZ));
    }

    public AccessData calcQuartOffsetData(int minQuartX, int minQuartZ, int maxQuartX, int maxQuartZ) {
        int accessMinX = minQuartX - this.quartX;
        int accessMinZ = minQuartZ - this.quartZ;
        int accessMaxX = maxQuartX - this.quartX;
        int accessMaxZ = maxQuartZ - this.quartZ;
        return new AccessData(accessMinX, accessMinZ, Math.min(accessMaxX, 256), Math.min(accessMaxZ, 256), accessMaxX > 256, accessMaxZ > 256);
    }

    public int quartX() {
        return this.quartX;
    }

    public int quartZ() {
        return this.quartZ;
    }

    public int blockX() {
        return QuartPos.m_175402_((int)this.quartX);
    }

    public int blockZ() {
        return QuartPos.m_175402_((int)this.quartZ);
    }

    public record AccessData(int minX, int minZ, int maxX, int maxZ, boolean continueX, boolean continueZ) {
    }

    public record PreviewStruct(BlockPos center, short structureId, BoundingBox boundingBox) {
    }
}

