/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.backend.color;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;

public abstract class BaseMultiJsonResourceReloadListener
extends SimplePreparableReloadListener<Map<ResourceLocation, List<JsonElement>>> {
    protected static final Gson GSON = new GsonBuilder().create();
    private final String filename;

    protected BaseMultiJsonResourceReloadListener(String filename) {
        this.filename = filename;
    }

    protected Map<ResourceLocation, List<JsonElement>> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        HashMap<ResourceLocation, List<JsonElement>> res = new HashMap<ResourceLocation, List<JsonElement>>();
        for (String namespace : resourceManager.m_7187_()) {
            this.loadAllForLocation(resourceManager, res, new ResourceLocation(namespace, this.filename));
        }
        this.loadAllForLocation(resourceManager, res, new ResourceLocation("c", "worldgen/" + this.filename));
        return res;
    }

    private void loadAllForLocation(ResourceManager resourceManager, Map<ResourceLocation, List<JsonElement>> res, ResourceLocation rl) {
        for (Resource x : resourceManager.m_213829_(rl)) {
            try {
                BufferedReader reader = x.m_215508_();
                try {
                    List jsonElements = res.computeIfAbsent(rl, z -> new ArrayList());
                    jsonElements.add((JsonElement)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonElement.class));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

