/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public final class ReflectionUtils {
    @Nullable
    public static Entity getAttacker(DamageSource source) {
        return source.m_7639_();
    }

    public static float getFlyingSpeed(LivingEntity entity) {
        throw new NoSuchMethodError();
    }

    public static void setFlyingSpeed(LivingEntity entity, float speed) {
    }

    public static Optional<Field> getField(Optional<Class<?>> classObj, String fieldName) {
        return classObj.map(c -> {
            try {
                Field f = c.getDeclaredField(fieldName);
                f.setAccessible(true);
                return f;
            }
            catch (NoSuchFieldException | SecurityException exception) {
                return null;
            }
        });
    }

    public static void setField(Optional<Class<?>> classObj, String fieldName, Object object, Object value) {
        ReflectionUtils.getField(classObj, fieldName).ifPresent(f -> {
            try {
                f.set(object, value);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        });
    }

    public static Optional<Method> getMethod(Optional<Class<?>> classObj, String methodName, Class<?> ... args) {
        return classObj.map(c -> {
            try {
                Method m = c.getMethod(methodName, args);
                m.setAccessible(true);
                return m;
            }
            catch (NoSuchMethodException | SecurityException exception) {
                return null;
            }
        });
    }

    public static <T> Optional<Constructor<T>> getConstructor(Optional<Class<T>> clazz, Class<?> ... params) {
        return clazz.map(c -> {
            try {
                return c.getConstructor(params);
            }
            catch (NoSuchMethodException | SecurityException e) {
                return null;
            }
        });
    }

    public static Optional<Class<?>> getClass(String className, String ... classNames) {
        Optional<Class<?>> ret = ReflectionUtils.getClass(className);
        for (String name : classNames) {
            if (ret.isPresent()) {
                return ret;
            }
            ret = ReflectionUtils.getClass(name);
        }
        return ret;
    }

    public static Optional<Class<?>> getClass(String className) {
        try {
            return Optional.of(Class.forName(className));
        }
        catch (ClassNotFoundException classNotFoundException) {
            return Optional.empty();
        }
    }

    private ReflectionUtils() {
    }
}

