/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.register.helpers;

import com.epherical.croptopia.CroptopiaMod;
import com.epherical.croptopia.blocks.CroptopiaSaplingBlock;
import com.epherical.croptopia.generator.CroptopiaSaplingGenerator;
import com.epherical.croptopia.register.TagCategory;
import com.epherical.croptopia.util.BlockConvertible;
import com.epherical.croptopia.util.ItemConvertibleWithPlural;
import com.epherical.croptopia.util.RegisterFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemNameBlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.SimpleStateProvider;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.material.MapColor;

public class Tree
implements ItemConvertibleWithPlural,
BlockConvertible {
    private static final List<Tree> TREES = new ArrayList<Tree>();
    private final String name;
    private final boolean hasPlural;
    private final TagCategory tagCategory;
    private final Item item;
    private Block log;
    private Block strippedLog;
    private Block wood;
    private Block strippedWood;
    private final TagKey<Item> logItemTag;
    private final TagKey<Block> logBlockTag;
    private Block leaves;
    private final ConfiguredFeature<TreeConfiguration, ?> treeGen;
    private ResourceKey<ConfiguredFeature<?, ?>> tree;
    private final Item sapling;
    private Block saplingBlock;

    public Tree(String name, boolean hasPlural, TagCategory category, int iTreeGen, int jTreeGen, int kTreeGen) {
        Objects.requireNonNull(category);
        this.hasPlural = hasPlural;
        this.tagCategory = category;
        this.name = name;
        this.item = new Item(CroptopiaMod.createGroup());
        this.log = new RotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_278183_().m_60918_(SoundType.f_56736_).m_60978_(2.0f));
        this.strippedLog = new RotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_278183_().m_60918_(SoundType.f_56736_).m_60978_(2.0f));
        this.wood = new RotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_278183_().m_60918_(SoundType.f_56736_).m_60978_(2.0f));
        this.strippedWood = new RotatedPillarBlock(BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283748_).m_278183_().m_60918_(SoundType.f_56736_).m_60978_(2.0f));
        String tagName = name + "_logs";
        this.logItemTag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation("croptopia", tagName));
        this.logBlockTag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation("croptopia", tagName));
        this.leaves = CroptopiaMod.createRegularLeavesBlock();
        this.treeGen = Tree.createBarkGen(iTreeGen, jTreeGen, kTreeGen, this.log, this.leaves);
        this.saplingBlock = new CroptopiaSaplingBlock(new CroptopiaSaplingGenerator(() -> this.tree), CroptopiaMod.createSaplingSettings().m_278183_());
        this.sapling = new ItemNameBlockItem(this.saplingBlock, CroptopiaMod.createGroup());
        TREES.add(this);
    }

    @Override
    public boolean hasPlural() {
        return this.hasPlural;
    }

    public TagCategory getTagCategory() {
        return this.tagCategory;
    }

    public Item m_5456_() {
        return this.item;
    }

    @Override
    public Block asBlock() {
        return this.log;
    }

    public Block getLog() {
        return this.log;
    }

    public Block getStrippedLog() {
        return this.strippedLog;
    }

    public Block getWood() {
        return this.wood;
    }

    public Block getStrippedWood() {
        return this.strippedWood;
    }

    public TagKey<Item> getLogItemTag() {
        return this.logItemTag;
    }

    public TagKey<Block> getLogBlockTag() {
        return this.logBlockTag;
    }

    public Block getLeaves() {
        return this.leaves;
    }

    public Item getSapling() {
        return this.sapling;
    }

    public Block getSaplingBlock() {
        return this.saplingBlock;
    }

    public ConfiguredFeature<TreeConfiguration, ?> getTreeGen() {
        return this.treeGen;
    }

    public ResourceKey<ConfiguredFeature<?, ?>> getTree() {
        return this.tree;
    }

    public void setTree(ResourceKey<ConfiguredFeature<?, ?>> tree) {
        this.tree = tree;
    }

    @Override
    public String name() {
        return this.name;
    }

    public static List<Tree> copy() {
        return TREES;
    }

    public static void registerBlocks(RegisterFunction<Block> register) {
        for (Tree tree : TREES) {
            tree.log = register.register(CroptopiaMod.createIdentifier(tree.name + "_log"), tree.log);
            tree.strippedLog = register.register(CroptopiaMod.createIdentifier("stripped_" + tree.name + "_log"), tree.strippedLog);
            tree.wood = register.register(CroptopiaMod.createIdentifier(tree.name + "_wood"), tree.wood);
            tree.strippedWood = register.register(CroptopiaMod.createIdentifier("stripped_" + tree.name + "_wood"), tree.strippedWood);
            tree.leaves = register.register(CroptopiaMod.createIdentifier(tree.name + "_leaves"), tree.leaves);
            CroptopiaMod.leafBlocks.add(tree.leaves);
            tree.saplingBlock = register.register(CroptopiaMod.createIdentifier(tree.name + "_sapling"), tree.saplingBlock);
            CroptopiaMod.cropBlocks.add(tree.saplingBlock);
            tree.tree = ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("croptopia", tree.name() + "_tree"));
        }
    }

    public static void registerItems(RegisterFunction<Item> register) {
        for (Tree tree : TREES) {
            register.register(CroptopiaMod.createIdentifier(tree.name), tree.item);
            register.register(CroptopiaMod.createIdentifier(tree.name + "_log"), (Item)new ItemNameBlockItem(tree.log, CroptopiaMod.createGroup()));
            register.register(CroptopiaMod.createIdentifier("stripped_" + tree.name + "_log"), (Item)new ItemNameBlockItem(tree.strippedLog, CroptopiaMod.createGroup()));
            register.register(CroptopiaMod.createIdentifier(tree.name + "_wood"), (Item)new ItemNameBlockItem(tree.wood, CroptopiaMod.createGroup()));
            register.register(CroptopiaMod.createIdentifier("stripped_" + tree.name + "_wood"), (Item)new ItemNameBlockItem(tree.strippedWood, CroptopiaMod.createGroup()));
            register.register(CroptopiaMod.createIdentifier(tree.name + "_sapling"), tree.sapling);
        }
    }

    public static ConfiguredFeature<TreeConfiguration, ?> createBarkGen(int i, int j, int k, Block log, Block leaves) {
        return new ConfiguredFeature(Feature.f_65760_, (FeatureConfiguration)new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)SimpleStateProvider.m_191384_((BlockState)log.m_49966_()), (TrunkPlacer)new StraightTrunkPlacer(i, j, k), (BlockStateProvider)new WeightedStateProvider(SimpleWeightedRandomList.m_146263_().m_146271_((Object)leaves.m_49966_(), 90).m_146270_()), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.m_146483_((int)2), (IntProvider)ConstantInt.m_146483_((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 2)).m_68244_().m_68251_());
    }

    public static void attemptPop(BlockState state, UseOnContext context, BlockPos pos) {
        for (Tree crop : TREES) {
            if (!state.m_60734_().equals(crop.getLog()) && !state.m_60734_().equals(crop.getWood())) continue;
            Block.m_49840_((Level)context.m_43725_(), (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)crop.m_5456_()));
        }
    }
}

