/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.util;

import com.direwolf20.buildinggadgets2.common.events.ServerBuildList;
import com.direwolf20.buildinggadgets2.common.events.ServerTickHandler;
import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.common.items.GadgetBuilding;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2Data;
import com.direwolf20.buildinggadgets2.integration.AE2Integration;
import com.direwolf20.buildinggadgets2.integration.AE2Methods;
import com.direwolf20.buildinggadgets2.integration.CuriosIntegration;
import com.direwolf20.buildinggadgets2.util.DimBlockPos;
import com.direwolf20.buildinggadgets2.util.FakeRenderingWorld;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.GadgetUtils;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.datatypes.TagPos;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;

public class BuildingUtils {
    public static IItemHandler getHandlerFromBound(Player player, DimBlockPos boundInventory, Direction direction) {
        Level level = boundInventory.getLevel(player.m_20194_());
        if (level == null) {
            return null;
        }
        BlockEntity blockEntity = level.m_7702_(boundInventory.blockPos);
        if (blockEntity == null) {
            return null;
        }
        LazyOptional handler = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction);
        if (handler.isPresent()) {
            return (IItemHandler)handler.resolve().get();
        }
        return null;
    }

    public static ItemStack checkFluidHandlerForFluids(IFluidHandlerItem handler, FluidStack fluidStack, boolean simulate) {
        FluidStack drainedStack = handler.drain(fluidStack, IFluidHandler.FluidAction.SIMULATE);
        if (drainedStack.getAmount() == fluidStack.getAmount()) {
            if (!simulate) {
                handler.drain(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            }
            fluidStack.shrink(drainedStack.getAmount());
            return handler.getContainer();
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack insertFluidIntoHandler(IFluidHandlerItem handler, FluidStack fluidStack, boolean simulate) {
        int filled = handler.fill(fluidStack, IFluidHandler.FluidAction.SIMULATE);
        if (filled == fluidStack.getAmount()) {
            if (!simulate) {
                handler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            }
            fluidStack.shrink(filled);
            return handler.getContainer();
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack checkItemForFluids(ItemStack itemStack, FluidStack fluidStack, boolean simulate) {
        LazyOptional fluidStackCapability;
        LazyOptional itemStackCapability = itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
        if (itemStackCapability.isPresent()) {
            IItemHandler slotHandler = (IItemHandler)itemStackCapability.orElseThrow(IllegalStateException::new);
            BuildingUtils.checkItemHandlerForFluids(slotHandler, fluidStack, simulate);
            if (fluidStack.isEmpty()) {
                return ItemStack.f_41583_;
            }
        }
        if ((fluidStackCapability = itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null)).isPresent()) {
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)fluidStackCapability.orElseThrow(IllegalStateException::new);
            ItemStack returnedStack = BuildingUtils.checkFluidHandlerForFluids(fluidHandlerItem, fluidStack, simulate);
            if (fluidStack.isEmpty()) {
                return returnedStack;
            }
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack insertFluidIntoItem(ItemStack itemStack, FluidStack fluidStack, boolean simulate) {
        LazyOptional fluidStackCapability;
        LazyOptional itemStackCapability = itemStack.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
        if (itemStackCapability.isPresent()) {
            IItemHandler slotHandler = (IItemHandler)itemStackCapability.orElseThrow(IllegalStateException::new);
            BuildingUtils.insertFluidIntoItemHandler(slotHandler, fluidStack, simulate);
            if (fluidStack.isEmpty()) {
                return ItemStack.f_41583_;
            }
        }
        if ((fluidStackCapability = itemStack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM, null)).isPresent()) {
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)fluidStackCapability.orElseThrow(IllegalStateException::new);
            ItemStack returnedStack = BuildingUtils.insertFluidIntoHandler(fluidHandlerItem, fluidStack, simulate);
            if (fluidStack.isEmpty()) {
                return returnedStack;
            }
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack checkItemHandlerForFluids(IItemHandler handler, FluidStack fluidStack, boolean simulate) {
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack itemInSlot = handler.getStackInSlot(j);
            ItemStack returnedStack = BuildingUtils.checkItemForFluids(itemInSlot.m_41777_(), fluidStack, simulate);
            if (!fluidStack.isEmpty()) continue;
            if (!simulate && !returnedStack.m_41619_()) {
                if (itemInSlot.m_41613_() == 1) {
                    handler.extractItem(j, 1, false);
                    handler.insertItem(j, returnedStack, false);
                } else {
                    handler.extractItem(j, 1, false);
                    ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)returnedStack, (boolean)false);
                }
            }
            return returnedStack;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack insertFluidIntoItemHandler(IItemHandler handler, FluidStack fluidStack, boolean simulate) {
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack itemInSlot = handler.getStackInSlot(j);
            ItemStack returnedStack = BuildingUtils.insertFluidIntoItem(itemInSlot.m_41777_().m_41620_(1), fluidStack, simulate);
            if (!fluidStack.isEmpty()) continue;
            if (!simulate && !returnedStack.m_41619_()) {
                if (itemInSlot.m_41613_() == 1) {
                    handler.extractItem(j, 1, false);
                    handler.insertItem(j, returnedStack, false);
                } else {
                    handler.extractItem(j, 1, false);
                    ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)returnedStack, (boolean)false);
                }
            }
            return returnedStack;
        }
        return ItemStack.f_41583_;
    }

    public static void checkInventoryForFluids(Inventory inventory, FluidStack fluidStack, boolean simulate) {
        for (int j = 0; j < inventory.m_6643_(); ++j) {
            ItemStack itemInSlot = inventory.m_8020_(j);
            ItemStack returnedStack = BuildingUtils.checkItemForFluids(itemInSlot, fluidStack, simulate);
            if (!fluidStack.isEmpty()) continue;
            if (simulate || returnedStack.m_41619_()) break;
            inventory.m_6836_(j, returnedStack);
            break;
        }
    }

    public static boolean removeFluidStacksFromInventory(Player player, FluidStack fluidStack, boolean simulate, DimBlockPos boundInventory, Direction direction) {
        LazyOptional curiosOpt;
        if (fluidStack.isEmpty()) {
            return false;
        }
        if (boundInventory != null) {
            IItemHandler boundHandler;
            if (AE2Integration.isLoaded()) {
                AE2Methods.checkAE2ForFluids(boundInventory, player, fluidStack, simulate);
                if (fluidStack.isEmpty()) {
                    return true;
                }
            }
            if ((boundHandler = BuildingUtils.getHandlerFromBound(player, boundInventory, direction)) != null) {
                BuildingUtils.checkItemHandlerForFluids(boundHandler, fluidStack, simulate);
            }
        }
        if (fluidStack.isEmpty()) {
            return true;
        }
        if (CuriosIntegration.isLoaded() && (curiosOpt = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player)).isPresent()) {
            ((ICuriosItemHandler)curiosOpt.resolve().get()).getCurios().forEach((id, stackHandler) -> {
                for (int j = 0; j < stackHandler.getSlots(); ++j) {
                    ItemStack itemInSlot = stackHandler.getStacks().getStackInSlot(j);
                    BuildingUtils.checkItemForFluids(itemInSlot, fluidStack, simulate);
                }
            });
        }
        if (fluidStack.isEmpty()) {
            return true;
        }
        Inventory playerInventory = player.m_150109_();
        BuildingUtils.checkInventoryForFluids(playerInventory, fluidStack, simulate);
        return fluidStack.isEmpty();
    }

    public static void checkHandlerForItems(IItemHandler handler, List<ItemStack> testArray, boolean simulate) {
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack itemInSlot = handler.getStackInSlot(j);
            LazyOptional itemStackCapability = itemInSlot.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
            if (itemStackCapability.isPresent()) {
                IItemHandler slotHandler = (IItemHandler)itemStackCapability.orElseThrow(IllegalStateException::new);
                BuildingUtils.checkHandlerForItems(slotHandler, testArray, simulate);
                if (testArray.isEmpty()) {
                    break;
                }
            } else {
                Optional<ItemStack> matchStack = testArray.stream().filter(e -> ItemStack.m_41656_((ItemStack)e, (ItemStack)itemInSlot) && itemInSlot.m_41613_() >= e.m_41613_()).findFirst();
                if (matchStack.isPresent()) {
                    ItemStack matchingStack = matchStack.get();
                    handler.extractItem(j, matchingStack.m_41613_(), simulate);
                    testArray.remove(matchingStack);
                }
            }
            if (testArray.isEmpty()) break;
        }
    }

    public static void checkInventoryForItems(Inventory inventory, List<ItemStack> testArray, boolean simulate) {
        for (int j = 0; j < inventory.m_6643_(); ++j) {
            ItemStack itemInSlot = inventory.m_8020_(j);
            LazyOptional itemStackCapability = itemInSlot.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
            if (itemStackCapability.isPresent()) {
                IItemHandler slotHandler = (IItemHandler)itemStackCapability.orElseThrow(IllegalStateException::new);
                BuildingUtils.checkHandlerForItems(slotHandler, testArray, simulate);
                if (testArray.isEmpty()) {
                    break;
                }
            } else {
                Optional<ItemStack> matchStack = testArray.stream().filter(e -> ItemStack.m_41656_((ItemStack)e, (ItemStack)itemInSlot) && itemInSlot.m_41613_() >= e.m_41613_()).findFirst();
                if (matchStack.isPresent()) {
                    ItemStack matchingStack = matchStack.get();
                    if (!simulate) {
                        itemInSlot.m_41774_(matchingStack.m_41613_());
                    }
                    testArray.remove(matchingStack);
                }
            }
            if (testArray.isEmpty()) break;
        }
    }

    public static boolean removeStacksFromInventory(Player player, List<ItemStack> itemStacks, boolean simulate, DimBlockPos boundInventory, Direction direction) {
        LazyOptional curiosOpt;
        if (itemStacks.isEmpty() || itemStacks.contains(Items.f_41852_.m_7968_())) {
            return false;
        }
        ArrayList<ItemStack> testArray = new ArrayList<ItemStack>(itemStacks);
        if (boundInventory != null) {
            IItemHandler boundHandler;
            if (AE2Integration.isLoaded()) {
                AE2Methods.checkAE2ForItems(boundInventory, player, testArray, simulate);
                if (testArray.isEmpty()) {
                    return true;
                }
            }
            if ((boundHandler = BuildingUtils.getHandlerFromBound(player, boundInventory, direction)) != null) {
                BuildingUtils.checkHandlerForItems(boundHandler, testArray, simulate);
            }
        }
        if (testArray.isEmpty()) {
            return true;
        }
        if (CuriosIntegration.isLoaded() && (curiosOpt = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player)).isPresent()) {
            ((ICuriosItemHandler)curiosOpt.resolve().get()).getCurios().forEach((id, stackHandler) -> {
                for (int j = 0; j < stackHandler.getSlots(); ++j) {
                    ItemStack itemInSlot = stackHandler.getStacks().getStackInSlot(j);
                    LazyOptional itemStackCapability = itemInSlot.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
                    if (!itemStackCapability.isPresent()) continue;
                    IItemHandler slotHandler = (IItemHandler)itemStackCapability.orElseThrow(IllegalStateException::new);
                    BuildingUtils.checkHandlerForItems(slotHandler, testArray, simulate);
                    if (testArray.isEmpty()) break;
                }
            });
        }
        if (testArray.isEmpty()) {
            return true;
        }
        Inventory playerInventory = player.m_150109_();
        BuildingUtils.checkInventoryForItems(playerInventory, testArray, simulate);
        return testArray.isEmpty();
    }

    public static int countItemStacks(Player player, ItemStack itemStack) {
        LazyOptional curiosOpt;
        if (itemStack.m_41619_() || itemStack.m_150930_(Items.f_41852_)) {
            return 0;
        }
        Inventory playerInventory = player.m_150109_();
        int[] counter = new int[]{0};
        if (CuriosIntegration.isLoaded() && (curiosOpt = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player)).isPresent()) {
            ((ICuriosItemHandler)curiosOpt.resolve().get()).getCurios().forEach((id, stackHandler) -> {
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack itemInSlot = stackHandler.getStacks().getStackInSlot(i);
                    LazyOptional itemStackCapability = itemInSlot.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
                    if (!itemStackCapability.isPresent()) continue;
                    IItemHandler slotHandler = (IItemHandler)itemStackCapability.orElseThrow(IllegalStateException::new);
                    for (int j = 0; j < slotHandler.getSlots(); ++j) {
                        ItemStack itemInBagSlot = slotHandler.getStackInSlot(j);
                        if (!ItemStack.m_41656_((ItemStack)itemInBagSlot, (ItemStack)itemStack)) continue;
                        counter[0] = counter[0] + itemInBagSlot.m_41613_();
                    }
                }
            });
        }
        for (int i = 0; i < playerInventory.m_6643_(); ++i) {
            ItemStack slotStack = playerInventory.m_8020_(i);
            LazyOptional itemStackCapability = slotStack.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
            if (itemStackCapability.isPresent()) {
                IItemHandler handler = (IItemHandler)itemStackCapability.orElseThrow(IllegalStateException::new);
                for (int j = 0; j < handler.getSlots(); ++j) {
                    ItemStack itemInSlot = handler.getStackInSlot(j);
                    if (!ItemStack.m_41656_((ItemStack)itemInSlot, (ItemStack)itemStack)) continue;
                    counter[0] = counter[0] + itemInSlot.m_41613_();
                }
                continue;
            }
            if (!ItemStack.m_41656_((ItemStack)slotStack, (ItemStack)itemStack)) continue;
            counter[0] = counter[0] + slotStack.m_41613_();
        }
        return counter[0];
    }

    public static void giveFluidToPlayer(Player player, FluidStack returnedFluid, DimBlockPos boundInventory, Direction direction) {
        LazyOptional curiosOpt;
        if (boundInventory != null) {
            IItemHandler boundHandler;
            if (AE2Integration.isLoaded()) {
                AE2Methods.insertFluidIntoAE2(player, boundInventory, returnedFluid);
                if (returnedFluid.isEmpty()) {
                    return;
                }
            }
            if ((boundHandler = BuildingUtils.getHandlerFromBound(player, boundInventory, direction)) != null) {
                BuildingUtils.insertFluidIntoItemHandler(boundHandler, returnedFluid, false);
            }
        }
        if (returnedFluid.isEmpty()) {
            return;
        }
        if (CuriosIntegration.isLoaded() && (curiosOpt = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player)).isPresent()) {
            ((ICuriosItemHandler)curiosOpt.resolve().get()).getCurios().forEach((id, stackHandler) -> {
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack itemInSlot = stackHandler.getStacks().getStackInSlot(i);
                    BuildingUtils.insertFluidIntoItem(itemInSlot, returnedFluid, false);
                    if (!returnedFluid.isEmpty()) continue;
                    return;
                }
            });
        }
        Inventory playerInventory = player.m_150109_();
        for (int i = 0; i < playerInventory.m_6643_(); ++i) {
            ItemStack slotStack = playerInventory.m_8020_(i);
            ItemStack returnedStack = BuildingUtils.insertFluidIntoItem(slotStack.m_41777_().m_41620_(1), returnedFluid, false);
            if (returnedStack.m_41619_()) continue;
            if (slotStack.m_41613_() == 1) {
                playerInventory.m_6836_(i, returnedStack);
            } else {
                slotStack.m_41774_(1);
                if (!player.m_36356_(returnedStack)) {
                    BlockPos dropPos = player.m_20097_();
                    ItemEntity itementity = new ItemEntity(player.m_9236_(), (double)dropPos.m_123341_(), (double)dropPos.m_123342_(), (double)dropPos.m_123343_(), returnedStack);
                    itementity.m_32010_(40);
                    player.m_9236_().m_7967_((Entity)itementity);
                }
            }
            return;
        }
    }

    public static void giveItemToPlayer(Player player, ItemStack returnedItem, DimBlockPos boundInventory, Direction direction) {
        ItemStack tempReturnedItem = returnedItem.m_41777_();
        if (boundInventory != null) {
            IItemHandler boundHandler;
            if (AE2Integration.isLoaded()) {
                AE2Methods.insertIntoAE2(player, boundInventory, tempReturnedItem);
                if (tempReturnedItem.m_41619_()) {
                    return;
                }
            }
            if ((boundHandler = BuildingUtils.getHandlerFromBound(player, boundInventory, direction)) != null) {
                tempReturnedItem = ItemHandlerHelper.insertItemStacked((IItemHandler)boundHandler, (ItemStack)returnedItem, (boolean)false);
            }
        }
        if (tempReturnedItem.m_41619_()) {
            return;
        }
        ItemStack realReturnedItem = tempReturnedItem.m_41777_();
        if (CuriosIntegration.isLoaded()) {
            LazyOptional curiosOpt = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
            if (curiosOpt.isPresent()) {
                ((ICuriosItemHandler)curiosOpt.resolve().get()).getCurios().forEach((id, stackHandler) -> {
                    for (int i = 0; i < stackHandler.getSlots(); ++i) {
                        ItemStack itemInSlot = stackHandler.getStacks().getStackInSlot(i);
                        LazyOptional itemStackCapability = itemInSlot.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
                        if (!itemStackCapability.isPresent()) continue;
                        IItemHandler slotHandler = (IItemHandler)itemStackCapability.orElseThrow(IllegalStateException::new);
                        for (int j = 0; j < slotHandler.getSlots(); ++j) {
                            ItemStack itemInBagSlot = slotHandler.getStackInSlot(j);
                            if (ItemStack.m_41656_((ItemStack)itemInBagSlot, (ItemStack)realReturnedItem)) {
                                slotHandler.insertItem(j, realReturnedItem.m_41620_(slotHandler.getSlotLimit(i) - itemInBagSlot.m_41613_()), false);
                            }
                            if (!realReturnedItem.m_41619_()) continue;
                            return;
                        }
                    }
                });
            }
            if (realReturnedItem.m_41619_()) {
                return;
            }
        }
        Inventory playerInventory = player.m_150109_();
        block0: for (int i = 0; i < playerInventory.m_6643_(); ++i) {
            ItemStack slotStack = playerInventory.m_8020_(i);
            LazyOptional itemStackCapability = slotStack.getCapability(ForgeCapabilities.ITEM_HANDLER, null);
            if (!itemStackCapability.isPresent()) continue;
            IItemHandler handler = (IItemHandler)itemStackCapability.orElseThrow(IllegalStateException::new);
            for (int j = 0; j < handler.getSlots(); ++j) {
                ItemStack itemInSlot = handler.getStackInSlot(j);
                if (ItemStack.m_41656_((ItemStack)itemInSlot, (ItemStack)realReturnedItem)) {
                    handler.insertItem(j, realReturnedItem.m_41620_(handler.getSlotLimit(i) - itemInSlot.m_41613_()), false);
                }
                if (realReturnedItem.m_41619_()) continue block0;
            }
        }
        if (realReturnedItem.m_41619_()) {
            return;
        }
        if (!player.m_36356_(realReturnedItem)) {
            BlockPos dropPos = player.m_20097_();
            ItemEntity itementity = new ItemEntity(player.m_9236_(), (double)dropPos.m_123341_(), (double)dropPos.m_123342_(), (double)dropPos.m_123343_(), realReturnedItem);
            itementity.m_32010_(40);
            player.m_9236_().m_7967_((Entity)itementity);
        }
    }

    public static int getEnergyStored(ItemStack gadget) {
        Item item = gadget.m_41720_();
        if (item instanceof BaseGadget) {
            BaseGadget baseGadget = (BaseGadget)item;
            IEnergyStorage energy = (IEnergyStorage)gadget.getCapability(ForgeCapabilities.ENERGY, null).orElse(null);
            return energy.getEnergyStored();
        }
        return 0;
    }

    public static int getEnergyCost(ItemStack gadget) {
        Item item = gadget.m_41720_();
        if (item instanceof BaseGadget) {
            BaseGadget baseGadget = (BaseGadget)item;
            return baseGadget.getEnergyCost();
        }
        return -1;
    }

    public static boolean hasEnoughEnergy(ItemStack gadget) {
        int energyStored = BuildingUtils.getEnergyStored(gadget);
        int energyCost = BuildingUtils.getEnergyCost(gadget);
        return energyCost <= energyStored;
    }

    public static boolean hasEnoughEnergy(ItemStack gadget, int cost) {
        int energyStored = BuildingUtils.getEnergyStored(gadget);
        return cost <= energyStored;
    }

    public static void useEnergy(ItemStack gadget) {
        Item item = gadget.m_41720_();
        if (item instanceof BaseGadget) {
            BaseGadget baseGadget = (BaseGadget)item;
            IEnergyStorage energy = (IEnergyStorage)gadget.getCapability(ForgeCapabilities.ENERGY, null).orElse(null);
            int cost = baseGadget.getEnergyCost();
            energy.extractEnergy(cost, false);
        }
    }

    public static UUID build(Level level, Player player, ArrayList<StatePos> blockPosList, BlockPos lookingAt, ItemStack gadget, boolean needItems) {
        UUID buildUUID = UUID.randomUUID();
        FakeRenderingWorld fakeRenderingWorld = new FakeRenderingWorld(level, blockPosList, lookingAt);
        DimBlockPos boundPos = GadgetNBT.getBoundPos(gadget);
        int dir = boundPos == null ? -1 : GadgetNBT.getToolValue(gadget, "binddirection");
        Direction direction = dir == -1 ? null : Direction.values()[dir];
        for (StatePos pos : blockPosList) {
            BlockPos blockPos;
            if (pos.state.m_60795_() || !level.m_7966_(player, (blockPos = pos.pos).m_121955_((Vec3i)lookingAt)) || gadget.m_41720_() instanceof GadgetBuilding && needItems && !pos.state.m_60710_((LevelReader)level, blockPos.m_121955_((Vec3i)lookingAt))) continue;
            if (pos.state.m_60819_().m_76178_()) {
                List<ItemStack> neededItems = GadgetUtils.getDropsForBlockState((ServerLevel)level, blockPos.m_121955_((Vec3i)lookingAt), pos.state, player);
                if (!player.m_7500_() && needItems && !BuildingUtils.removeStacksFromInventory(player, neededItems, true, boundPos, direction)) {
                    continue;
                }
            } else {
                FluidState fluidState = pos.state.m_60819_();
                if (!fluidState.m_76178_() && fluidState.m_76170_()) {
                    Fluid fluid = fluidState.m_76152_();
                    FluidStack fluidStack = new FluidStack(fluid, 1000);
                    if (!player.m_7500_() && needItems && !BuildingUtils.removeFluidStacksFromInventory(player, fluidStack, true, boundPos, direction)) continue;
                }
            }
            if (!player.m_7500_() && !BuildingUtils.hasEnoughEnergy(gadget)) {
                player.m_5661_((Component)Component.m_237115_((String)"buildinggadgets2.messages.outofpower"), true);
                break;
            }
            if (!player.m_7500_()) {
                BuildingUtils.useEnergy(gadget);
            }
            ServerTickHandler.addToMap(buildUUID, new StatePos(fakeRenderingWorld.getBlockStateWithoutReal(pos.pos), pos.pos), level, GadgetNBT.getRenderTypeByte(gadget), player, needItems, false, gadget, ServerBuildList.BuildType.BUILD, true, lookingAt);
        }
        return buildUUID;
    }

    public static UUID exchange(Level level, Player player, ArrayList<StatePos> blockPosList, BlockPos lookingAt, ItemStack gadget, boolean needItems, boolean returnItems) {
        UUID buildUUID = UUID.randomUUID();
        FakeRenderingWorld fakeRenderingWorld = new FakeRenderingWorld(level, blockPosList, lookingAt);
        DimBlockPos boundPos = GadgetNBT.getBoundPos(gadget);
        int dir = boundPos == null ? -1 : GadgetNBT.getToolValue(gadget, "binddirection");
        Direction direction = dir == -1 ? null : Direction.values()[dir];
        for (StatePos pos : blockPosList) {
            BlockPos blockPos = pos.pos;
            if (!level.m_7966_(player, blockPos.m_121955_((Vec3i)lookingAt)) || !GadgetUtils.isValidBlockState(level.m_8055_(blockPos.m_121955_((Vec3i)lookingAt)), level, blockPos) || gadget.m_41720_() instanceof GadgetBuilding && needItems && !pos.state.m_60710_((LevelReader)level, blockPos.m_121955_((Vec3i)lookingAt))) continue;
            if (pos.state.m_60819_().m_76178_()) {
                List<ItemStack> neededItems = GadgetUtils.getDropsForBlockState((ServerLevel)level, blockPos.m_121955_((Vec3i)lookingAt), pos.state, player);
                if (!player.m_7500_() && needItems && !BuildingUtils.removeStacksFromInventory(player, neededItems, true, boundPos, direction)) {
                    continue;
                }
            } else {
                FluidState fluidState = pos.state.m_60819_();
                if (!fluidState.m_76178_() && fluidState.m_76170_()) {
                    Fluid fluid = fluidState.m_76152_();
                    FluidStack fluidStack = new FluidStack(fluid, 1000);
                    if (!player.m_7500_() && needItems && !BuildingUtils.removeFluidStacksFromInventory(player, fluidStack, true, boundPos, direction)) continue;
                }
            }
            if (!player.m_7500_() && !BuildingUtils.hasEnoughEnergy(gadget)) {
                player.m_5661_((Component)Component.m_237115_((String)"buildinggadgets2.messages.outofpower"), true);
                break;
            }
            if (!player.m_7500_()) {
                BuildingUtils.useEnergy(gadget);
            }
            ServerTickHandler.addToMap(buildUUID, new StatePos(fakeRenderingWorld.getBlockStateWithoutReal(pos.pos), pos.pos), level, GadgetNBT.getRenderTypeByte(gadget), player, needItems, returnItems, gadget, ServerBuildList.BuildType.EXCHANGE, true, lookingAt);
        }
        return buildUUID;
    }

    public static ArrayList<StatePos> buildWithTileData(Level level, Player player, ArrayList<StatePos> blockPosList, BlockPos lookingAt, ArrayList<TagPos> teData, ItemStack gadget) {
        ArrayList<StatePos> actuallyBuiltList = new ArrayList<StatePos>();
        if (teData == null) {
            return actuallyBuiltList;
        }
        boolean replace = GadgetNBT.getPasteReplace(gadget);
        UUID buildUUID = !replace ? BuildingUtils.build(level, player, blockPosList, lookingAt, gadget, false) : BuildingUtils.exchange(level, player, blockPosList, lookingAt, gadget, false, false);
        ServerTickHandler.addTEData(buildUUID, teData);
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(level.m_7654_()).m_129783_());
        if (!bg2Data.containsUndoList(GadgetNBT.getUUID(gadget))) {
            GadgetUtils.addToUndoList(level, gadget, new ArrayList<StatePos>(), GadgetNBT.getUUID(gadget));
        }
        return actuallyBuiltList;
    }

    public static UUID removeTickHandler(Level level, Player player, List<BlockPos> blockPosList, boolean giveItem, boolean dropContents, ItemStack gadget) {
        UUID buildUUID = UUID.randomUUID();
        for (BlockPos pos : blockPosList) {
            if (!level.m_7966_(player, pos)) continue;
            if (!player.m_7500_() && !BuildingUtils.hasEnoughEnergy(gadget)) {
                player.m_5661_((Component)Component.m_237115_((String)"buildinggadgets2.messages.outofpower"), true);
                break;
            }
            BlockState oldState = level.m_8055_(pos);
            if (oldState.m_60795_() || !GadgetUtils.isValidBlockState(oldState, level, pos)) continue;
            if (!player.m_7500_()) {
                BuildingUtils.useEnergy(gadget);
            }
            ServerTickHandler.addToMap(buildUUID, new StatePos(Blocks.f_50016_.m_49966_(), pos), level, GadgetNBT.getRenderTypeByte(gadget), player, false, giveItem, gadget, ServerBuildList.BuildType.DESTROY, dropContents, BlockPos.f_121853_);
        }
        return buildUUID;
    }
}

