/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets2.common.items;

import com.direwolf20.buildinggadgets2.api.gadgets.GadgetTarget;
import com.direwolf20.buildinggadgets2.common.items.BaseGadget;
import com.direwolf20.buildinggadgets2.common.worlddata.BG2Data;
import com.direwolf20.buildinggadgets2.setup.Config;
import com.direwolf20.buildinggadgets2.util.BuildingUtils;
import com.direwolf20.buildinggadgets2.util.GadgetNBT;
import com.direwolf20.buildinggadgets2.util.GadgetUtils;
import com.direwolf20.buildinggadgets2.util.context.ItemActionContext;
import com.direwolf20.buildinggadgets2.util.datatypes.StatePos;
import com.direwolf20.buildinggadgets2.util.modes.BaseMode;
import com.direwolf20.buildinggadgets2.util.modes.Copy;
import com.direwolf20.buildinggadgets2.util.modes.Paste;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GadgetCopyPaste
extends BaseGadget {
    @Override
    public int getEnergyMax() {
        return (Integer)Config.COPYPASTEGADGET_MAXPOWER.get();
    }

    @Override
    public int getEnergyCost() {
        return (Integer)Config.COPYPASTEGADGET_COST.get();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        boolean sneakPressed;
        String templateName;
        super.m_7373_(stack, level, tooltip, flag);
        Minecraft mc = Minecraft.m_91087_();
        if (level == null || mc.f_91074_ == null) {
            return;
        }
        if (GadgetNBT.getPasteReplace(stack)) {
            tooltip.add((Component)Component.m_237115_((String)"buildinggadgets2.voidwarning").m_130940_(ChatFormatting.RED));
        }
        if (!(templateName = GadgetNBT.getTemplateName(stack)).isEmpty()) {
            tooltip.add((Component)Component.m_237110_((String)"buildinggadgets2.templatename", (Object[])new Object[]{templateName}).m_130940_(ChatFormatting.AQUA));
        }
        if (sneakPressed = Screen.m_96638_()) {
            // empty if block
        }
    }

    @Override
    InteractionResultHolder<ItemStack> onAction(ItemActionContext context) {
        ItemStack gadget = context.stack();
        BaseMode mode = GadgetNBT.getMode(gadget);
        if (!mode.getId().m_135815_().equals("copy")) {
            if (mode.getId().m_135815_().equals("paste")) {
                UUID uuid = GadgetNBT.getUUID(gadget);
                BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(context.player().m_9236_().m_7654_()).m_129783_());
                ArrayList<StatePos> buildList = bg2Data.getCopyPasteList(uuid, false);
                boolean replace = GadgetNBT.getPasteReplace(gadget);
                UUID buildUUID = !replace ? BuildingUtils.build(context.level(), context.player(), buildList, GadgetCopyPaste.getHitPos(context).m_7494_().m_121955_((Vec3i)GadgetNBT.getRelativePaste(gadget)), gadget, true) : BuildingUtils.exchange(context.level(), context.player(), buildList, GadgetCopyPaste.getHitPos(context).m_7494_().m_121955_((Vec3i)GadgetNBT.getRelativePaste(gadget)), gadget, true, false);
                GadgetUtils.addToUndoList(context.level(), gadget, new ArrayList<StatePos>(), buildUUID);
                GadgetNBT.clearAnchorPos(gadget);
                return InteractionResultHolder.m_19090_((Object)gadget);
            }
            return InteractionResultHolder.m_19098_((Object)gadget);
        }
        GadgetNBT.setCopyStartPos(gadget, context.pos());
        this.buildAndStore(context, gadget);
        return InteractionResultHolder.m_19090_((Object)gadget);
    }

    @Override
    InteractionResultHolder<ItemStack> onShiftAction(ItemActionContext context) {
        ItemStack gadget = context.stack();
        BaseMode mode = GadgetNBT.getMode(gadget);
        if (mode.getId().m_135815_().equals("copy")) {
            GadgetNBT.setCopyEndPos(gadget, context.pos());
            this.buildAndStore(context, gadget);
        } else if (!mode.equals(new Paste())) {
            return InteractionResultHolder.m_19098_((Object)gadget);
        }
        return InteractionResultHolder.m_19090_((Object)gadget);
    }

    public void buildAndStore(ItemActionContext context, ItemStack gadget) {
        ArrayList<StatePos> buildList = new Copy().collect(context.hitResult().m_82434_(), context.player(), context.pos(), Blocks.f_50016_.m_49966_());
        UUID uuid = GadgetNBT.getUUID(gadget);
        GadgetNBT.setCopyUUID(gadget);
        BG2Data bg2Data = BG2Data.get(Objects.requireNonNull(context.player().m_9236_().m_7654_()).m_129783_());
        bg2Data.addToCopyPaste(uuid, buildList);
        context.player().m_5661_((Component)Component.m_237110_((String)"buildinggadgets2.messages.copyblocks", (Object[])new Object[]{buildList.size()}), true);
    }

    @Override
    public GadgetTarget gadgetTarget() {
        return GadgetTarget.COPYPASTE;
    }
}

