/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.registry;

import java.util.EnumMap;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import quek.undergarden.registry.UGItems;

public enum UGArmorMaterials implements ArmorMaterial
{
    CLOGGRUM("cloggrum", 20, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 1);
        map.put(ArmorItem.Type.LEGGINGS, 5);
        map.put(ArmorItem.Type.CHESTPLATE, 6);
        map.put(ArmorItem.Type.HELMET, 2);
    }), 10, SoundEvents.f_11677_, 1.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)UGItems.CLOGGRUM_INGOT.get()})),
    FROSTSTEEL("froststeel", 25, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 2);
        map.put(ArmorItem.Type.LEGGINGS, 6);
        map.put(ArmorItem.Type.CHESTPLATE, 7);
        map.put(ArmorItem.Type.HELMET, 3);
    }), 15, SoundEvents.f_11676_, 4.0f, 0.05f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)UGItems.FROSTSTEEL_INGOT.get()})),
    UTHERIUM("utherium", 30, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 3);
        map.put(ArmorItem.Type.LEGGINGS, 6);
        map.put(ArmorItem.Type.CHESTPLATE, 8);
        map.put(ArmorItem.Type.HELMET, 3);
    }), 13, SoundEvents.f_11673_, 3.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)UGItems.UTHERIUM_CRYSTAL.get()})),
    MASTICATED("masticated", 17, (EnumMap)Util.m_137469_(new EnumMap<ArmorItem.Type, V>(ArmorItem.Type.class), map -> {
        map.put(ArmorItem.Type.BOOTS, 6);
        map.put(ArmorItem.Type.LEGGINGS, 6);
        map.put(ArmorItem.Type.CHESTPLATE, 6);
        map.put(ArmorItem.Type.HELMET, 6);
    }), 5, SoundEvents.f_11673_, 0.0f, 0.0f, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)UGItems.MASTICATOR_SCALES.get()}));

    private static final EnumMap<ArmorItem.Type, Integer> HEALTH_FUNCTION_FOR_TYPE;
    private final String name;
    private final int durabilityMultiplier;
    private final EnumMap<ArmorItem.Type, Integer> protectionFunctionForType;
    private final int enchantmentValue;
    private final SoundEvent sound;
    private final float toughness;
    private final float knockbackResistance;
    private final LazyLoadedValue<Ingredient> repairIngredient;

    private UGArmorMaterials(String name, int durability, EnumMap<ArmorItem.Type, Integer> protectionFunctionForType, int enchantmentValue, SoundEvent sound, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient) {
        this.name = name;
        this.durabilityMultiplier = durability;
        this.protectionFunctionForType = protectionFunctionForType;
        this.enchantmentValue = enchantmentValue;
        this.sound = sound;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredient = new LazyLoadedValue(repairIngredient);
    }

    public int m_266425_(ArmorItem.Type type) {
        return HEALTH_FUNCTION_FOR_TYPE.get(type) * this.durabilityMultiplier;
    }

    public int m_7366_(ArmorItem.Type type) {
        return this.protectionFunctionForType.get(type);
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    public SoundEvent m_7344_() {
        return this.sound;
    }

    public Ingredient m_6230_() {
        return (Ingredient)this.repairIngredient.m_13971_();
    }

    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    static {
        HEALTH_FUNCTION_FOR_TYPE = (EnumMap)Util.m_137469_(new EnumMap(ArmorItem.Type.class), map -> {
            map.put(ArmorItem.Type.BOOTS, 13);
            map.put(ArmorItem.Type.LEGGINGS, 15);
            map.put(ArmorItem.Type.CHESTPLATE, 16);
            map.put(ArmorItem.Type.HELMET, 11);
        });
    }
}

