/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TorchBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import quek.undergarden.registry.UGDamageSources;
import quek.undergarden.registry.UGParticleTypes;
import quek.undergarden.registry.UGTags;

public class ShardTorchBlock
extends TorchBlock {
    public ShardTorchBlock(BlockBehaviour.Properties properties) {
        super(properties, (ParticleOptions)ParticleTypes.f_123744_);
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 0.7;
        double z = (double)pos.m_123343_() + 0.5;
        level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.0, 0.0);
        level.m_7106_((ParticleOptions)UGParticleTypes.SHARD.get(), x, y, z, 0.0, 0.0, 0.0);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        level.m_186460_(pos, (Block)this, 20);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.m_6443_(LivingEntity.class, new AABB(pos).m_82400_(4.0), entity -> entity.m_6095_().m_204039_(UGTags.Entities.ROTSPAWN)).forEach(entity -> {
            if (entity.m_6469_(UGDamageSources.getShardTorchDamage((Level)level, pos.m_252807_()), 4.0f)) {
                ShardTorchBlock.drawParticlesTo(level, pos.m_252807_(), (Entity)entity);
            }
        });
        level.m_186460_(pos, (Block)this, 20);
    }

    public static void drawParticlesTo(ServerLevel level, Vec3 torchPos, Entity highlight) {
        int particles = (int)Math.min(12L, Math.round(torchPos.m_82557_(highlight.m_20182_())));
        for (int i = 0; i < particles; ++i) {
            double trailFactor = (double)i / ((double)particles - 1.0);
            double x = torchPos.m_7096_() + (highlight.m_20182_().m_7096_() - torchPos.m_7096_()) * trailFactor + (double)level.m_213780_().m_188501_() * 0.25;
            double y = torchPos.m_7098_() + 0.25 + (highlight.m_20188_() - torchPos.m_7098_()) * trailFactor + (double)level.m_213780_().m_188501_() * 0.25;
            double z = torchPos.m_7094_() + (highlight.m_20182_().m_7094_() - torchPos.m_7094_()) * trailFactor + (double)level.m_213780_().m_188501_() * 0.25;
            level.m_8767_((ParticleOptions)((SimpleParticleType)UGParticleTypes.SHARD_BEAM.get()), x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

