/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.block;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.FarmlandWaterManager;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import quek.undergarden.registry.UGBlocks;

public class DeepsoilFarmlandBlock
extends FarmBlock {
    public DeepsoilFarmlandBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(0)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return !this.m_49966_().m_60710_((LevelReader)context.m_43725_(), context.m_8083_()) ? ((Block)UGBlocks.DEEPSOIL.get()).m_49966_() : super.m_5573_(context);
    }

    public boolean canSustainPlant(BlockState state, BlockGetter getter, BlockPos pos, Direction direction, IPlantable plantable) {
        PlantType type = plantable.getPlantType(getter, pos.m_121945_(direction));
        return type == PlantType.CROP || type == PlantType.PLAINS;
    }

    public static void turnToDeepsoil(@Nullable Entity entity, BlockState state, Level level, BlockPos pos) {
        level.m_46597_(pos, DeepsoilFarmlandBlock.m_49897_((BlockState)state, (BlockState)((Block)UGBlocks.DEEPSOIL.get()).m_49966_(), (LevelAccessor)level, (BlockPos)pos));
        level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)entity, (BlockState)state));
    }

    private static boolean isNearWater(LevelReader level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_7918_(-4, 0, -4), (BlockPos)pos.m_7918_(4, 1, 4))) {
            if (!state.canBeHydrated((BlockGetter)level, pos, level.m_6425_(blockpos), blockpos)) continue;
            return true;
        }
        return FarmlandWaterManager.hasBlockWaterTicket((LevelReader)level, (BlockPos)pos);
    }

    private static boolean isUnderCrops(BlockGetter level, BlockPos pos) {
        BlockState plant = level.m_8055_(pos.m_7494_());
        BlockState state = level.m_8055_(pos);
        return plant.m_60734_() instanceof IPlantable && state.canSustainPlant(level, pos, Direction.UP, (IPlantable)plant.m_60734_());
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)level, pos)) {
            DeepsoilFarmlandBlock.turnToDeepsoil(null, state, (Level)level, pos);
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int moistness = (Integer)state.m_61143_((Property)f_53243_);
        if (!DeepsoilFarmlandBlock.isNearWater((LevelReader)level, pos) && !level.m_46758_(pos.m_7494_())) {
            if (moistness > 0) {
                level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(moistness - 1)), 2);
            } else if (!DeepsoilFarmlandBlock.isUnderCrops((BlockGetter)level, pos)) {
                DeepsoilFarmlandBlock.turnToDeepsoil(null, state, (Level)level, pos);
            }
        } else if (moistness < 7) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)f_53243_, (Comparable)Integer.valueOf(7)), 2);
        }
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float fallDamage) {
        if (!level.m_5776_() && ForgeHooks.onFarmlandTrample((Level)level, (BlockPos)pos, (BlockState)((Block)UGBlocks.DEEPSOIL.get()).m_49966_(), (float)fallDamage, (Entity)entity)) {
            DeepsoilFarmlandBlock.turnToDeepsoil(entity, state, level, pos);
        }
        entity.m_142535_(fallDamage, 1.0f, level.m_269111_().m_268989_());
    }
}

