/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.forge.fluid;

import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.base.PlatformFluidHandler;
import earth.terrarium.botarium.forge.fluid.ForgeFluidHolder;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fluids.capability.IFluidHandler;

public record ForgeFluidHandler(IFluidHandler handler) implements PlatformFluidHandler
{
    @Override
    public long insertFluid(FluidHolder fluid, boolean simulate) {
        return this.handler.fill(new ForgeFluidHolder(fluid).getFluidStack(), simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE);
    }

    @Override
    public FluidHolder extractFluid(FluidHolder fluid, boolean simulate) {
        return new ForgeFluidHolder(this.handler.drain(new ForgeFluidHolder(fluid).getFluidStack(), simulate ? IFluidHandler.FluidAction.SIMULATE : IFluidHandler.FluidAction.EXECUTE));
    }

    @Override
    public int getTankAmount() {
        return this.handler.getTanks();
    }

    @Override
    public FluidHolder getFluidInTank(int tank) {
        return new ForgeFluidHolder(this.handler.getFluidInTank(tank));
    }

    @Override
    public List<FluidHolder> getFluidTanks() {
        ArrayList<FluidHolder> fluids = new ArrayList<FluidHolder>();
        for (int i = 0; i < this.handler.getTanks(); ++i) {
            fluids.add(this.getFluidInTank(i));
        }
        return fluids;
    }

    @Override
    public long getTankCapacity(int tank) {
        return this.handler.getTankCapacity(tank);
    }

    @Override
    public boolean supportsInsertion() {
        return true;
    }

    @Override
    public boolean supportsExtraction() {
        return true;
    }
}

