/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.botarium.forge.fluid;

import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.forge.AutoSerializable;
import earth.terrarium.botarium.forge.fluid.ForgeFluidHolder;
import earth.terrarium.botarium.util.Serializable;
import earth.terrarium.botarium.util.Updatable;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record ForgeFluidContainer<T extends FluidContainer & Updatable<BlockEntity>>(T container, BlockEntity entity) implements IFluidHandler,
ICapabilityProvider,
AutoSerializable
{
    public int getTanks() {
        return this.container.getSize();
    }

    @NotNull
    public FluidStack getFluidInTank(int i) {
        return new ForgeFluidHolder((FluidHolder)this.container.getFluids().get((int)i)).fluidStack;
    }

    public int getTankCapacity(int i) {
        return (int)this.container.getTankCapacity(i);
    }

    public boolean isFluidValid(int i, @NotNull FluidStack fluidStack) {
        return this.container.getFluids().get(i).matches(new ForgeFluidHolder(fluidStack));
    }

    public int fill(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        int i = (int)this.container.insertFluid(new ForgeFluidHolder(fluidStack), fluidAction.simulate());
        if (i > 0 && fluidAction.execute()) {
            ((Updatable)this.container).update(this.entity);
        }
        return i;
    }

    @NotNull
    public FluidStack drain(FluidStack fluidStack, IFluidHandler.FluidAction fluidAction) {
        FluidStack fluidStack1 = new ForgeFluidHolder(this.container.extractFluid(new ForgeFluidHolder(fluidStack), fluidAction.simulate())).getFluidStack();
        if (!fluidStack1.isEmpty() && fluidAction.execute()) {
            ((Updatable)this.container).update(this.entity);
        }
        return fluidStack1;
    }

    @NotNull
    public FluidStack drain(int i, IFluidHandler.FluidAction fluidAction) {
        FluidHolder fluid = this.container.getFluids().get(0).copyHolder();
        if (fluid.isEmpty()) {
            return FluidStack.EMPTY;
        }
        fluid.setAmount(i);
        FluidStack fluidStack = new ForgeFluidHolder(this.container.extractFluid(fluid, fluidAction.simulate())).getFluidStack();
        if (!fluidStack.isEmpty() && fluidAction.execute()) {
            ((Updatable)this.container).update(this.entity);
        }
        return fluidStack;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> capability, @Nullable Direction arg) {
        return capability == ForgeCapabilities.FLUID_HANDLER && this.container.getContainer(arg) != null ? LazyOptional.of(() -> this).cast() : LazyOptional.empty();
    }

    @Override
    public Serializable getSerializable() {
        return this.container;
    }
}

