/*
 * Decompiled with CFR 0.152.
 */
package gisellevonbingen.mmp.common.datagen;

import gisellevonbingen.mmp.common.MoreMekanismProcessing;
import gisellevonbingen.mmp.common.material.MaterialState;
import gisellevonbingen.mmp.common.material.MaterialType;
import java.util.ArrayList;
import mekanism.common.Mekanism;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class ItemModelGenerator
extends ItemModelProvider {
    public ItemModelGenerator(PackOutput output, @Nullable ExistingFileHelper existingFileHelper) {
        super(output, "moremekanismprocessing", existingFileHelper);
    }

    protected void registerModels() {
        ArrayList<MaterialState> hasOverlay = new ArrayList<MaterialState>();
        hasOverlay.add(MaterialState.DIRTY_DUST);
        hasOverlay.add(MaterialState.CLUMP);
        hasOverlay.add(MaterialState.SHARD);
        hasOverlay.add(MaterialState.CRYSTAL);
        for (MaterialType materialType : MaterialType.values()) {
            for (MaterialState materialState : materialType.getResultShape().getProcessableStates()) {
                if (!materialState.hasOwnItem() || materialType.getPresetItem(materialState) != null) continue;
                Item item = materialState.getItem(materialType);
                ItemModelBuilder builder = (ItemModelBuilder)this.singleTexture(ForgeRegistries.ITEMS.getKey((Object)item).m_135815_(), this.mcLoc("item/generated"), "layer0", this.getTexture(materialState));
                if (hasOverlay.contains((Object)materialState)) {
                    builder.texture("layer1", this.getMekanismTexture(materialState.getBaseName() + "_overlay"));
                }
                if (materialState != MaterialState.DIRTY_DUST) continue;
                builder.texture("layer2", MoreMekanismProcessing.rl("item/" + materialState.getBaseName() + "_overlay2"));
            }
        }
    }

    protected ResourceLocation getMekanismTexture(String name) {
        return Mekanism.rl((String)("item/" + name));
    }

    protected ResourceLocation getTexture(MaterialState materialState) {
        if (materialState == MaterialState.GEM || materialState == MaterialState.INGOT) {
            return MoreMekanismProcessing.rl("item/" + materialState.getBaseName());
        }
        if (materialState == MaterialState.DUST) {
            return this.getTexture(MaterialState.DIRTY_DUST);
        }
        return this.getMekanismTexture(materialState.getBaseName());
    }
}

