/*
 * Decompiled with CFR 0.152.
 */
package gisellevonbingen.mmp.common.crafting;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import gisellevonbingen.mmp.common.crafting.SingleOutputRecipeBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class ShapedRecipeBuilder
extends SingleOutputRecipeBuilder {
    private final List<String> patterns = new ArrayList<String>();
    private final Map<Character, Ingredient> keys = new HashMap<Character, Ingredient>();

    public ShapedRecipeBuilder(ResourceLocation id) {
        super(id);
    }

    public List<String> getPatterns() {
        return this.patterns;
    }

    public void addPattern(String pattern) {
        this.patterns.add(pattern);
    }

    public void addPattern(Collection<String> patterns) {
        this.patterns.addAll(patterns);
    }

    public void addPattern(String ... patterns) {
        this.addPattern(Lists.newArrayList((Object[])patterns));
    }

    public Map<Character, Ingredient> getKey() {
        return this.keys;
    }

    public ShapedRecipeBuilder addKey(Character key, Ingredient ingredient) {
        this.keys.put(key, ingredient);
        return this;
    }

    public Result getResult() {
        return new Result(this);
    }

    public static class Result
    extends SingleOutputRecipeBuilder.SingleOutputRecipeResult {
        private final List<String> patterns;
        private final Map<Character, Ingredient> keys;

        public Result(ShapedRecipeBuilder builder) {
            super(builder);
            this.patterns = new ArrayList<String>(builder.patterns);
            this.keys = new HashMap<Character, Ingredient>(builder.keys);
        }

        @Override
        public void m_7917_(JsonObject json) {
            super.m_7917_(json);
            JsonArray patternJson = new JsonArray();
            for (String pattern : this.patterns) {
                patternJson.add(pattern);
            }
            json.add("pattern", (JsonElement)patternJson);
            JsonObject keyJson = new JsonObject();
            for (Map.Entry<Character, Ingredient> entry : this.keys.entrySet()) {
                keyJson.add(String.valueOf(entry.getKey()), entry.getValue().m_43942_());
            }
            json.add("key", (JsonElement)keyJson);
        }

        public List<String> getPatterns() {
            return Lists.newArrayList(this.patterns);
        }

        public Map<Character, Ingredient> getKeys() {
            return Maps.newHashMap(this.keys);
        }

        public RecipeSerializer<?> m_6637_() {
            return RecipeSerializer.f_44076_;
        }
    }
}

