/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.architectury.event.CompoundEventResult;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.ExplosionEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.RegistrarManager;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import dev.architectury.utils.value.IntValue;
import dev.ftb.mods.ftbchunks.FTBCUtils;
import dev.ftb.mods.ftbchunks.FTBChunksAPIImpl;
import dev.ftb.mods.ftbchunks.FTBChunksCommands;
import dev.ftb.mods.ftbchunks.FTBChunksExpected;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.LongRangePlayerTracker;
import dev.ftb.mods.ftbchunks.api.ChunkTeamData;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.api.FTBChunksProperties;
import dev.ftb.mods.ftbchunks.api.Protection;
import dev.ftb.mods.ftbchunks.client.FTBChunksClient;
import dev.ftb.mods.ftbchunks.data.ChunkTeamDataImpl;
import dev.ftb.mods.ftbchunks.data.ClaimExpirationManager;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkImpl;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManagerImpl;
import dev.ftb.mods.ftbchunks.net.ChunkSendingUtils;
import dev.ftb.mods.ftbchunks.net.FTBChunksNet;
import dev.ftb.mods.ftbchunks.net.LoginDataPacket;
import dev.ftb.mods.ftbchunks.net.PlayerDeathPacket;
import dev.ftb.mods.ftbchunks.net.PlayerVisibilityPacket;
import dev.ftb.mods.ftbchunks.net.SendChunkPacket;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftbchunks.net.SendManyChunksPacket;
import dev.ftb.mods.ftblibrary.integration.stages.StageHelper;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.config.ConfigUtil;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.event.PlayerJoinedPartyTeamEvent;
import dev.ftb.mods.ftbteams.api.event.PlayerLeftPartyTeamEvent;
import dev.ftb.mods.ftbteams.api.event.PlayerLoggedInAfterTeamEvent;
import dev.ftb.mods.ftbteams.api.event.PlayerTransferredTeamOwnershipEvent;
import dev.ftb.mods.ftbteams.api.event.TeamAllyEvent;
import dev.ftb.mods.ftbteams.api.event.TeamCollectPropertiesEvent;
import dev.ftb.mods.ftbteams.api.event.TeamCreatedEvent;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import dev.ftb.mods.ftbteams.api.event.TeamManagerEvent;
import dev.ftb.mods.ftbteams.api.event.TeamPropertiesChangedEvent;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class FTBChunks {
    public static final String MOD_ID = "ftbchunks";
    public static final Logger LOGGER = LogManager.getLogger((String)"FTB Chunks");
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setLenient().create();
    public static final ExecutorService EXECUTOR = Executors.newSingleThreadExecutor();
    public static FTBChunks instance;
    public static final int TILES = 15;
    public static final int TILE_SIZE = 16;
    public static final int TILE_OFFSET = 7;
    public static final int MINIMAP_SIZE = 240;
    public static final XZ[] RELATIVE_SPIRAL_POSITIONS;
    public static final Registrar<Block> BLOCK_REGISTRY;

    public FTBChunks() {
        FTBChunksAPI._init(FTBChunksAPIImpl.INSTANCE);
        FTBChunksNet.init();
        for (int i = 0; i < RELATIVE_SPIRAL_POSITIONS.length; ++i) {
            FTBChunks.RELATIVE_SPIRAL_POSITIONS[i] = MathUtils.getSpiralPoint((int)(i + 1));
        }
        LifecycleEvent.SERVER_BEFORE_START.register(this::serverBeforeStart);
        LifecycleEvent.SERVER_LEVEL_LOAD.register(this::serverLevelLoad);
        TeamManagerEvent.CREATED.register(this::teamManagerCreated);
        TeamManagerEvent.DESTROYED.register(this::teamManagerDestroyed);
        TeamEvent.PLAYER_LOGGED_IN.register(this::loggedIn);
        TeamEvent.CREATED.register(this::teamCreated);
        TeamEvent.LOADED.register(this::teamLoaded);
        TeamEvent.SAVED.register(this::teamSaved);
        TeamEvent.COLLECT_PROPERTIES.register(this::teamConfig);
        TeamEvent.PLAYER_JOINED_PARTY.register(this::playerJoinedParty);
        TeamEvent.PLAYER_LEFT_PARTY.register(this::playerLeftParty);
        TeamEvent.OWNERSHIP_TRANSFERRED.register(this::teamOwnershipTransferred);
        TeamEvent.PROPERTIES_CHANGED.register(this::teamPropertiesChanged);
        TeamEvent.ADD_ALLY.register(this::playerAllianceChange);
        TeamEvent.REMOVE_ALLY.register(this::playerAllianceChange);
        InteractionEvent.LEFT_CLICK_BLOCK.register(this::blockLeftClick);
        InteractionEvent.RIGHT_CLICK_BLOCK.register(this::blockRightClick);
        InteractionEvent.RIGHT_CLICK_ITEM.register(this::itemRightClick);
        InteractionEvent.INTERACT_ENTITY.register(this::interactEntity);
        InteractionEvent.FARMLAND_TRAMPLE.register(this::farmlandTrample);
        BlockEvent.BREAK.register(this::blockBreak);
        BlockEvent.PLACE.register(this::blockPlace);
        PlayerEvent.PLAYER_QUIT.register(this::loggedOut);
        PlayerEvent.FILL_BUCKET.register(this::fillBucket);
        PlayerEvent.PLAYER_CLONE.register(this::playerCloned);
        PlayerEvent.CHANGE_DIMENSION.register(this::playerChangedDimension);
        PlayerEvent.ATTACK_ENTITY.register(this::playerAttackEntity);
        EntityEvent.ENTER_SECTION.register(this::enterSection);
        EntityEvent.LIVING_CHECK_SPAWN.register(this::checkSpawn);
        ExplosionEvent.DETONATE.register(this::explosionDetonate);
        CommandRegistrationEvent.EVENT.register(FTBChunksCommands::registerCommands);
        TickEvent.SERVER_POST.register(this::serverTickPost);
        TickEvent.PLAYER_POST.register(this::playerTickPost);
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> FTBChunksClient.INSTANCE::init);
    }

    private EventResult playerAttackEntity(Player player, Level level, Entity entity, InteractionHand interactionHand, @Nullable EntityHitResult entityHitResult) {
        if (player instanceof ServerPlayer && !(entity instanceof LivingEntity) && ClaimedChunkManagerImpl.getInstance().shouldPreventInteraction((Entity)player, interactionHand, entity.m_20183_(), Protection.ATTACK_NONLIVING_ENTITY, entity)) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private void playerTickPost(Player player) {
        if (player.m_9236_().f_46443_ && player.m_9236_().m_46467_() % 20L == 0L) {
            FTBChunksClient.INSTANCE.maybeClearDeathpoint(player);
        }
    }

    private void serverBeforeStart(MinecraftServer server) {
        Path configPath = server.m_129843_(ConfigUtil.SERVER_CONFIG_DIR);
        ConfigUtil.loadDefaulted((SNBTConfig)FTBChunksWorldConfig.CONFIG, (Path)configPath, (String)MOD_ID);
    }

    private void serverLevelLoad(ServerLevel level) {
        if (ClaimedChunkManagerImpl.getInstance() != null) {
            ClaimedChunkManagerImpl.getInstance().initForceLoadedChunks(level);
        } else {
            LOGGER.warn("Level " + level.m_46472_().m_135782_() + " loaded before FTB Chunks manager was initialized! Unable to force-load chunks");
        }
    }

    private void teamManagerCreated(TeamManagerEvent event) {
        ClaimedChunkManagerImpl.init(event.getManager());
    }

    private void teamManagerDestroyed(TeamManagerEvent event) {
        ClaimedChunkManagerImpl.shutdown();
    }

    private void loggedIn(PlayerLoggedInAfterTeamEvent event) {
        ServerPlayer player = event.getPlayer();
        ChunkTeamDataImpl data = ClaimedChunkManagerImpl.getInstance().getOrCreateData(player);
        data.updateLimits();
        String playerId = event.getPlayer().m_20148_().toString();
        LOGGER.debug("handling player team login: player = {}, team = {}", (Object)playerId, (Object)data.getTeamId());
        SNBTCompoundTag config = new SNBTCompoundTag();
        FTBChunksWorldConfig.CONFIG.write(config);
        UUID managerId = FTBTeamsAPI.api().getManager().getId();
        new LoginDataPacket(managerId, config).sendTo(player);
        SendGeneralDataPacket.send((ChunkTeamData)data, player);
        LOGGER.debug("server config and team data sent to {}", (Object)playerId);
        long now = System.currentTimeMillis();
        HashMap<Pair, List> chunksToSend = new HashMap<Pair, List>();
        for (ClaimedChunkImpl chunk : ClaimedChunkManagerImpl.getInstance().getAllClaimedChunks()) {
            chunksToSend.computeIfAbsent(Pair.of((Object)chunk.getPos().dimension(), (Object)chunk.getTeamData().getTeamId()), s -> new ArrayList()).add(new SendChunkPacket.SingleChunk(now, chunk.getPos().x(), chunk.getPos().z(), chunk));
        }
        chunksToSend.forEach((dimensionAndId, chunkPackets) -> FTBTeamsAPI.api().getManager().getTeamByID((UUID)dimensionAndId.getRight()).ifPresent(team -> {
            ChunkTeamDataImpl teamData = ClaimedChunkManagerImpl.getInstance().getOrCreateData((Team)team);
            if (teamData.canPlayerUse(player, FTBChunksProperties.CLAIM_VISIBILITY)) {
                SendManyChunksPacket packet = new SendManyChunksPacket((ResourceKey<Level>)((ResourceKey)dimensionAndId.getLeft()), (UUID)dimensionAndId.getRight(), (List<SendChunkPacket.SingleChunk>)chunkPackets);
                packet.sendTo(player);
            }
        }));
        LOGGER.debug("claimed chunk data sent to {}", (Object)playerId);
        data.setLastLoginTime(now);
        data.setForceLoadMember(player.m_20148_(), FTBChunksWorldConfig.canPlayerOfflineForceload(player));
        if (data.getTeam().getOnlineMembers().size() == 1 && !data.canDoOfflineForceLoading()) {
            data.updateChunkTickets(true);
        }
        PlayerVisibilityPacket.syncToLevel(player.m_9236_());
        LOGGER.debug("visible player list sent to {}", (Object)playerId);
    }

    public void loggedOut(ServerPlayer player) {
        if (!FTBTeamsAPI.api().isManagerLoaded() || !FTBChunksAPI.api().isManagerLoaded()) {
            return;
        }
        ChunkTeamDataImpl data = ClaimedChunkManagerImpl.getInstance().getOrCreateData(player);
        if (data != null) {
            data.setForceLoadMember(player.m_20148_(), FTBChunksWorldConfig.canPlayerOfflineForceload(player));
            ClaimedChunkManagerImpl.getInstance().clearForceLoadedCache();
            LongRangePlayerTracker.INSTANCE.stopTracking(player);
            if (data.getTeam().getOnlineMembers().size() == 1 && !data.canDoOfflineForceLoading()) {
                data.updateChunkTickets(false);
            }
        } else {
            LOGGER.warn("on player disconnect: player '{}' has no team?", (Object)player.m_36316_().getName());
        }
    }

    private void teamCreated(TeamCreatedEvent teamEvent) {
        ClaimedChunkManagerImpl.getInstance().getOrCreateData(teamEvent.getTeam());
    }

    private void teamLoaded(TeamEvent teamEvent) {
        ClaimedChunkManagerImpl.getInstance().getOrCreateData(teamEvent.getTeam());
    }

    private void teamSaved(TeamEvent teamEvent) {
        ClaimedChunkManagerImpl.getInstance().getOrCreateData(teamEvent.getTeam()).saveNow();
    }

    public EventResult blockLeftClick(Player player, InteractionHand hand, BlockPos pos, Direction face) {
        if (player instanceof ServerPlayer && ClaimedChunkManagerImpl.getInstance().shouldPreventInteraction((Entity)player, hand, pos, FTBChunksExpected.getBlockBreakProtection(), null)) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public EventResult blockRightClick(Player player, InteractionHand hand, BlockPos pos, Direction face) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            if (ClaimedChunkManagerImpl.getInstance().shouldPreventInteraction((Entity)player, hand, pos, FTBChunksExpected.getBlockInteractProtection(), null)) {
                FTBCUtils.forceHeldItemSync(sp, hand);
                return EventResult.interruptFalse();
            }
        }
        return EventResult.pass();
    }

    public CompoundEventResult<ItemStack> itemRightClick(Player player, InteractionHand hand) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            if (ClaimedChunkManagerImpl.getInstance().shouldPreventInteraction((Entity)player, hand, BlockPos.m_274446_((Position)player.m_20299_(1.0f)), Protection.RIGHT_CLICK_ITEM, null)) {
                FTBCUtils.forceHeldItemSync(sp, hand);
                return CompoundEventResult.interruptFalse((Object)player.m_21120_(hand));
            }
        }
        return CompoundEventResult.pass();
    }

    private EventResult interactEntity(Player player, Entity entity, InteractionHand hand) {
        if (player instanceof ServerPlayer && ClaimedChunkManagerImpl.getInstance().shouldPreventInteraction((Entity)player, hand, entity.m_20183_(), Protection.INTERACT_ENTITY, entity)) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public EventResult blockBreak(Level level, BlockPos pos, BlockState blockState, ServerPlayer player, @Nullable IntValue intValue) {
        if (ClaimedChunkManagerImpl.getInstance().shouldPreventInteraction((Entity)player, InteractionHand.MAIN_HAND, pos, FTBChunksExpected.getBlockBreakProtection(), null)) {
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public EventResult blockPlace(Level level, BlockPos pos, BlockState blockState, @Nullable Entity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)entity;
            if (ClaimedChunkManagerImpl.getInstance().shouldPreventInteraction(entity, InteractionHand.MAIN_HAND, pos, FTBChunksExpected.getBlockPlaceProtection(), null)) {
                FTBCUtils.forceHeldItemSync(sp, InteractionHand.MAIN_HAND);
                return EventResult.interruptFalse();
            }
        }
        return EventResult.pass();
    }

    public CompoundEventResult<ItemStack> fillBucket(Player player, Level level, ItemStack emptyBucket, @Nullable HitResult target) {
        if (player instanceof ServerPlayer && target instanceof BlockHitResult) {
            BlockHitResult hitResult = (BlockHitResult)target;
            InteractionHand hand = player.m_7655_();
            if (ClaimedChunkManagerImpl.getInstance().shouldPreventInteraction((Entity)player, hand, hitResult.m_82425_(), Protection.EDIT_FLUID, null)) {
                return CompoundEventResult.interrupt((Boolean)false, (Object)player.m_21120_(hand));
            }
        }
        return CompoundEventResult.pass();
    }

    public EventResult farmlandTrample(Level world, BlockPos pos, BlockState blockState, float distance, Entity entity) {
        if (entity instanceof ServerPlayer && ClaimedChunkManagerImpl.getInstance().shouldPreventInteraction(entity, InteractionHand.MAIN_HAND, pos, Protection.EDIT_BLOCK, null)) {
            return EventResult.interrupt((Boolean)false);
        }
        return EventResult.pass();
    }

    public void enterSection(Entity entity, int chunkX, int chunkY, int chunkZ, int prevX, int prevY, int prevZ) {
        ServerPlayer player;
        if (chunkX == prevX && chunkZ == prevZ && chunkY != prevY || !(entity instanceof ServerPlayer) || PlayerHooks.isFake((Player)(player = (ServerPlayer)entity)) || !FTBTeamsAPI.api().isManagerLoaded() || !FTBChunksAPI.api().isManagerLoaded()) {
            return;
        }
        FTBTeamsAPI.api().getManager().getTeamForPlayerID(player.m_20148_()).ifPresent(team -> {
            ChunkTeamDataImpl data = ClaimedChunkManagerImpl.getInstance().getOrCreateData((Team)team);
            data.checkForChunkChange((Player)player, chunkX, chunkZ);
        });
    }

    public EventResult checkSpawn(LivingEntity entity, LevelAccessor levelAccessor, double x, double y, double z, MobSpawnType type, @Nullable BaseSpawner spawner) {
        if (!levelAccessor.m_5776_() && !(entity instanceof Player) && levelAccessor instanceof Level) {
            Level level = (Level)levelAccessor;
            switch (type) {
                case NATURAL: 
                case CHUNK_GENERATION: 
                case SPAWNER: 
                case STRUCTURE: 
                case JOCKEY: 
                case PATROL: {
                    ClaimedChunkImpl chunk = ClaimedChunkManagerImpl.getInstance().getChunk(new ChunkDimPos(level, BlockPos.m_274561_((double)x, (double)y, (double)z)));
                    if (chunk == null || chunk.canEntitySpawn((Entity)entity)) break;
                    return EventResult.interrupt((Boolean)false);
                }
            }
        }
        return EventResult.pass();
    }

    private boolean ignoreExplosion(Level level, Explosion explosion) {
        if (level.m_5776_() || explosion.m_46081_().isEmpty()) {
            return true;
        }
        return explosion.f_46016_ == null && (Boolean)FTBChunksWorldConfig.PROTECT_UNKNOWN_EXPLOSIONS.get() == false;
    }

    public void explosionDetonate(Level level, Explosion explosion, List<Entity> affectedEntities) {
        if (this.ignoreExplosion(level, explosion)) {
            return;
        }
        ArrayList list = new ArrayList(explosion.m_46081_());
        explosion.m_46080_();
        HashMap<ChunkDimPos, Boolean> map = new HashMap<ChunkDimPos, Boolean>();
        for (BlockPos pos : list) {
            if (!map.computeIfAbsent(new ChunkDimPos(level, pos), cpos -> {
                ClaimedChunkImpl chunk = ClaimedChunkManagerImpl.getInstance().getChunk((ChunkDimPos)cpos);
                return chunk == null || chunk.allowExplosions();
            }).booleanValue()) continue;
            explosion.m_46081_().add(pos);
        }
    }

    private void playerCloned(ServerPlayer oldPlayer, ServerPlayer newPlayer, boolean wonGame) {
        if (!wonGame) {
            newPlayer.m_219759_().ifPresent(loc -> {
                int num = newPlayer.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12935_));
                new PlayerDeathPacket((GlobalPos)loc, num).sendTo(newPlayer);
            });
        }
    }

    private void playerChangedDimension(ServerPlayer serverPlayer, ResourceKey<Level> oldLevel, ResourceKey<Level> newLevel) {
        LongRangePlayerTracker.INSTANCE.stopTracking(serverPlayer);
        StageHelper.INSTANCE.getProvider().sync(serverPlayer);
    }

    private void teamConfig(TeamCollectPropertiesEvent event) {
        event.add((TeamProperty)FTBChunksProperties.ALLOW_EXPLOSIONS);
        event.add((TeamProperty)FTBChunksProperties.ALLOW_MOB_GRIEFING);
        event.add((TeamProperty)FTBChunksProperties.ALLOW_ALL_FAKE_PLAYERS);
        event.add((TeamProperty)FTBChunksProperties.ALLOW_NAMED_FAKE_PLAYERS);
        event.add((TeamProperty)FTBChunksProperties.ALLOW_FAKE_PLAYERS_BY_ID);
        FTBChunksExpected.getPlatformSpecificProperties(event);
        event.add((TeamProperty)FTBChunksProperties.ENTITY_INTERACT_MODE);
        event.add((TeamProperty)FTBChunksProperties.NONLIVING_ENTITY_ATTACK_MODE);
        event.add((TeamProperty)FTBChunksProperties.CLAIM_VISIBILITY);
        event.add((TeamProperty)FTBChunksProperties.LOCATION_MODE);
    }

    private void playerJoinedParty(PlayerJoinedPartyTeamEvent event) {
        ChunkTeamDataImpl playerData = ClaimedChunkManagerImpl.getInstance().getOrCreateData(event.getPreviousTeam());
        ChunkTeamDataImpl partyData = ClaimedChunkManagerImpl.getInstance().getOrCreateData(event.getTeam());
        partyData.addMemberData(event.getPlayer(), playerData);
        partyData.updateLimits();
        this.transferClaims(playerData, partyData, playerData.getClaimedChunks());
        partyData.setForceLoadMember(event.getPlayer().m_20148_(), FTBChunksWorldConfig.canPlayerOfflineForceload(event.getPlayer()));
        PlayerVisibilityPacket.syncToLevel(event.getPlayer().m_9236_());
        partyData.syncChunksToPlayer(event.getPlayer());
    }

    private void playerLeftParty(PlayerLeftPartyTeamEvent event) {
        ChunkTeamDataImpl partyData = ClaimedChunkManagerImpl.getInstance().getOrCreateData(event.getTeam());
        FTBTeamsAPI.api().getManager().getPlayerTeamForPlayerID(event.getPlayerId()).ifPresent(personalTeam -> {
            ChunkTeamDataImpl playerData = ClaimedChunkManagerImpl.getInstance().getOrCreateData((Team)personalTeam);
            if (event.getTeamDeleted()) {
                this.transferClaims(partyData, playerData, partyData.getClaimedChunks());
                ClaimedChunkManagerImpl.getInstance().deleteTeam(event.getTeam());
            } else {
                this.transferClaims(partyData, playerData, partyData.getOriginalClaims(event.getPlayerId()));
            }
        });
        partyData.deleteMemberData(event.getPlayerId());
        partyData.updateLimits();
        if (event.getPlayer() != null) {
            PlayerVisibilityPacket.syncToLevel(event.getPlayer().m_9236_());
            partyData.syncChunksToPlayer(event.getPlayer());
        }
    }

    private void transferClaims(ChunkTeamDataImpl transferFrom, ChunkTeamDataImpl transferTo, Collection<ClaimedChunkImpl> chunksToTransfer) {
        CommandSourceStack sourceStack = ClaimedChunkManagerImpl.getInstance().getMinecraftServer().m_129893_();
        HashMap<ResourceKey, List> chunksToSend = new HashMap<ResourceKey, List>();
        HashMap<ResourceKey, List> chunksToUnclaim = new HashMap<ResourceKey, List>();
        int chunks = 0;
        long now = System.currentTimeMillis();
        int total = transferTo.getClaimedChunks().size();
        for (ClaimedChunkImpl chunk : chunksToTransfer) {
            ServerLevel level;
            ChunkDimPos cdp = chunk.getPos();
            if (total >= transferTo.getMaxClaimChunks()) {
                chunk.unclaim(sourceStack, false);
                chunksToUnclaim.computeIfAbsent(cdp.dimension(), s -> new ArrayList()).add(new SendChunkPacket.SingleChunk(now, cdp.x(), cdp.z(), null));
            } else {
                chunk.setTeamData(transferTo);
                chunksToSend.computeIfAbsent(cdp.dimension(), s -> new ArrayList()).add(new SendChunkPacket.SingleChunk(now, cdp.x(), cdp.z(), chunk));
                ++chunks;
            }
            if (chunk.isForceLoaded() && (level = ClaimedChunkManagerImpl.getInstance().getMinecraftServer().m_129880_(cdp.dimension())) != null) {
                FTBChunksExpected.addChunkToForceLoaded(level, MOD_ID, transferFrom.getTeamId(), cdp.x(), cdp.z(), false);
                if (chunk.isActuallyForceLoaded()) {
                    FTBChunksExpected.addChunkToForceLoaded(level, MOD_ID, transferTo.getTeamId(), cdp.x(), cdp.z(), true);
                }
            }
            ++total;
        }
        transferFrom.markDirty();
        transferTo.markDirty();
        if (chunks > 0) {
            chunksToSend.forEach((dimension, chunkPackets) -> {
                if (!chunkPackets.isEmpty()) {
                    ChunkSendingUtils.sendManyChunksToAll(sourceStack.m_81377_(), transferTo, new SendManyChunksPacket((ResourceKey<Level>)dimension, transferTo.getTeamId(), (List<SendChunkPacket.SingleChunk>)chunkPackets));
                }
            });
            chunksToUnclaim.forEach((dimension, chunkPackets) -> {
                if (!chunkPackets.isEmpty()) {
                    new SendManyChunksPacket((ResourceKey<Level>)dimension, Util.f_137441_, (List<SendChunkPacket.SingleChunk>)chunkPackets).sendToAll(sourceStack.m_81377_());
                }
            });
            LOGGER.info("Transferred " + chunks + "/" + total + " chunks from " + transferFrom + " to " + transferTo);
        }
    }

    private void teamOwnershipTransferred(PlayerTransferredTeamOwnershipEvent event) {
        ChunkTeamDataImpl data = ClaimedChunkManagerImpl.getInstance().getOrCreateData(event.getTeam());
        data.updateLimits();
    }

    private void teamPropertiesChanged(TeamPropertiesChangedEvent event) {
        MinecraftServer server = ClaimedChunkManagerImpl.getInstance().getMinecraftServer();
        if (server == null) {
            return;
        }
        if (event.getPreviousProperties().get((TeamProperty)FTBChunksProperties.LOCATION_MODE) != event.getTeam().getProperty((TeamProperty)FTBChunksProperties.LOCATION_MODE)) {
            PlayerVisibilityPacket.syncToAll();
        }
        if (event.getPreviousProperties().get((TeamProperty)FTBChunksProperties.CLAIM_VISIBILITY) != event.getTeam().getProperty((TeamProperty)FTBChunksProperties.CLAIM_VISIBILITY)) {
            ChunkTeamDataImpl teamData = ClaimedChunkManagerImpl.getInstance().getOrCreateData(event.getTeam());
            teamData.syncChunksToAll(server);
        }
        ClaimedChunkManagerImpl.getInstance().getOrCreateData(event.getTeam()).clearFakePlayerNameCache();
    }

    private void playerAllianceChange(TeamAllyEvent event) {
        ChunkTeamDataImpl teamData = ClaimedChunkManagerImpl.getInstance().getOrCreateData(event.getTeam());
        ArrayList<ServerPlayer> players = new ArrayList<ServerPlayer>();
        event.getPlayers().forEach(profile -> {
            ServerPlayer p = ClaimedChunkManagerImpl.getInstance().getMinecraftServer().m_6846_().m_11259_(profile.getId());
            if (p != null) {
                teamData.syncChunksToPlayer(p);
                players.add(p);
            }
        });
        PlayerVisibilityPacket.syncToPlayers(players);
    }

    private void serverTickPost(MinecraftServer minecraftServer) {
        ClaimExpirationManager.INSTANCE.tick(minecraftServer);
        LongRangePlayerTracker.INSTANCE.tick(minecraftServer);
    }

    static {
        RELATIVE_SPIRAL_POSITIONS = new XZ[225];
        BLOCK_REGISTRY = RegistrarManager.get((String)MOD_ID).get(Registries.f_256747_);
    }
}

