/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.world.features;

import com.kyanite.deeperdarker.content.DDBlocks;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SculkStoneColumnFeature
extends Feature<NoneFeatureConfiguration> {
    public SculkStoneColumnFeature(Codec<NoneFeatureConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> pContext) {
        BlockPos pos;
        WorldGenLevel level = pContext.m_159774_();
        BlockPos origin = pContext.m_159777_();
        RandomSource random = pContext.m_225041_();
        int columnHeight = 0;
        while (level.m_8055_((pos = new BlockPos(origin.m_123341_(), origin.m_123342_() + columnHeight + 1, origin.m_123343_())).m_7495_()).m_60795_()) {
            ++columnHeight;
        }
        if (this.anyObstruction(level, origin, columnHeight)) {
            return false;
        }
        if (!level.m_8055_(origin.m_7495_()).m_60713_(Blocks.f_220855_)) {
            return false;
        }
        level.m_7731_(origin.m_7495_(), ((Block)DDBlocks.SCULK_STONE.get()).m_49966_(), 3);
        level.m_7731_(origin.m_6630_(columnHeight), ((Block)DDBlocks.SCULK_STONE.get()).m_49966_(), 3);
        for (int i = 1; i < columnHeight + 1; ++i) {
            int newY = origin.m_123342_() + i - 1;
            BlockPos pos2 = new BlockPos(origin.m_123341_(), newY, origin.m_123343_());
            level.m_7731_(pos2, ((Block)DDBlocks.SCULK_STONE.get()).m_49966_(), 3);
        }
        double multiplier = (float)columnHeight * 0.35f < 7.0f ? 1.2 : 1.0;
        this.columnBase(level, random, origin, columnHeight, multiplier, true);
        this.columnBase(level, random, origin.m_6630_(columnHeight - 1), columnHeight, multiplier, false);
        return true;
    }

    private boolean anyObstruction(WorldGenLevel level, BlockPos pos, int distance) {
        for (int i = 0; i < distance; ++i) {
            if (level.m_8055_(pos.m_6630_(i)).m_60713_(Blocks.f_50016_)) continue;
            return true;
        }
        return false;
    }

    private void columnBase(WorldGenLevel level, RandomSource random, BlockPos origin, int columnHeight, double multiplier, boolean bottom) {
        int baseHeight;
        int i;
        for (i = 0; i < 4; ++i) {
            baseHeight = random.m_216339_((int)(0.36 * (double)columnHeight * multiplier), (int)(0.41 * (double)columnHeight * multiplier) + 1);
            this.placeSection(level, random, origin, baseHeight, i, 1, multiplier, bottom);
            this.stretchToFloor(level, origin, i, 1, bottom);
        }
        for (i = 0; i < 8; ++i) {
            baseHeight = random.m_216339_((int)(0.22 * (double)columnHeight), (int)(0.26 * (double)columnHeight) + 1);
            if (i > 3) {
                baseHeight = (int)((double)baseHeight * 0.67);
            }
            this.placeSection(level, random, origin, baseHeight, i, 2, multiplier, bottom);
            this.stretchToFloor(level, origin, i, 2, bottom);
        }
        if (multiplier > 1.0) {
            return;
        }
        for (i = 0; i < 8; ++i) {
            baseHeight = random.m_216339_((int)(0.04 * (double)columnHeight), (int)(0.08 * (double)columnHeight) + 1);
            this.placeSection(level, random, origin, baseHeight, i, 3, multiplier, bottom);
            this.stretchToFloor(level, origin, i, 3, bottom);
        }
    }

    private void placeSection(WorldGenLevel level, RandomSource random, BlockPos pos, int baseHeight, int iteration, int loop, double multiplier, boolean bottom) {
        float p = random.m_188501_();
        for (int j = 0; j < baseHeight; ++j) {
            BlockPos location = this.spread(bottom ? pos.m_6630_(j) : pos.m_6625_(j), iteration, loop);
            if (iteration > 3 && multiplier > 1.0) {
                return;
            }
            if (j == baseHeight - 2 && j != 0 && p < 0.1f) {
                level.m_7731_(location, Blocks.f_220855_.m_49966_(), 3);
                continue;
            }
            if (j == baseHeight - 1 && j != 0 && p < 0.22f) {
                level.m_7731_(location, Blocks.f_220855_.m_49966_(), 3);
                continue;
            }
            level.m_7731_(location, ((Block)DDBlocks.SCULK_STONE.get()).m_49966_(), 3);
        }
    }

    private BlockPos spread(BlockPos pos, int index, int loop) {
        BlockPos basePos = pos;
        block5: for (int i = 0; i < loop; ++i) {
            int j = i % 2;
            if (index > 3 && loop == 2 && i == 0) {
                ++j;
            } else if (index > 3 && i != 1) {
                j += 2;
            }
            switch ((index + j) % 4) {
                default: {
                    basePos = basePos.m_122012_();
                    continue block5;
                }
                case 1: {
                    basePos = basePos.m_122029_();
                    continue block5;
                }
                case 2: {
                    basePos = basePos.m_122019_();
                    continue block5;
                }
                case 3: {
                    basePos = basePos.m_122024_();
                }
            }
        }
        return basePos;
    }

    private void stretchToFloor(WorldGenLevel level, BlockPos pos, int i, int loop, boolean bottom) {
        BlockPos blockPos = this.spread(bottom ? pos.m_7495_() : pos.m_7494_(), i, loop);
        if (bottom) {
            while (!level.m_8055_(blockPos).m_60713_((Block)DDBlocks.SCULK_STONE.get()) && !level.m_8055_(blockPos).m_60713_(Blocks.f_152550_)) {
                level.m_7731_(blockPos, ((Block)DDBlocks.SCULK_STONE.get()).m_49966_(), 3);
                blockPos = blockPos.m_7495_();
            }
            return;
        }
        while (!(level.m_8055_(blockPos).m_60713_(Blocks.f_220855_) || level.m_8055_(blockPos).m_60713_((Block)DDBlocks.SCULK_STONE.get()) || level.m_8055_(blockPos).m_60713_(Blocks.f_152550_))) {
            level.m_7731_(blockPos, ((Block)DDBlocks.SCULK_STONE.get()).m_49966_(), 3);
            blockPos = blockPos.m_7494_();
        }
    }
}

