/*
 * Decompiled with CFR 0.152.
 */
package com.kyanite.deeperdarker.content.entities;

import com.kyanite.deeperdarker.content.DDEntities;
import com.kyanite.deeperdarker.content.DDSounds;
import com.kyanite.deeperdarker.content.entities.DDMobType;
import com.kyanite.deeperdarker.content.entities.goals.DisturbanceGoal;
import com.kyanite.deeperdarker.content.entities.goals.DisturbanceListener;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.GameEventTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.Nullable;

public class Stalker
extends Monster
implements DisturbanceListener,
VibrationSystem {
    private static final EntityDataAccessor<Integer> RING_COOLDOWN = SynchedEntityData.m_135353_(Stalker.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public final AnimationState idleState = new AnimationState();
    public final AnimationState attackState = new AnimationState();
    public final AnimationState ringAttackState = new AnimationState();
    public final AnimationState emergeState = new AnimationState();
    private final DynamicGameEventListener<VibrationSystem.Listener> dynamicGameEventListener = new DynamicGameEventListener((GameEventListener)new VibrationSystem.Listener((VibrationSystem)this));
    private final VibrationSystem.User vibrationUser = new VibrationUser();
    private final VibrationSystem.Data vibrationData = new VibrationSystem.Data();
    public BlockPos disturbanceLocation;
    private boolean playersInRange;

    public Stalker(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, 8.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true));
        this.f_21345_.m_25352_(2, (Goal)new DisturbanceGoal((PathfinderMob)this, 1.1));
        this.f_21345_.m_25352_(3, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.9));
        this.f_21345_.m_25352_(4, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.4));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
    }

    public static AttributeSupplier createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22281_, 19.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22278_, 1.0).m_22265_();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)DDSounds.STALKER_AMBIENT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)DDSounds.STALKER_DEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)DDSounds.STALKER_HURT.get();
    }

    public MobType m_6336_() {
        return DDMobType.SCULK;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RING_COOLDOWN, (Object)this.m_217043_().m_216339_(200, 600));
    }

    public boolean m_7327_(Entity pEntity) {
        this.m_9236_().m_7605_((Entity)this, (byte)4);
        return super.m_7327_(pEntity);
    }

    public void m_8119_() {
        List players;
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            VibrationSystem.Ticker.m_280259_((Level)level2, (VibrationSystem.Data)this.vibrationData, (VibrationSystem.User)this.vibrationUser);
        }
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.f_19804_.m_135381_(RING_COOLDOWN, (Object)((Integer)this.f_19804_.m_135370_(RING_COOLDOWN) - 1));
            if (!this.attackState.m_216984_() && !this.idleState.m_216984_()) {
                this.idleState.m_216977_(this.f_19797_);
            }
            if (this.m_20089_() == Pose.EMERGING) {
                double sX = this.f_19796_.m_188583_() * 0.02;
                double sY = this.f_19796_.m_188583_() * 0.02;
                double sZ = this.f_19796_.m_188583_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.m_20075_()), this.m_20185_() - this.f_19796_.m_188500_(), this.m_20186_() + 1.0, this.m_20189_() - this.f_19796_.m_188500_(), sX, sY, sZ);
            }
        }
        if (this.f_20891_ > 70) {
            this.m_20124_(Pose.STANDING);
        }
        if (!(players = this.m_9236_().m_45955_(TargetingConditions.m_148352_().m_26883_(10.0), (LivingEntity)this, this.m_20191_().m_82377_(10.0, 8.0, 10.0))).isEmpty()) {
            if ((Integer)this.f_19804_.m_135370_(RING_COOLDOWN) <= -100) {
                this.playersInRange = false;
                this.f_19804_.m_135381_(RING_COOLDOWN, (Object)this.m_217043_().m_216339_(200, 600));
                if (this.m_9236_().m_5776_()) {
                    this.ringAttackState.m_216973_();
                }
            } else if ((Integer)this.f_19804_.m_135370_(RING_COOLDOWN) <= 0) {
                if (this.m_9236_().m_5776_()) {
                    this.ringAttackState.m_216977_(this.f_19797_);
                }
                this.playersInRange = true;
            }
        } else if (this.playersInRange) {
            this.playersInRange = false;
            this.f_19804_.m_135381_(RING_COOLDOWN, (Object)this.m_217043_().m_216339_(200, 600));
            if (this.m_9236_().m_5776_()) {
                this.ringAttackState.m_216973_();
            }
        }
    }

    public void m_7822_(byte pId) {
        if (pId == 4) {
            this.idleState.m_216973_();
            this.attackState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(pId);
        }
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (pKey.equals((Object)f_19806_)) {
            if (this.m_20089_() == Pose.EMERGING) {
                this.emergeState.m_216977_(this.f_19797_);
            }
            if (this.m_20089_() == Pose.STANDING) {
                this.emergeState.m_216973_();
            }
        }
        super.m_7350_(pKey);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        if (pReason == MobSpawnType.TRIGGERED) {
            this.m_20124_(Pose.EMERGING);
        }
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public void m_213651_(BiConsumer<DynamicGameEventListener<?>, ServerLevel> pListenerConsumer) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            pListenerConsumer.accept(this.dynamicGameEventListener, level2);
        }
    }

    public boolean canTargetEntity(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return this.m_9236_() == entity.m_9236_() && EntitySelector.f_20406_.test(entity) && !this.m_7307_(entity) && livingEntity.m_6095_() != EntityType.f_20529_ && livingEntity.m_6095_() != DDEntities.SHATTERED.get() && !livingEntity.m_20147_() && !livingEntity.m_21224_() && this.m_9236_().m_6857_().m_61935_(livingEntity.m_20191_());
        }
        return false;
    }

    @Override
    public BlockPos getDisturbanceLocation() {
        return this.disturbanceLocation;
    }

    @Override
    public void setDisturbanceLocation(BlockPos disturbancePos) {
        this.disturbanceLocation = disturbancePos;
    }

    public VibrationSystem.Data m_280002_() {
        return this.vibrationData;
    }

    public VibrationSystem.User m_280445_() {
        return this.vibrationUser;
    }

    class VibrationUser
    implements VibrationSystem.User {
        private final PositionSource positionSource;

        VibrationUser() {
            this.positionSource = new EntityPositionSource((Entity)Stalker.this, Stalker.this.m_20192_());
        }

        public int m_280351_() {
            return 20;
        }

        public PositionSource m_280010_() {
            return this.positionSource;
        }

        public TagKey<GameEvent> m_280028_() {
            return GameEventTags.f_215853_;
        }

        public boolean m_280076_() {
            return true;
        }

        public boolean m_280080_(ServerLevel level, BlockPos bounds, GameEvent gameEvent, GameEvent.Context context) {
            if (!Stalker.this.m_21525_() && !Stalker.this.m_21224_() && !Stalker.this.m_6274_().m_21874_(MemoryModuleType.f_217774_) && level.m_6857_().m_61937_(bounds)) {
                Entity entity = context.f_223711_();
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    return Stalker.this.canTargetEntity((Entity)livingEntity);
                }
                return true;
            }
            return false;
        }

        public void m_280271_(ServerLevel level, BlockPos pos, GameEvent gameEvent, Entity entity, Entity entity2, float v) {
            if (Stalker.this.m_21224_()) {
                return;
            }
            Stalker.this.m_5496_(SoundEvents.f_215774_, 2.0f, 1.0f);
            if (entity != null && Stalker.this.canTargetEntity(entity)) {
                if (entity instanceof LivingEntity && ((LivingEntity)entity).m_6336_() != DDMobType.SCULK) {
                    Stalker.this.m_6710_((LivingEntity)entity);
                }
                if (entity instanceof Player) {
                    Stalker.this.m_6710_((LivingEntity)entity);
                }
                return;
            }
            if (Stalker.this.m_5448_() != null) {
                Stalker.this.m_6710_(null);
            }
            Stalker.this.disturbanceLocation = pos;
        }
    }
}

