/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.entity.item;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.network.NetworkHooks;
import org.apache.commons.lang3.tuple.Triple;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.api.broom.BroomModifier;
import org.cyclops.evilcraft.api.broom.BroomModifiers;
import org.cyclops.evilcraft.api.broom.IBroom;
import org.cyclops.evilcraft.client.particle.ParticleColoredSmokeData;
import org.cyclops.evilcraft.core.broom.BroomParts;
import org.cyclops.evilcraft.core.helper.MathHelpers;
import org.cyclops.evilcraft.item.ItemBroomConfig;

public class EntityBroom
extends Entity {
    private static final EntityDataAccessor<ItemStack> ITEMSTACK_INDEX = SynchedEntityData.m_135353_(EntityBroom.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    public static final double SPEED = 0.4;
    public static final float MAX_ANGLE = 60.0f;
    public static final float MIN_ANGLE = -60.0f;
    private static final float MAX_COS_AMPLITUDE = 0.2f;
    public LivingEntity lastMounted = null;
    private boolean setLast = false;
    private double lastPlayerSpeed = 0.0;
    private float lastRotationPitch = -1.0f;
    private float lastRotationYaw = -1.0f;
    private double newPosX;
    private double newPosY;
    private double newPosZ;
    private double newRotationYaw;
    private double newRotationPitch;
    private int newPosRotationIncrements;
    private int broomHoverTickOffset;
    @OnlyIn(value=Dist.CLIENT)
    private double oldHoverOffset;
    private Map<BroomModifier, Float> cachedModifiers = null;

    public EntityBroom(EntityType<? extends EntityBroom> type, Level world) {
        this(type, world, 0.0, 0.0, 0.0);
        this.initBroomHoverTickOffset();
    }

    public EntityBroom(EntityType<? extends EntityBroom> type, Level world, double x, double y, double z) {
        super(type, world);
        this.m_6034_(x, y, z);
        this.m_20334_(0.0, 0.0, 0.0);
        this.m_6210_();
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.initBroomHoverTickOffset();
    }

    public EntityBroom(Level world, double x, double y, double z) {
        this(RegistryEntries.ENTITY_BROOM, world, x, y, z);
    }

    @Nonnull
    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public EntityDimensions m_6972_(Pose poseIn) {
        return EntityDimensions.m_20395_((float)1.5f, (float)0.6f);
    }

    protected void initBroomHoverTickOffset() {
        this.broomHoverTickOffset = this.f_19796_.m_188503_(3);
    }

    public double m_6048_() {
        return 0.0;
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (!(this.m_9236_().m_5776_() || this.m_20160_() || player.m_6047_())) {
            player.m_20329_((Entity)this);
            this.lastMounted = player;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7334_(Entity entityIn) {
        LivingEntity controlling;
        if (!(this.m_9236_().m_5776_() || entityIn.f_19794_ || this.f_19794_ || entityIn == (controlling = this.m_6688_()) || !(entityIn instanceof LivingEntity) || entityIn instanceof Player || controlling != null || entityIn.m_20159_())) {
            entityIn.m_20329_((Entity)this);
        }
    }

    public void m_6453_(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean isTeleport) {
        posRotationIncrements += 6;
        this.newPosX = x;
        this.newPosY = y;
        this.newPosZ = z;
        this.newRotationYaw = yaw;
        this.newRotationPitch = pitch;
        this.newPosRotationIncrements = posRotationIncrements;
    }

    public LivingEntity m_6688_() {
        List list = this.m_20197_();
        return list.isEmpty() ? null : (LivingEntity)list.get(0);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.m_9236_().m_5776_() && this.m_6084_()) {
            if (this.m_6673_(source)) {
                return false;
            }
            if (source.m_7639_() instanceof Player && source.m_7639_() != this.lastMounted) {
                if (this.m_20160_()) {
                    this.m_8127_();
                }
                this.m_142687_(Entity.RemovalReason.DISCARDED);
                Player player = (Player)source.m_7639_();
                if (!player.m_7500_()) {
                    ItemStack itemStack = this.getBroomStack().m_41777_();
                    this.m_5552_(itemStack, 0.0f);
                }
            }
        }
        return true;
    }

    public void startAllowFlying(LivingEntity entity) {
        if (entity instanceof Player) {
            ((Player)entity).m_150110_().f_35936_ = true;
        }
    }

    public void stopAllowFlying(LivingEntity entity) {
        if (entity instanceof Player) {
            ((Player)entity).m_150110_().f_35936_ = false;
        }
    }

    protected void m_20348_(Entity passenger) {
        super.m_20348_(passenger);
        if (!this.m_9236_().m_5776_() && passenger instanceof LivingEntity) {
            this.startAllowFlying((LivingEntity)passenger);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        LivingEntity rider = this.m_6688_();
        if (!this.m_9236_().m_5776_() && !this.m_20160_() && this.lastMounted != null) {
            this.onDismount();
        } else if (rider instanceof LivingEntity) {
            List list;
            this.lastMounted = rider;
            this.f_19854_ = this.m_20185_();
            this.f_19855_ = this.m_20186_();
            this.f_19856_ = this.m_20189_();
            this.f_19860_ = this.m_146909_();
            this.f_19859_ = this.m_146908_();
            if (!this.m_9236_().m_5776_() || Minecraft.m_91087_().f_91074_ == this.lastMounted) {
                this.updateMountedServer();
            } else {
                this.updateMountedClient();
            }
            if (MinecraftHelpers.isClientSide() && this.getModifier(BroomModifiers.PARTICLES) > 0.0f) {
                this.showParticles(this);
            }
            if ((list = this.m_9236_().m_45933_((Entity)this, this.m_20191_().m_82377_(0.2, 0.0, 0.2))) != null && !list.isEmpty()) {
                for (int l = 0; l < list.size(); ++l) {
                    Entity entity = (Entity)list.get(l);
                    if (entity == rider || !entity.m_6094_() || entity instanceof EntityBroom) continue;
                    for (Map.Entry<BroomModifier, Float> entry : this.getModifiers().entrySet()) {
                        for (BroomModifier.ICollisionListener listener : entry.getKey().getCollisionListeners()) {
                            listener.onCollide(this, entity, entry.getValue().floatValue());
                        }
                    }
                    entity.m_7334_((Entity)this);
                    float toughnessModifier = 0.5f + this.getModifier(BroomModifiers.STURDYNESS) / BroomModifiers.STURDYNESS.getMaxTierValue() / 2.0f;
                    this.setLastPlayerSpeed(this.getLastPlayerSpeed() * (double)toughnessModifier);
                }
            }
            for (Map.Entry<BroomModifier, Float> entry : this.getModifiers().entrySet()) {
                for (BroomModifier.ITickListener listener : entry.getKey().getTickListeners()) {
                    listener.onTick(this, entry.getValue().floatValue());
                }
            }
        } else {
            if (!this.m_9236_().m_5776_() && rider == null) {
                this.collideWithNearbyEntities();
            }
            this.updateUnmounted();
        }
    }

    private void onDismount() {
        if (this.lastMounted instanceof Player) {
            this.stopAllowFlying(this.lastMounted);
            Player player = (Player)this.lastMounted;
            if (player.m_6084_() && (!MinecraftHelpers.isPlayerInventoryFull((Player)player) || player.m_7500_())) {
                if (!player.m_7500_()) {
                    player.m_150109_().m_36054_(this.getBroomStack());
                }
                this.m_142687_(Entity.RemovalReason.DISCARDED);
            }
        }
        this.lastMounted = null;
    }

    protected boolean m_7310_(Entity passenger) {
        return (float)this.m_20197_().size() < 1.0f + this.getModifier(BroomModifiers.STICKY) / BroomModifiers.STICKY.getMaxTierValue() * 3.0f;
    }

    protected void m_20351_(Entity passenger) {
        if (!this.m_20193_().m_5776_() && this.m_6688_() == passenger) {
            this.onDismount();
        }
        super.m_20351_(passenger);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void showParticles(EntityBroom broom) {
        Level world = broom.m_9236_();
        if (world.m_5776_() && broom.lastMounted.f_20902_ != 0.0f) {
            int particles = (int)(broom.getModifier(BroomModifiers.PARTICLES) * (float)broom.getLastPlayerSpeed());
            Triple<Float, Float, Float> color = BroomModifier.getAverageColor(broom.getModifiers());
            for (int i = 0; i < particles; ++i) {
                float r = ((Float)color.getLeft()).floatValue();
                float g = ((Float)color.getMiddle()).floatValue();
                float b = ((Float)color.getRight()).floatValue();
                Vec3 motion = broom.m_20184_();
                Minecraft.m_91087_().f_91060_.m_109743_((ParticleOptions)new ParticleColoredSmokeData(r, g, b), false, broom.m_20185_() - motion.f_82479_ * 1.5 + Math.random() * 0.4 - 0.2, broom.m_20186_() - motion.f_82480_ * 1.5 + Math.random() * 0.4 - 0.2, broom.m_20189_() - motion.f_82481_ * 1.5 + Math.random() * 0.4 - 0.2, motion.f_82479_ / 10.0, motion.f_82480_ / 10.0, motion.f_82481_ / 10.0);
            }
        }
    }

    protected void collideWithNearbyEntities() {
        List list = this.m_9236_().m_6249_((Entity)this, this.m_20191_().m_82377_((double)0.2f, 0.0, (double)0.2f), EntitySelector.f_20408_.and(Entity::m_6094_));
        if (!list.isEmpty()) {
            for (Entity entity : list) {
                this.m_7334_(entity);
            }
        }
    }

    protected void updateMountedClient() {
        if (this.newPosRotationIncrements > 0) {
            double x = this.m_20185_() + (this.newPosX - this.m_20185_()) / (double)this.newPosRotationIncrements;
            double y = this.m_20186_() + (this.newPosY - this.m_20186_()) / (double)this.newPosRotationIncrements;
            double z = this.m_20189_() + (this.newPosZ - this.m_20189_()) / (double)this.newPosRotationIncrements;
            float yaw = MathHelpers.normalizeAngle_180((float)(this.newRotationYaw - (double)this.m_146908_()));
            this.m_146922_(this.m_146908_() + yaw / (float)this.newPosRotationIncrements);
            this.m_146926_((float)((double)this.m_146909_() + (this.newRotationPitch - (double)this.m_146909_()) / (double)this.newPosRotationIncrements));
            --this.newPosRotationIncrements;
            this.m_6034_(x, y, z);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        }
        this.m_6478_(MoverType.SELF, new Vec3(0.0, this.getHoverOffset(), 0.0));
    }

    public boolean canConsume(int amount, LivingEntity entityLiving) {
        ItemStack broomStack = this.getBroomStack();
        return broomStack != null && broomStack.m_41720_() instanceof IBroom && ((IBroom)broomStack.m_41720_()).canConsumeBroomEnergy(amount, broomStack, entityLiving);
    }

    public void consume(int amount, LivingEntity entityLiving) {
        float efficiencyFactor = Math.min(0.9f, Math.max(0.0f, this.getModifier(BroomModifiers.EFFICIENCY) / BroomModifiers.EFFICIENCY.getMaxTierValue()));
        if (this.m_9236_().f_46441_.m_188501_() > efficiencyFactor) {
            ItemStack broomStack = this.getBroomStack();
            ((IBroom)broomStack.m_41720_()).consumeBroom(amount, broomStack, entityLiving);
            this.setBroomStack(broomStack);
        }
    }

    protected void updateMountedServer() {
        if (!this.setLast) {
            this.setLast = true;
            this.lastRotationYaw = this.m_146908_();
            this.lastRotationPitch = this.m_146909_();
        }
        if (this.lastMounted instanceof Player) {
            if (this.lastMounted instanceof ServerPlayer) {
                ((ServerPlayer)this.lastMounted).f_8906_.f_9739_ = 0;
            }
        } else {
            this.lastMounted.m_146922_(this.lastMounted.f_20885_);
            this.lastMounted.f_20902_ = 0.5f;
        }
        this.m_146926_(MathHelpers.normalizeAngle_180(this.lastMounted.m_146909_()));
        this.m_146922_(MathHelpers.normalizeAngle_180(this.lastMounted.m_146908_()));
        float maneuverabilityFactor = 1.0f - this.getModifier(BroomModifiers.MANEUVERABILITY) / 2000.0f;
        this.m_146926_(this.m_146909_() * (1.0f - maneuverabilityFactor) + this.lastRotationPitch * maneuverabilityFactor);
        if (this.lastRotationYaw - this.m_146908_() > 180.0f) {
            this.lastRotationYaw -= 360.0f;
        }
        if (this.lastRotationYaw - this.m_146908_() < -180.0f) {
            this.lastRotationYaw += 360.0f;
        }
        this.m_146922_(this.m_146908_() * (1.0f - maneuverabilityFactor) + this.lastRotationYaw * maneuverabilityFactor);
        this.lastRotationPitch = this.m_146909_();
        this.lastRotationYaw = this.m_146908_();
        if (this.m_146909_() > 60.0f) {
            this.m_146926_(60.0f);
        } else if (this.m_146909_() < -60.0f) {
            this.m_146926_(-60.0f);
        }
        this.m_19915_(this.m_146908_(), this.m_146909_());
        double pitch = (double)(this.m_146909_() + 90.0f) * Math.PI / 180.0;
        double yaw = (double)(this.m_146908_() + 90.0f) * Math.PI / 180.0;
        double x = Math.sin(pitch) * Math.cos(yaw);
        double z = Math.sin(pitch) * Math.sin(yaw);
        double y = Math.cos(pitch);
        double playerSpeed = this.lastMounted.m_21051_(Attributes.f_22279_).m_22135_();
        playerSpeed += (double)(this.getModifier(BroomModifiers.SPEED) / 100.0f);
        int amount = ItemBroomConfig.bloodUsage;
        LivingEntity currentRidingEntity = this.m_6688_() instanceof LivingEntity ? this.m_6688_() : null;
        float moveForward = this.canConsume(amount, currentRidingEntity) ? this.lastMounted.f_20902_ : this.lastMounted.f_20902_ / 10.0f;
        playerSpeed *= (double)moveForward;
        if (moveForward != 0.0f) {
            this.consume(amount, currentRidingEntity);
        }
        float slowingFactor = 1.0f - (this.getModifier(BroomModifiers.ACCELERATION) + 1.0f) / 2500.0f;
        playerSpeed = playerSpeed * (1.0 - (double)slowingFactor) + this.lastPlayerSpeed * (double)slowingFactor;
        float levitation = this.getModifier(BroomModifiers.LEVITATION);
        float levitationModifier = levitation / BroomModifiers.LEVITATION.getMaxTierValue() * 1.5f;
        levitationModifier = Math.max(0.2f, levitationModifier);
        if (y < 0.0) {
            levitationModifier = Math.max(1.0f, levitationModifier);
        }
        this.lastPlayerSpeed = playerSpeed;
        if (this.f_19798_) {
            float waterMovementFactor = Mth.m_14036_((float)(this.getModifier(BroomModifiers.SWIMMING) / BroomModifiers.SWIMMING.getMaxTierValue()), (float)0.0f, (float)1.0f);
            waterMovementFactor = (float)Math.log10(1.0f + waterMovementFactor * 9.0f);
            playerSpeed *= (double)waterMovementFactor;
        }
        this.m_20256_(this.m_20184_().m_82542_(0.1, 0.1, 0.1).m_82520_(x * 0.4 * playerSpeed, y * 0.4 * playerSpeed * (double)levitationModifier, z * 0.4 * playerSpeed));
        if (this.m_9236_().m_5776_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, this.getHoverOffset(), 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
    }

    public double getLastPlayerSpeed() {
        return this.lastPlayerSpeed;
    }

    public void setLastPlayerSpeed(double lastPlayerSpeed) {
        this.lastPlayerSpeed = lastPlayerSpeed;
    }

    protected void updateUnmounted() {
        if (this.m_9236_().m_5776_()) {
            this.m_6478_(MoverType.SELF, new Vec3(0.0, this.getHoverOffset(), 0.0));
        }
    }

    protected double getHoverOffset() {
        float x = this.m_9236_().m_46467_();
        float t = this.broomHoverTickOffset;
        double newHoverOffset = Math.cos(x / 10.0f + t) * Math.cos(x / 12.0f + t) * Math.cos(x / 15.0f + t) * (double)0.2f;
        double newHoverDifference = newHoverOffset - this.oldHoverOffset;
        this.oldHoverOffset += newHoverDifference;
        return newHoverDifference;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    public boolean canBeRiddenUnderFluidType(FluidType type, Entity rider) {
        return this.getModifier(BroomModifiers.SWIMMING) > 0.0f;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(ITEMSTACK_INDEX, (Object)new ItemStack((ItemLike)RegistryEntries.ITEM_BROOM));
    }

    protected void m_7378_(CompoundTag nbttagcompound) {
    }

    protected void m_7380_(CompoundTag nbttagcompound) {
    }

    public void setBroomStack(ItemStack itemStack) {
        this.f_19804_.m_135381_(ITEMSTACK_INDEX, (Object)itemStack.m_41777_());
    }

    public ItemStack getBroomStack() {
        ItemStack itemStack = (ItemStack)this.f_19804_.m_135370_(ITEMSTACK_INDEX);
        if (itemStack.m_41619_()) {
            itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_BROOM);
        }
        itemStack.m_41764_(1);
        return itemStack;
    }

    public Map<BroomModifier, Float> getModifiers() {
        if (this.cachedModifiers == null) {
            this.cachedModifiers = Maps.newHashMap();
            ItemStack broomStack = this.getBroomStack();
            Map<BroomModifier, Float> modifiers = BroomModifiers.REGISTRY.getModifiers(broomStack);
            Map<BroomModifier, Float> baseModifiers = BroomParts.REGISTRY.getBaseModifiersFromBroom(broomStack);
            HashSet modifierTypes = Sets.newHashSet();
            modifierTypes.addAll(modifiers.keySet());
            modifierTypes.addAll(baseModifiers.keySet());
            for (BroomModifier modifier : modifierTypes) {
                float value = modifier.getDefaultValue();
                if (baseModifiers.containsKey(modifier)) {
                    value = baseModifiers.get(modifier).floatValue();
                }
                if (modifiers.containsKey(modifier)) {
                    value = modifier.apply(value, Lists.newArrayList((Object[])new Float[]{modifiers.get(modifier)}));
                }
                this.cachedModifiers.put(modifier, Float.valueOf(value));
            }
        }
        return this.cachedModifiers;
    }

    public float getModifier(BroomModifier modifier) {
        Float value = this.getModifiers().get(modifier);
        if (value == null) {
            return modifier.getDefaultValue();
        }
        return value.floatValue();
    }

    public CompoundTag m_20240_(CompoundTag tag) {
        tag = super.m_20240_(tag);
        CompoundTag broomItemTag = new CompoundTag();
        this.getBroomStack().m_41739_(broomItemTag);
        tag.m_128365_("broomItem", (Tag)broomItemTag);
        return tag;
    }

    public void m_20258_(CompoundTag tagCompound) {
        super.m_20258_(tagCompound);
        ItemStack broomStack = ItemStack.m_41712_((CompoundTag)tagCompound.m_128469_("broomItem"));
        if (!broomStack.m_41619_()) {
            this.setBroomStack(broomStack);
        }
    }
}

