/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.inventory.container;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.inventory.container.InventoryContainer;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTickingTankInventory;

public class ContainerInventoryTickingTank<T extends BlockEntityTickingTankInventory<T>>
extends InventoryContainer {
    private final Optional<T> tileSupplier;
    private final List<Supplier<Integer>> variablesMaxProgress = Lists.newArrayList();
    private final List<Supplier<Integer>> variablesProgress = Lists.newArrayList();
    private final Supplier<FluidStack> variableFluidStack;
    private final Supplier<Integer> variableFluidCapacity;

    public ContainerInventoryTickingTank(@Nullable MenuType<?> type, int id, Inventory playerInventory, Container inventory, Optional<T> tileSupplier, int tickers) {
        super(type, id, playerInventory, inventory);
        int ticker = 0;
        while (ticker < tickers) {
            int finalTicker = ticker++;
            this.variablesMaxProgress.add(this.registerSyncedVariable(Integer.class, () -> (int)((BlockEntityTickingTankInventory)((Object)((Object)tileSupplier.get()))).getTickers().get(finalTicker).getRequiredTicks()));
            this.variablesProgress.add(this.registerSyncedVariable(Integer.class, () -> ((BlockEntityTickingTankInventory)((Object)((Object)tileSupplier.get()))).getTickers().get(finalTicker).getTick()));
        }
        this.variableFluidStack = this.registerSyncedVariable(FluidStack.class, () -> ((BlockEntityTickingTankInventory)((Object)((Object)this.getTileSupplier().get()))).getTank().getFluid());
        this.variableFluidCapacity = this.registerSyncedVariable(Integer.class, () -> ((BlockEntityTickingTankInventory)((Object)((Object)this.getTileSupplier().get()))).getTank().getCapacity());
        this.tileSupplier = tileSupplier;
    }

    public Optional<T> getTileSupplier() {
        return this.tileSupplier;
    }

    public int getMaxProgress(int ticker) {
        return this.variablesMaxProgress.get(ticker).get();
    }

    public int getProgress(int ticker) {
        return this.variablesProgress.get(ticker).get();
    }

    public FluidStack getFluidStack() {
        FluidStack fluidStack = this.variableFluidStack.get();
        return fluidStack == null ? FluidStack.EMPTY : fluidStack;
    }

    public int getFluidCapacity() {
        return this.variableFluidCapacity.get();
    }
}

