/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.core.fluid;

import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.cyclopscore.capability.fluid.FluidHandlerItemCapacity;
import org.cyclops.evilcraft.core.fluid.SimulatedFluidStack;

public class FluidContainerItemWrapperWithSimulation
extends FluidHandlerItemCapacity {
    public FluidContainerItemWrapperWithSimulation(ItemStack container, int capacity) {
        super(container, capacity);
    }

    public FluidContainerItemWrapperWithSimulation(ItemStack container, int capacity, Fluid fluid) {
        super(container, capacity, fluid);
    }

    protected IFluidHandler.FluidAction shouldDoFill(FluidStack resource, IFluidHandler.FluidAction doFill) {
        if (doFill.simulate()) {
            return IFluidHandler.FluidAction.SIMULATE;
        }
        if (resource instanceof SimulatedFluidStack) {
            doFill = IFluidHandler.FluidAction.SIMULATE;
        }
        return doFill;
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
        doFill = this.shouldDoFill(resource, doFill);
        return super.fill(resource, doFill);
    }

    protected FluidStack wrapSimulatedDrained(FluidStack drained, IFluidHandler.FluidAction doDrain) {
        if (doDrain.execute() || drained.isEmpty() || drained.getAmount() == 0) {
            return drained;
        }
        return new SimulatedFluidStack(drained.getFluid(), drained.getAmount());
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
        FluidStack drained = super.drain(maxDrain, doDrain);
        return this.wrapSimulatedDrained(drained, doDrain);
    }

    protected IFluidHandler.FluidAction shouldDoDrain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
        if (doDrain.simulate()) {
            return IFluidHandler.FluidAction.SIMULATE;
        }
        return doDrain;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
        doDrain = this.shouldDoDrain(resource, doDrain);
        return this.wrapSimulatedDrained(super.drain(resource, doDrain), doDrain);
    }
}

