/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.evilcraft.blockentity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.ChestLidController;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.cyclops.cyclopscore.block.multi.AllowedBlock;
import org.cyclops.cyclopscore.block.multi.CubeDetector;
import org.cyclops.cyclopscore.block.multi.ExactBlockCountValidator;
import org.cyclops.cyclopscore.block.multi.ExactSizeValidator;
import org.cyclops.cyclopscore.block.multi.HollowCubeDetector;
import org.cyclops.cyclopscore.block.multi.IBlockCountValidator;
import org.cyclops.cyclopscore.block.multi.ISizeValidator;
import org.cyclops.cyclopscore.capability.item.ItemHandlerSlotMasked;
import org.cyclops.cyclopscore.fluid.SingleUseTank;
import org.cyclops.cyclopscore.helper.BlockEntityHelpers;
import org.cyclops.cyclopscore.helper.DirectionHelpers;
import org.cyclops.cyclopscore.helper.LocationHelpers;
import org.cyclops.cyclopscore.inventory.SimpleInventory;
import org.cyclops.cyclopscore.inventory.slot.SlotFluidContainer;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.evilcraft.RegistryEntries;
import org.cyclops.evilcraft.block.BlockColossalBloodChestConfig;
import org.cyclops.evilcraft.blockentity.tickaction.EmptyFluidContainerInTankTickAction;
import org.cyclops.evilcraft.blockentity.tickaction.bloodchest.BulkRepairItemTickAction;
import org.cyclops.evilcraft.core.blockentity.BlockEntityTickingTankInventory;
import org.cyclops.evilcraft.core.blockentity.BlockEntityWorking;
import org.cyclops.evilcraft.core.blockentity.tickaction.ITickAction;
import org.cyclops.evilcraft.core.blockentity.tickaction.TickComponent;
import org.cyclops.evilcraft.core.blockentity.upgrade.IUpgradeSensitiveEvent;
import org.cyclops.evilcraft.core.blockentity.upgrade.UpgradeBehaviour;
import org.cyclops.evilcraft.core.blockentity.upgrade.Upgrades;
import org.cyclops.evilcraft.core.fluid.BloodFluidConverter;
import org.cyclops.evilcraft.core.fluid.ImplicitFluidConversionTank;
import org.cyclops.evilcraft.inventory.container.ContainerColossalBloodChest;
import org.cyclops.evilcraft.inventory.slot.SlotRepairable;

public class BlockEntityColossalBloodChest
extends BlockEntityWorking<BlockEntityColossalBloodChest, MutableFloat>
implements MenuProvider,
LidBlockEntity {
    private static final int TICK_MODULUS = 200;
    public static final int SLOTS_CHEST = 45;
    public static final int SLOTS = 46;
    public static final int SLOT_CONTAINER = 45;
    public static final int LIQUID_PER_SLOT = 10000;
    public static final int MAX_EFFICIENCY = 200;
    public static Metadata METADATA = new Metadata();
    @NBTPersist(useDefaultValue=false)
    private Vec3i size = LocationHelpers.copyLocation((Vec3i)Vec3i.f_123288_);
    @NBTPersist(useDefaultValue=false)
    private Vec3i renderOffset = new Vec3i(0, 0, 0);
    @NBTPersist
    private Integer efficiency = 0;
    @NBTPersist
    private int rotation = 0;
    private int repairTicker;
    private final Map<Integer, Boolean> slotTickHistory;
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState blockState) {
            BlockEntityColossalBloodChest.playSound(level, pos, blockState, SoundEvents.f_11749_);
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState blockState) {
            BlockEntityColossalBloodChest.playSound(level, pos, blockState, SoundEvents.f_11747_);
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState blockState, int p_155364_, int p_155365_) {
            BlockEntityColossalBloodChest.this.signalOpenCount(level, pos, blockState, p_155364_, p_155365_);
        }

        protected boolean m_142718_(Player player) {
            if (!(player.f_36096_ instanceof ContainerColossalBloodChest)) {
                return false;
            }
            Container container = ((ContainerColossalBloodChest)player.f_36096_).getContainerInventory();
            return container == BlockEntityColossalBloodChest.this.getInventory();
        }
    };
    private final ChestLidController chestLidController = new ChestLidController();
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_SPEED = Upgrades.newUpgradeEventType();
    public static final Upgrades.UpgradeEventType UPGRADEEVENT_BLOODUSAGE = Upgrades.newUpgradeEventType();
    private static final Map<Class<?>, ITickAction<BlockEntityColossalBloodChest>> REPAIR_TICK_ACTIONS = new LinkedHashMap();
    private static final Map<Class<?>, ITickAction<BlockEntityColossalBloodChest>> EMPTY_IN_TANK_TICK_ACTIONS;
    public static int TICKERS;
    protected static final ExactSizeValidator exactSizeValidator;
    private static CubeDetector detector;

    public BlockEntityColossalBloodChest(BlockPos blockPos, BlockState blockState) {
        super(RegistryEntries.BLOCK_ENTITY_COLOSSAL_BLOOD_CHEST, blockPos, blockState, 46, 64, 10000, (Fluid)RegistryEntries.FLUID_BLOOD);
        for (int i = 0; i < 45; ++i) {
            this.addTicker(new TickComponent<BlockEntityColossalBloodChest, ITickAction<BlockEntityColossalBloodChest>>(this, REPAIR_TICK_ACTIONS, i));
        }
        this.addTicker(new TickComponent<BlockEntityColossalBloodChest, ITickAction<BlockEntityColossalBloodChest>>(this, EMPTY_IN_TANK_TICK_ACTIONS, 45, false, true));
        assert (this.getTickers().size() == TICKERS);
        this.upgradeBehaviour.put(Upgrades.UPGRADE_EFFICIENCY, new UpgradeBehaviour<BlockEntityColossalBloodChest, MutableFloat>(2.0){

            @Override
            public void applyUpgrade(BlockEntityColossalBloodChest upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableFloat> event) {
                if (event.getType() == UPGRADEEVENT_BLOODUSAGE) {
                    float val = event.getObject().getValue().floatValue();
                    val = (float)((double)val / (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                }
            }
        });
        this.upgradeBehaviour.put(Upgrades.UPGRADE_SPEED, new UpgradeBehaviour<BlockEntityColossalBloodChest, MutableFloat>(1.0){

            @Override
            public void applyUpgrade(BlockEntityColossalBloodChest upgradable, Upgrades.Upgrade upgrade, int upgradeLevel, IUpgradeSensitiveEvent<MutableFloat> event) {
                if (event.getType() == UPGRADEEVENT_SPEED) {
                    float val = event.getObject().getValue().floatValue();
                    val = (float)((double)val / (1.0 + (double)upgradeLevel / this.valueFactor));
                    event.getObject().setValue(val);
                }
            }
        });
        this.slotTickHistory = Maps.newHashMap();
        this.resetSlotHistory();
    }

    public static CubeDetector getCubeDetector() {
        if (detector == null) {
            detector = new HollowCubeDetector(new AllowedBlock[]{new AllowedBlock((Block)RegistryEntries.BLOCK_REINFORCED_UNDEAD_PLANKS), new AllowedBlock((Block)RegistryEntries.BLOCK_COLOSSAL_BLOOD_CHEST).addCountValidator((IBlockCountValidator)new ExactBlockCountValidator(1))}, (List)Lists.newArrayList((Object[])new Block[]{RegistryEntries.BLOCK_COLOSSAL_BLOOD_CHEST, RegistryEntries.BLOCK_REINFORCED_UNDEAD_PLANKS})).addSizeValidator((ISizeValidator)exactSizeValidator);
        }
        return detector;
    }

    @Override
    protected void addItemHandlerCapabilities() {
        LazyOptional itemHandlerChest = LazyOptional.of(() -> new ItemHandlerSlotMasked((Container)this.getInventory(), IntStream.range(0, 45).toArray()));
        LazyOptional itemHandlerContainer = LazyOptional.of(() -> new ItemHandlerSlotMasked((Container)this.getInventory(), new int[]{45}));
        this.addCapabilitySided(ForgeCapabilities.ITEM_HANDLER, Direction.UP, itemHandlerChest);
        this.addCapabilitySided(ForgeCapabilities.ITEM_HANDLER, Direction.DOWN, itemHandlerChest);
        this.addCapabilitySided(ForgeCapabilities.ITEM_HANDLER, Direction.NORTH, itemHandlerContainer);
        this.addCapabilitySided(ForgeCapabilities.ITEM_HANDLER, Direction.SOUTH, itemHandlerContainer);
        this.addCapabilitySided(ForgeCapabilities.ITEM_HANDLER, Direction.WEST, itemHandlerContainer);
        this.addCapabilitySided(ForgeCapabilities.ITEM_HANDLER, Direction.EAST, itemHandlerContainer);
    }

    protected void resetSlotHistory() {
        for (int i = 0; i < this.getBasicInventorySize(); ++i) {
            this.slotTickHistory.put(i, false);
        }
    }

    @Override
    protected SingleUseTank createTank(int tankSize) {
        return new ImplicitFluidConversionTank(tankSize, BloodFluidConverter.getInstance());
    }

    public boolean isStructureComplete() {
        return !this.getSize().equals((Object)Vec3i.f_123288_);
    }

    public int getSizeSingular() {
        return this.getSize().m_123341_() + 1;
    }

    public Vec3i getSize() {
        return this.size;
    }

    public void setSize(Vec3i size) {
        this.size = size;
        this.sendUpdate();
    }

    @Override
    public Metadata getTileWorkingMetadata() {
        return METADATA;
    }

    @Override
    public boolean canWork() {
        Vec3i size = this.getSize();
        return size.compareTo(exactSizeValidator.getExactSize()) == 0;
    }

    public static boolean canWork(Level world, BlockPos location) {
        return BlockEntityHelpers.get((BlockGetter)world, (BlockPos)location, BlockEntityColossalBloodChest.class).map(BlockEntityColossalBloodChest::canWork).orElse(false);
    }

    @Override
    protected int getWorkTicker() {
        return this.repairTicker;
    }

    @Override
    public int getNewState() {
        return 0;
    }

    @Override
    public void onStateChanged() {
    }

    @Override
    protected SimpleInventory createInventory(int inventorySize, int stackSize) {
        return new BlockEntityWorking.Inventory<BlockEntityColossalBloodChest>(inventorySize, stackSize, this){

            public void m_5856_(Player entityPlayer) {
                super.m_5856_(entityPlayer);
                BlockEntityColossalBloodChest.this.startOpen(entityPlayer);
            }

            public void m_5785_(Player entityPlayer) {
                super.m_5785_(entityPlayer);
                BlockEntityColossalBloodChest.this.stopOpen(entityPlayer);
            }

            public boolean m_6542_(Player entityPlayer) {
                return super.m_6542_(entityPlayer) && BlockEntityColossalBloodChest.this.f_58857_ != null && BlockEntityColossalBloodChest.this.f_58857_.m_7702_(BlockEntityColossalBloodChest.this.m_58899_()) == this.tile;
            }

            @Override
            public boolean m_7013_(int slot, ItemStack itemStack) {
                if (slot == 45) {
                    return SlotFluidContainer.checkIsItemValid((ItemStack)itemStack, (Fluid)RegistryEntries.FLUID_BLOOD);
                }
                if (slot <= 45 && slot >= 0) {
                    return SlotRepairable.checkIsItemValid(itemStack);
                }
                return super.m_7013_(slot, itemStack);
            }
        };
    }

    static void playSound(Level level, BlockPos pos, BlockState blockState, SoundEvent soundEvent) {
        level.m_6263_((Player)null, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, soundEvent, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public boolean m_7531_(int eventType, int value) {
        if (eventType == 1) {
            this.chestLidController.m_155377_(value > 0);
            return true;
        }
        return super.m_7531_(eventType, value);
    }

    public void startOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void stopOpen(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (!this.f_58859_) {
            this.openersCounter.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    protected void signalOpenCount(Level level, BlockPos pos, BlockState blockState, int p_155336_, int value) {
        Block block = blockState.m_60734_();
        level.m_7696_(pos, block, 1, value);
    }

    public static void lidAnimateTick(Level level, BlockPos pos, BlockState blockState, BlockEntityColossalBloodChest blockEntity) {
        blockEntity.chestLidController.m_155374_();
    }

    public float m_6683_(float value) {
        return this.chestLidController.m_155375_(value);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_().m_121996_(new Vec3i(3, 3, 3)), this.m_58899_().m_7918_(3, 6, 3));
    }

    public void setCenter(BlockPos center) {
        Direction rotation = Direction.NORTH;
        if (center.m_123341_() != this.m_58899_().m_123341_()) {
            rotation = DirectionHelpers.getEnumFacingFromXSign((int)(center.m_123341_() - this.m_58899_().m_123341_()));
        } else if (center.m_123343_() != this.m_58899_().m_123343_()) {
            rotation = DirectionHelpers.getEnumFacingFromZSing((int)(center.m_123343_() - this.m_58899_().m_123343_()));
        }
        this.setRotation(rotation);
        this.renderOffset = this.m_58899_().m_121996_((Vec3i)center);
    }

    public void setRotation(Direction rotation) {
        this.rotation = rotation.ordinal();
    }

    public Direction getRotation() {
        return Direction.m_122376_((int)this.rotation);
    }

    public Vec3i getRenderOffset() {
        return this.renderOffset;
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerColossalBloodChest(id, playerInventory, (Container)this.getInventory(), Optional.of(this));
    }

    public static void detectStructure(Level world, BlockPos location, Vec3i size, boolean valid, BlockPos originCorner) {
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.evilcraft.colossal_blood_chest");
    }

    public Integer getEfficiency() {
        return this.efficiency;
    }

    public void setEfficiency(Integer efficiency) {
        this.efficiency = efficiency;
    }

    public Map<Integer, Boolean> getSlotTickHistory() {
        return this.slotTickHistory;
    }

    static {
        REPAIR_TICK_ACTIONS.put(Item.class, new BulkRepairItemTickAction());
        EMPTY_IN_TANK_TICK_ACTIONS = new LinkedHashMap();
        EMPTY_IN_TANK_TICK_ACTIONS.put(Item.class, new EmptyFluidContainerInTankTickAction());
        TICKERS = 46;
        exactSizeValidator = new ExactSizeValidator(new Vec3i(2, 2, 2));
    }

    private static class Metadata
    extends BlockEntityWorking.Metadata {
        private Metadata() {
            super(46);
        }

        @Override
        public boolean canConsume(ItemStack itemStack, Level world) {
            return SlotRepairable.checkIsItemValid(itemStack);
        }

        @Override
        protected Block getBlock() {
            return RegistryEntries.BLOCK_COLOSSAL_BLOOD_CHEST;
        }
    }

    public static class TickerClient
    extends BlockEntityTickingTankInventory.TickerClient<BlockEntityColossalBloodChest> {
        @Override
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityColossalBloodChest blockEntity) {
            super.update(level, pos, blockState, blockEntity);
            BlockEntityColossalBloodChest.lidAnimateTick(level, pos, blockState, blockEntity);
        }
    }

    public static class TickerServer
    extends BlockEntityWorking.TickerServer<BlockEntityColossalBloodChest, MutableFloat> {
        @Override
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityColossalBloodChest blockEntity) {
            blockEntity.resetSlotHistory();
            super.update(level, pos, blockState, blockEntity);
            if (level != null && level.m_46467_() % (long)BlockColossalBloodChestConfig.ticksPerDamage == 0L) {
                int oldEfficiency = blockEntity.efficiency;
                blockEntity.efficiency = Math.max(0, blockEntity.efficiency - BlockColossalBloodChestConfig.baseConcurrentItems);
                if (oldEfficiency != blockEntity.efficiency) {
                    blockEntity.m_6596_();
                }
            }
        }
    }
}

