/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.registry;

import com.smashingmods.alchemistry.common.recipe.atomizer.AtomizerRecipe;
import com.smashingmods.alchemistry.common.recipe.atomizer.AtomizerRecipeSerializer;
import com.smashingmods.alchemistry.common.recipe.combiner.CombinerRecipe;
import com.smashingmods.alchemistry.common.recipe.combiner.CombinerRecipeSerializer;
import com.smashingmods.alchemistry.common.recipe.compactor.CompactorRecipe;
import com.smashingmods.alchemistry.common.recipe.compactor.CompactorRecipeSerializer;
import com.smashingmods.alchemistry.common.recipe.dissolver.DissolverRecipe;
import com.smashingmods.alchemistry.common.recipe.dissolver.DissolverRecipeSerializer;
import com.smashingmods.alchemistry.common.recipe.fission.FissionRecipe;
import com.smashingmods.alchemistry.common.recipe.fission.FissionRecipeSerializer;
import com.smashingmods.alchemistry.common.recipe.fusion.FusionRecipe;
import com.smashingmods.alchemistry.common.recipe.fusion.FusionRecipeSerializer;
import com.smashingmods.alchemistry.common.recipe.liquifier.LiquifierRecipe;
import com.smashingmods.alchemistry.common.recipe.liquifier.LiquifierRecipeSerializer;
import com.smashingmods.alchemylib.api.recipe.AbstractProcessingRecipe;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class RecipeRegistry {
    private static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"alchemistry");
    private static final DeferredRegister<RecipeSerializer<?>> SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"alchemistry");
    public static RegistryObject<RecipeType<AtomizerRecipe>> ATOMIZER_TYPE = RecipeRegistry.registerRecipeType("atomizer");
    public static RegistryObject<RecipeType<CompactorRecipe>> COMPACTOR_TYPE = RecipeRegistry.registerRecipeType("compactor");
    public static RegistryObject<RecipeType<CombinerRecipe>> COMBINER_TYPE = RecipeRegistry.registerRecipeType("combiner");
    public static RegistryObject<RecipeType<DissolverRecipe>> DISSOLVER_TYPE = RecipeRegistry.registerRecipeType("dissolver");
    public static RegistryObject<RecipeType<FissionRecipe>> FISSION_TYPE = RecipeRegistry.registerRecipeType("fission");
    public static RegistryObject<RecipeType<FusionRecipe>> FUSION_TYPE = RecipeRegistry.registerRecipeType("fusion");
    public static RegistryObject<RecipeType<LiquifierRecipe>> LIQUIFIER_TYPE = RecipeRegistry.registerRecipeType("liquifier");
    public static final RegistryObject<AtomizerRecipeSerializer<AtomizerRecipe>> ATOMIZER_SERIALIZER = SERIALIZERS.register("atomizer", () -> new AtomizerRecipeSerializer<AtomizerRecipe>(AtomizerRecipe::new));
    public static final RegistryObject<CompactorRecipeSerializer<CompactorRecipe>> COMPACTOR_SERIALIZER = SERIALIZERS.register("compactor", () -> new CompactorRecipeSerializer<CompactorRecipe>(CompactorRecipe::new));
    public static final RegistryObject<CombinerRecipeSerializer<CombinerRecipe>> COMBINER_SERIALIZER = SERIALIZERS.register("combiner", () -> new CombinerRecipeSerializer<CombinerRecipe>(CombinerRecipe::new));
    public static final RegistryObject<DissolverRecipeSerializer<DissolverRecipe>> DISSOLVER_SERIALIZER = SERIALIZERS.register("dissolver", () -> new DissolverRecipeSerializer<DissolverRecipe>(DissolverRecipe::new));
    public static final RegistryObject<FissionRecipeSerializer<FissionRecipe>> FISSION_SERIALIZER = SERIALIZERS.register("fission", () -> new FissionRecipeSerializer<FissionRecipe>(FissionRecipe::new));
    public static final RegistryObject<FusionRecipeSerializer<FusionRecipe>> FUSION_SERIALIZER = SERIALIZERS.register("fusion", () -> new FusionRecipeSerializer<FusionRecipe>(FusionRecipe::new));
    public static final RegistryObject<LiquifierRecipeSerializer<LiquifierRecipe>> LIQUIFIER_SERIALIZER = SERIALIZERS.register("liquifier", () -> new LiquifierRecipeSerializer<LiquifierRecipe>(LiquifierRecipe::new));
    private static final Map<RecipeType<? extends AbstractProcessingRecipe>, LinkedList<? extends AbstractProcessingRecipe>> recipeTypeMap = new LinkedHashMap<RecipeType<? extends AbstractProcessingRecipe>, LinkedList<? extends AbstractProcessingRecipe>>();
    private static final Map<String, LinkedList<? extends AbstractProcessingRecipe>> recipeGroupMap = new LinkedHashMap<String, LinkedList<? extends AbstractProcessingRecipe>>();

    private static <T extends AbstractProcessingRecipe> RegistryObject<RecipeType<T>> registerRecipeType(final String pType) {
        RecipeType type = new RecipeType<T>(){

            public String toString() {
                return pType;
            }
        };
        return RECIPE_TYPES.register(pType, () -> RecipeRegistry.lambda$registerRecipeType$7((RecipeType)type));
    }

    public static void postReload(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new SimplePreparableReloadListener<Boolean>(){

            public String m_7812_() {
                return "Alchemistry Cache Invalidator";
            }

            protected Boolean prepare(ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                return true;
            }

            protected void apply(Boolean pShouldClear, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
                if (pShouldClear.booleanValue()) {
                    recipeTypeMap.clear();
                    recipeGroupMap.clear();
                }
            }
        });
    }

    public static <R extends AbstractProcessingRecipe> LinkedList<R> getRecipesByType(RecipeType<R> pRecipeType, Level pLevel) {
        if (recipeTypeMap.get(pRecipeType) == null) {
            LinkedList recipes = pLevel.m_7465_().m_44051_().stream().filter(recipe -> recipe.m_6671_().equals(pRecipeType)).map(recipe -> (AbstractProcessingRecipe)recipe).sorted().collect(Collectors.toCollection(LinkedList::new));
            recipeTypeMap.put(pRecipeType, recipes);
        }
        return recipeTypeMap.get(pRecipeType);
    }

    public static <R extends AbstractProcessingRecipe> LinkedList<R> getRecipesByGroup(String pGroup, Level pLevel) {
        if (recipeGroupMap.get(pGroup) == null) {
            LinkedList recipes = pLevel.m_7465_().m_44051_().stream().filter(recipe -> recipe.m_6076_().equals(pGroup)).map(recipe -> (AbstractProcessingRecipe)recipe).sorted().collect(Collectors.toCollection(LinkedList::new));
            recipeGroupMap.put(pGroup, recipes);
        }
        return recipeGroupMap.get(pGroup);
    }

    public static <R extends AbstractProcessingRecipe> Optional<R> getRecipeByGroupAndId(String pGroup, ResourceLocation pRecipeId, Level pLevel) {
        return RecipeRegistry.getRecipesByGroup(pGroup, pLevel).stream().filter(recipe -> recipe.m_6423_().equals((Object)pRecipeId)).findFirst().map(recipe -> recipe);
    }

    public static LinkedList<AtomizerRecipe> getAtomizerRecipes(Level pLevel) {
        return RecipeRegistry.getRecipesByType((RecipeType)ATOMIZER_TYPE.get(), pLevel);
    }

    public static LinkedList<CombinerRecipe> getCombinerRecipes(Level pLevel) {
        return RecipeRegistry.getRecipesByType((RecipeType)COMBINER_TYPE.get(), pLevel);
    }

    public static LinkedList<CompactorRecipe> getCompactorRecipes(Level pLevel) {
        return RecipeRegistry.getRecipesByType((RecipeType)COMPACTOR_TYPE.get(), pLevel);
    }

    public static LinkedList<DissolverRecipe> getDissolverRecipes(Level pLevel) {
        return RecipeRegistry.getRecipesByType((RecipeType)DISSOLVER_TYPE.get(), pLevel);
    }

    public static LinkedList<FissionRecipe> getFissionRecipes(Level pLevel) {
        return RecipeRegistry.getRecipesByType((RecipeType)FISSION_TYPE.get(), pLevel);
    }

    public static LinkedList<FusionRecipe> getFusionRecipes(Level pLevel) {
        return RecipeRegistry.getRecipesByType((RecipeType)FUSION_TYPE.get(), pLevel);
    }

    public static LinkedList<LiquifierRecipe> getLiquifierRecipes(Level pLevel) {
        return RecipeRegistry.getRecipesByType((RecipeType)LIQUIFIER_TYPE.get(), pLevel);
    }

    public static Optional<AtomizerRecipe> getAtomizerRecipe(Predicate<AtomizerRecipe> pPredicate, Level pLevel) {
        return RecipeRegistry.getAtomizerRecipes(pLevel).stream().filter(pPredicate).findFirst();
    }

    public static Optional<CombinerRecipe> getCombinerRecipe(Predicate<CombinerRecipe> pPredicate, Level pLevel) {
        return RecipeRegistry.getCombinerRecipes(pLevel).stream().filter(pPredicate).findFirst();
    }

    public static Optional<CompactorRecipe> getCompactorRecipe(Predicate<CompactorRecipe> pPredicate, Level pLevel) {
        return RecipeRegistry.getCompactorRecipes(pLevel).stream().filter(pPredicate).findFirst();
    }

    public static Optional<DissolverRecipe> getDissolverRecipe(Predicate<DissolverRecipe> pPredicate, Level pLevel) {
        return RecipeRegistry.getDissolverRecipes(pLevel).stream().filter(pPredicate).findFirst();
    }

    public static Optional<FissionRecipe> getFissionRecipe(Predicate<FissionRecipe> pPredicate, Level pLevel) {
        return RecipeRegistry.getFissionRecipes(pLevel).stream().filter(pPredicate).findFirst();
    }

    public static Optional<FusionRecipe> getFusionRecipe(Predicate<FusionRecipe> pPredicate, Level pLevel) {
        return RecipeRegistry.getFusionRecipes(pLevel).stream().filter(pPredicate).findFirst();
    }

    public static Optional<LiquifierRecipe> getLiquifierRecipe(Predicate<LiquifierRecipe> pPredicate, Level pLevel) {
        return RecipeRegistry.getLiquifierRecipes(pLevel).stream().filter(pPredicate).findFirst();
    }

    public static void register(IEventBus eventBus) {
        RECIPE_TYPES.register(eventBus);
        SERIALIZERS.register(eventBus);
    }

    private static /* synthetic */ RecipeType lambda$registerRecipeType$7(RecipeType type) {
        return type;
    }
}

