/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.datagen;

import com.smashingmods.alchemistry.registry.BlockRegistry;
import com.smashingmods.alchemistry.registry.MenuRegistry;
import com.smashingmods.alchemylib.api.storage.SideMode;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.text.WordUtils;

public class LocalizationGenerator
extends LanguageProvider {
    public LocalizationGenerator(PackOutput pOutput) {
        super(pOutput, "alchemistry", "en_us");
    }

    protected void addTranslations() {
        BlockRegistry.BLOCKS.getEntries().stream().map(RegistryObject::get).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.BLOCKS).getKey(arg_0)).filter(Objects::nonNull).map(ResourceLocation::m_135815_).forEach(path -> this.add(String.format("block.alchemistry.%s", path), WordUtils.capitalize((String)path.replace("_", " "))));
        MenuRegistry.MENU_TYPES.getEntries().stream().map(RegistryObject::get).map(arg_0 -> ((IForgeRegistry)ForgeRegistries.MENU_TYPES).getKey(arg_0)).filter(Objects::nonNull).map(ResourceLocation::m_135815_).forEach(path -> {
            path = path.replace("_menu", "");
            String translation = WordUtils.capitalize((String)path.replace("_", " "));
            this.add(String.format("alchemistry.container.%s", path), translation);
            this.add(String.format("alchemistry.jei.%s", path), translation);
        });
        this.add("itemGroup.alchemistry", "Alchemistry");
        this.add("tooltip.alchemistry.energy_requirement", "Requires %d FE/t");
        this.add("tooltip.alchemistry.requires", "Requires");
        for (Direction direction : Direction.values()) {
            String key = "alchemistry.container.sides." + direction.m_7912_();
            String value = direction == Direction.UP ? "Top" : (direction == Direction.DOWN ? "Bottom" : WordUtils.capitalize((String)direction.m_122433_()));
            this.add(key, value);
        }
        this.add("alchemistry.container.sides.external", "External access");
        for (Direction direction : SideMode.values()) {
            this.add("alchemistry.container.sides.mode." + direction.name().toLowerCase(Locale.ROOT), WordUtils.capitalize((String)direction.name().toLowerCase(Locale.ROOT)));
        }
        this.add("alchemistry.container.sides.current", "Currently: ");
        this.add("alchemistry.container.sides.title", "Configure Input/Output Sides");
        this.add("alchemistry.container.sides.button", "Input/Output Configuration");
        this.add("alchemistry.container.search", "Search...");
        this.add("alchemistry.container.select_recipe", "Select recipe:");
        this.add("alchemistry.container.current_recipe", "Current recipe:");
        this.add("alchemistry.container.required_input", "Required input item:");
        this.add("alchemistry.container.target", "Target");
        this.add("alchemistry.container.reset_target", "Reset Target");
        this.add("alchemistry.container.nothing", "Nothing");
        this.add("alchemistry.container.enable_autobalance", "Enable Auto-Balance");
        this.add("alchemistry.container.disable_autobalance", "Disable Auto-Balance");
        this.add("alchemistry.container.autoeject.title.enabled", "Auto-eject enabled");
        this.add("alchemistry.container.autoeject.title.disabled", "Auto-eject disabled");
        this.add("alchemistry.container.autoeject.tooltip.enabled", "Outputs are put in containers which are next to the output block");
        this.add("alchemistry.container.autoeject.tooltip.disabled", "Outputs are currently not inserted in nearby containers");
        this.add("alchemistry.jei.dissolver.relative", "Relative");
        this.add("alchemistry.jei.dissolver.absolute", "Absolute");
        this.add("alchemistry.jei.dissolver.type", "Type");
        this.add("alchemistry.jei.dissolver.rolls", "Rolls");
        this.add("alchemistry.jei.elements.description", "All elements (except Hydrogen) can be created with the Fusion Chamber multiblock.\\nThe multiblock accepts 2 elements as input and fuses them together to create a new element equal to the sum of their atomic numbers.\"");
        this.add("alchemistry.patchouli.book_name", "Alchemistry Labs Catalogue");
        this.add("alchemistry.patchouli.landing_text", "Looking to smash some atoms together? This catalogue will outline the machines you can manufacture in your progression through Alchemistry.");
    }
}

