/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.common.block.liquifier;

import com.smashingmods.alchemistry.Alchemistry;
import com.smashingmods.alchemistry.Config;
import com.smashingmods.alchemistry.common.block.liquifier.LiquifierMenu;
import com.smashingmods.alchemistry.common.network.SetRecipePacket;
import com.smashingmods.alchemistry.common.recipe.liquifier.LiquifierRecipe;
import com.smashingmods.alchemistry.registry.BlockEntityRegistry;
import com.smashingmods.alchemistry.registry.RecipeRegistry;
import com.smashingmods.alchemylib.api.blockentity.processing.AbstractFluidBlockEntity;
import com.smashingmods.alchemylib.api.recipe.AbstractProcessingRecipe;
import com.smashingmods.alchemylib.api.storage.EnergyStorageHandler;
import com.smashingmods.alchemylib.api.storage.FluidStorageHandler;
import com.smashingmods.alchemylib.api.storage.ProcessingSlotHandler;
import java.util.LinkedList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class LiquifierBlockEntity
extends AbstractFluidBlockEntity {
    private LiquifierRecipe currentRecipe;
    private ResourceLocation recipeId;

    public LiquifierBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super("alchemistry", (BlockEntityType)BlockEntityRegistry.LIQUIFIER_BLOCK_ENTITY.get(), pWorldPosition, pBlockState);
        this.setEnergyPerTick((Integer)Config.Common.liquifierEnergyPerTick.get());
        this.setMaxProgress((Integer)Config.Common.liquifierTicksPerOperation.get());
    }

    public void onLoad() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            RecipeRegistry.getLiquifierRecipe(recipe -> recipe.m_6423_().equals((Object)this.recipeId), this.f_58857_).ifPresent(this::setRecipe);
        }
        super.onLoad();
    }

    public void updateRecipe() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_() && !this.getInputHandler().isEmpty()) {
            RecipeRegistry.getLiquifierRecipe(recipe -> recipe.getInput().matches(this.getInputHandler().getStackInSlot(0)), this.f_58857_).ifPresent(recipe -> {
                if (this.currentRecipe == null || !this.currentRecipe.m_6423_().equals((Object)recipe.m_6423_())) {
                    this.setProgress(0);
                    this.setRecipe(recipe.copy());
                }
            });
        }
    }

    public boolean canProcessRecipe() {
        ItemStack input = this.getInputHandler().getStackInSlot(0);
        if (this.currentRecipe != null) {
            LiquifierRecipe tempRecipe = this.currentRecipe.copy();
            return this.getEnergyHandler().getEnergyStored() >= this.getEnergyPerTick() && (this.getFluidStorage().getFluidStack().isFluidEqual(tempRecipe.getOutput()) || this.getFluidStorage().isEmpty()) && this.getFluidStorage().getFluidAmount() + tempRecipe.getOutput().getAmount() < this.getFluidStorage().getCapacity() && tempRecipe.getInput().matches(input) && input.m_41613_() >= tempRecipe.getInput().getCount();
        }
        return false;
    }

    public void processRecipe() {
        if (this.getProgress() < this.getMaxProgress()) {
            this.incrementProgress();
        } else {
            LiquifierRecipe tempRecipe = this.currentRecipe.copy();
            this.setProgress(0);
            this.getInputHandler().decrementSlot(0, tempRecipe.getInput().getCount());
            this.getFluidStorage().fill(tempRecipe.getOutput(), IFluidHandler.FluidAction.EXECUTE);
        }
        this.getEnergyHandler().extractEnergy(this.getEnergyPerTick(), false);
        this.m_6596_();
    }

    public <R extends AbstractProcessingRecipe> void setRecipe(@Nullable R pRecipe) {
        if (pRecipe instanceof LiquifierRecipe) {
            LiquifierRecipe liquifierRecipe;
            this.currentRecipe = liquifierRecipe = (LiquifierRecipe)pRecipe;
        }
    }

    public LiquifierRecipe getRecipe() {
        return this.currentRecipe;
    }

    public LinkedList<LiquifierRecipe> getAllRecipes() {
        if (this.f_58857_ != null) {
            return new LinkedList<LiquifierRecipe>(RecipeRegistry.getLiquifierRecipes(this.f_58857_));
        }
        return new LinkedList<LiquifierRecipe>();
    }

    public EnergyStorageHandler initializeEnergyStorage() {
        return new EnergyStorageHandler((Integer)Config.Common.liquifierEnergyCapacity.get()){

            protected void onEnergyChanged() {
                super.onEnergyChanged();
                LiquifierBlockEntity.this.m_6596_();
            }
        };
    }

    public FluidStorageHandler initializeFluidStorage() {
        return new FluidStorageHandler((Integer)Config.Common.liquifierFluidCapacity.get(), FluidStack.EMPTY){

            protected void onContentsChanged() {
                if (LiquifierBlockEntity.this.f_58857_ != null && !LiquifierBlockEntity.this.f_58857_.m_5776_() && this.isEmpty()) {
                    LiquifierBlockEntity.this.updateRecipe();
                    LiquifierBlockEntity.this.setCanProcess(LiquifierBlockEntity.this.canProcessRecipe());
                }
            }
        };
    }

    public ProcessingSlotHandler initializeInputHandler() {
        return new ProcessingSlotHandler(1){

            protected void onContentsChanged(int slot) {
                if (!this.isEmpty()) {
                    LiquifierBlockEntity.this.updateRecipe();
                }
                LiquifierBlockEntity.this.setCanProcess(LiquifierBlockEntity.this.canProcessRecipe());
                LiquifierBlockEntity.this.m_6596_();
            }
        };
    }

    public ProcessingSlotHandler initializeOutputHandler() {
        return new ProcessingSlotHandler(0);
    }

    protected void m_183515_(CompoundTag pTag) {
        if (this.currentRecipe != null) {
            pTag.m_128359_("recipeId", this.currentRecipe.m_6423_().toString());
        }
        super.m_183515_(pTag);
    }

    public void m_142466_(CompoundTag pTag) {
        super.m_142466_(pTag);
        this.recipeId = ResourceLocation.m_135820_((String)pTag.m_128461_("recipeId"));
        if (this.f_58857_ != null && this.f_58857_.m_5776_()) {
            RecipeRegistry.getLiquifierRecipe(recipe -> recipe.m_6423_().equals((Object)this.recipeId), this.f_58857_).ifPresent(recipe -> {
                if (!((Object)recipe).equals((Object)this.currentRecipe)) {
                    this.setRecipe(recipe);
                    Alchemistry.PACKET_HANDLER.sendToServer(new SetRecipePacket(this.m_58899_(), recipe.m_6423_(), recipe.m_6076_()));
                }
            });
        }
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new LiquifierMenu(pContainerId, pInventory, (BlockEntity)this);
    }
}

