/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.dynamiclights.server;

import atomicstryker.dynamiclights.server.DynamicLightSourceContainer;
import atomicstryker.dynamiclights.server.DynamicLightsConfig;
import atomicstryker.dynamiclights.server.GsonConfig;
import atomicstryker.dynamiclights.server.IDynamicLightSource;
import atomicstryker.dynamiclights.server.ItemLightLevels;
import atomicstryker.dynamiclights.server.blocks.BlockLitAir;
import atomicstryker.dynamiclights.server.blocks.BlockLitCaveAir;
import atomicstryker.dynamiclights.server.blocks.BlockLitWater;
import atomicstryker.dynamiclights.server.modules.DroppedItemsLightSource;
import atomicstryker.dynamiclights.server.modules.PlayerSelfLightSource;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod(value="dynamiclights")
public class DynamicLights {
    public static final String MOD_ID = "dynamiclights";
    public static final ResourceLocation NOT_WATERPROOF_TAG = new ResourceLocation("dynamiclights", "not_waterproof");
    private static final Logger LOGGER = LogManager.getLogger();
    private static DynamicLights instance;
    DynamicLightsConfig config = null;
    private ConcurrentHashMap<Level, ConcurrentLinkedQueue<DynamicLightSourceContainer>> worldLightsMap;
    private PlayerSelfLightSource playerSelfLightSource;
    private DroppedItemsLightSource droppedItemsLightSource;
    public static final HashMap<Block, Block> vanillaBlocksToLitBlocksMap;
    private static final DeferredRegister<Block> BLOCKS;
    public static final RegistryObject<Block> LIT_AIR_BLOCK;
    public static final RegistryObject<Block> LIT_WATER_BLOCK;
    public static final RegistryObject<Block> LIT_CAVE_AIR_BLOCK;

    public DynamicLights() {
        instance = this;
        this.worldLightsMap = new ConcurrentHashMap();
        this.playerSelfLightSource = new PlayerSelfLightSource();
        this.droppedItemsLightSource = new DroppedItemsLightSource();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.register(DynamicLights.class);
        MinecraftForge.EVENT_BUS.register((Object)this);
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    @SubscribeEvent
    public void serverStarted(ServerStartedEvent evt) {
        if (this.config == null) {
            this.initConfig();
        }
    }

    @SubscribeEvent
    public void onAddReloadListener(AddReloadListenerEvent event) {
        LOGGER.debug("Adding reload listener for light level cache");
        event.addListener((PreparableReloadListener)new SimplePreparableReloadListener(){

            @NotNull
            protected Object m_5944_(@NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
                return null;
            }

            protected void m_5787_(@NotNull Object barrierObject, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
                ItemLightLevels.clearCache();
            }
        });
    }

    private void initConfig() {
        vanillaBlocksToLitBlocksMap.put(Blocks.f_50016_, (Block)LIT_AIR_BLOCK.get());
        vanillaBlocksToLitBlocksMap.put(Blocks.f_49990_, (Block)LIT_WATER_BLOCK.get());
        vanillaBlocksToLitBlocksMap.put(Blocks.f_50627_, (Block)LIT_CAVE_AIR_BLOCK.get());
        try {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            File configFile = new File(server.m_129971_(""), File.separatorChar + "config" + File.separatorChar + "dynamiclights.cfg");
            this.config = GsonConfig.loadConfigWithDefault(DynamicLightsConfig.class, configFile, new DynamicLightsConfig());
        }
        catch (IOException e) {
            LOGGER.error("IOException parsing config", (Throwable)e);
        }
    }

    public static void addLightSource(IDynamicLightSource lightToAdd) {
        if (lightToAdd.getAttachmentEntity() != null) {
            String dimensionLocationPath = lightToAdd.getAttachmentEntity().m_9236_().m_46472_().m_135782_().m_135815_();
            LOGGER.debug("Calling addLightSource on entity {}, dimensionLocationPath {}", (Object)lightToAdd.getAttachmentEntity(), (Object)dimensionLocationPath);
            if (lightToAdd.getAttachmentEntity().m_6084_() && !instance.isBannedDimension(dimensionLocationPath)) {
                DynamicLightSourceContainer newLightContainer = new DynamicLightSourceContainer(lightToAdd);
                ConcurrentLinkedQueue<DynamicLightSourceContainer> lightList = DynamicLights.instance.worldLightsMap.get(lightToAdd.getAttachmentEntity().m_9236_());
                if (lightList != null) {
                    if (!lightList.contains(newLightContainer)) {
                        LOGGER.debug("Successfully registered DynamicLight on Entity: {} in list {}", (Object)newLightContainer.getLightSource().getAttachmentEntity(), lightList);
                        lightList.add(newLightContainer);
                    } else {
                        LOGGER.debug("Cannot add Dynamic Light: Attachment Entity is already registered!");
                    }
                } else {
                    lightList = new ConcurrentLinkedQueue();
                    lightList.add(newLightContainer);
                    DynamicLights.instance.worldLightsMap.put(lightToAdd.getAttachmentEntity().m_9236_(), lightList);
                }
            } else {
                LOGGER.debug("Cannot add Dynamic Light: Attachment Entity {} is dead or in a banned dimension {}", (Object)lightToAdd.getAttachmentEntity(), (Object)lightToAdd.getAttachmentEntity().m_9236_().m_46472_().m_135782_().m_135815_());
            }
        } else {
            LOGGER.debug("Cannot add Dynamic Light: Attachment Entity is null!");
        }
    }

    public static void removeLightSource(IDynamicLightSource lightToRemove) {
        if (lightToRemove != null && lightToRemove.getAttachmentEntity() != null) {
            Level world = lightToRemove.getAttachmentEntity().m_9236_();
            DynamicLightSourceContainer iterContainer = null;
            ConcurrentLinkedQueue<DynamicLightSourceContainer> lightList = DynamicLights.instance.worldLightsMap.get(world);
            if (lightList != null) {
                Iterator<DynamicLightSourceContainer> iter = lightList.iterator();
                while (iter.hasNext()) {
                    iterContainer = iter.next();
                    if (!iterContainer.getLightSource().equals(lightToRemove)) continue;
                    iter.remove();
                    break;
                }
                if (iterContainer != null) {
                    LOGGER.debug("Removing Dynamic Light attached to {}", (Object)lightToRemove.getAttachmentEntity());
                    iterContainer.removeLight(world);
                }
            }
        }
    }

    @SubscribeEvent
    public void serverWorldTick(TickEvent.LevelTickEvent event) {
        if (event.side != LogicalSide.SERVER) {
            return;
        }
        ConcurrentLinkedQueue<DynamicLightSourceContainer> worldLights = this.worldLightsMap.get(event.level);
        if (worldLights != null) {
            Iterator<DynamicLightSourceContainer> iter = worldLights.iterator();
            while (iter.hasNext()) {
                DynamicLightSourceContainer tickedLightContainer = iter.next();
                if (!tickedLightContainer.onUpdate()) continue;
                iter.remove();
                tickedLightContainer.removeLight(event.level);
                LOGGER.debug("Dynamic Lights killing off LightSource on dead Entity: " + tickedLightContainer.getLightSource().getAttachmentEntity());
            }
        }
    }

    public boolean isBannedDimension(String dimensionID) {
        return this.config.getBannedDimensions().contains(dimensionID);
    }

    public static boolean isKnownLitPosition(Level world, BlockPos blockPos) {
        ConcurrentLinkedQueue<DynamicLightSourceContainer> worldLights = DynamicLights.instance.worldLightsMap.get(world);
        if (worldLights != null) {
            for (DynamicLightSourceContainer light : worldLights) {
                if (!blockPos.equals((Object)light.getLightPos())) continue;
                return true;
            }
        }
        return false;
    }

    static {
        vanillaBlocksToLitBlocksMap = new HashMap();
        BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)MOD_ID);
        LIT_AIR_BLOCK = BLOCKS.register("lit_air", () -> new BlockLitAir(BlockBehaviour.Properties.m_284310_().m_280170_().m_60910_().m_222994_().m_60996_().m_60977_().m_60953_(x -> (Integer)x.m_61143_((Property)BlockStateProperties.f_61426_)).m_222994_().m_60996_()));
        LIT_WATER_BLOCK = BLOCKS.register("lit_water", () -> new BlockLitWater(Fluids.f_76193_, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283864_).m_280170_().m_60910_().m_60978_(100.0f).m_278166_(PushReaction.DESTROY).m_222994_().m_278788_().m_60918_(SoundType.f_279557_).m_60953_(x -> (Integer)x.m_61143_((Property)BlockStateProperties.f_61426_))));
        LIT_CAVE_AIR_BLOCK = BLOCKS.register("lit_cave_air", () -> new BlockLitCaveAir(BlockBehaviour.Properties.m_284310_().m_280170_().m_60910_().m_222994_().m_60996_().m_60953_(x -> (Integer)x.m_61143_((Property)BlockStateProperties.f_61426_)).m_222994_().m_60996_()));
    }
}

