/*
 * Decompiled with CFR 0.152.
 */
package io.github.fourmisain.axesareweapons.common.mixin;

import io.github.fourmisain.axesareweapons.common.AxesAreWeaponsCommon;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.Enchantments;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EnchantmentHelper.class})
public abstract class EnchantmentHelperMixin {
    @Inject(method={"getPossibleEntries"}, at={@At(value="RETURN")})
    private static void addAxeEnchantments(int power, ItemStack stack, boolean treasureAllowed, CallbackInfoReturnable<List<EnchantmentInstance>> cir) {
        List entries = (List)cir.getReturnValue();
        if (AxesAreWeaponsCommon.CONFIG.enableLootingForRangedWeapons && AxesAreWeaponsCommon.CONFIG.enableForEnchantingTable && stack.m_41720_() instanceof ProjectileWeaponItem) {
            AxesAreWeaponsCommon.addEnchantmentEntry(entries, power, Enchantments.f_44982_);
        }
        if (AxesAreWeaponsCommon.isWeapon(stack.m_41720_())) {
            if (AxesAreWeaponsCommon.CONFIG.enableDamageInEnchantingTable) {
                for (Enchantment enchantment : Arrays.asList(Enchantments.f_44977_, Enchantments.f_44978_, Enchantments.f_44979_)) {
                    AxesAreWeaponsCommon.addEnchantmentEntry(entries, power, enchantment);
                }
            }
            if (AxesAreWeaponsCommon.CONFIG.enableForEnchantingTable) {
                if (AxesAreWeaponsCommon.CONFIG.enableLooting) {
                    AxesAreWeaponsCommon.addEnchantmentEntry(entries, power, Enchantments.f_44982_);
                }
                if (AxesAreWeaponsCommon.CONFIG.enableKnockback) {
                    AxesAreWeaponsCommon.addEnchantmentEntry(entries, power, Enchantments.f_44980_);
                }
                if (AxesAreWeaponsCommon.CONFIG.enableFireAspect) {
                    AxesAreWeaponsCommon.addEnchantmentEntry(entries, power, Enchantments.f_44981_);
                }
                if (AxesAreWeaponsCommon.CONFIG.enableModded) {
                    for (ResourceLocation id : BuiltInRegistries.f_256876_.m_6566_()) {
                        Optional enchantment;
                        if (id.m_135827_().equals("minecraft") || !(enchantment = BuiltInRegistries.f_256876_.m_6612_(id)).isPresent() || ((Enchantment)enchantment.get()).f_44672_ != EnchantmentCategory.WEAPON) continue;
                        AxesAreWeaponsCommon.addEnchantmentEntry(entries, power, (Enchantment)enchantment.get());
                    }
                }
            }
        }
    }
}

