/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.world;

import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.hurts.sskirillss.relics.init.CodecRegistry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.loot.LootModifierManager;
import org.jetbrains.annotations.NotNull;

public class RelicLootModifier
extends LootModifier {
    private final LootItem entry;
    private final LootItemFunction[] functions;
    public static Codec<RelicLootModifier> CODEC = RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)Codec.PASSTHROUGH.flatXmap(d -> {
        try {
            return DataResult.success((Object)((LootItem)LootModifierManager.GSON_INSTANCE.fromJson(IGlobalLootModifier.getJson((Dynamic)d), LootItem.class)));
        }
        catch (JsonSyntaxException e) {
            LootModifierManager.LOGGER.warn("Unable to decode loot item", (Throwable)e);
            return DataResult.error(e::getMessage);
        }
    }, item -> {
        try {
            JsonElement element = LootModifierManager.GSON_INSTANCE.toJsonTree(item);
            return DataResult.success((Object)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)element));
        }
        catch (JsonSyntaxException e) {
            LootModifierManager.LOGGER.warn("Unable to encode loot item", (Throwable)e);
            return DataResult.error(e::getMessage);
        }
    }).fieldOf("entry").forGetter(m -> m.entry), (App)Codec.PASSTHROUGH.flatXmap(d -> {
        try {
            return DataResult.success((Object)((LootItemFunction[])LootModifierManager.GSON_INSTANCE.fromJson(IGlobalLootModifier.getJson((Dynamic)d), LootItemFunction[].class)));
        }
        catch (JsonSyntaxException e) {
            LootModifierManager.LOGGER.warn("Unable to decode loot functions", (Throwable)e);
            return DataResult.error(e::getMessage);
        }
    }, function -> {
        try {
            JsonElement element = LootModifierManager.GSON_INSTANCE.toJsonTree(function);
            return DataResult.success((Object)new Dynamic((DynamicOps)JsonOps.INSTANCE, (Object)element));
        }
        catch (JsonSyntaxException e) {
            LootModifierManager.LOGGER.warn("Unable to encode loot functions", (Throwable)e);
            return DataResult.error(e::getMessage);
        }
    }).fieldOf("functions").forGetter(m -> m.functions))).apply((Applicative)inst, RelicLootModifier::new));

    public RelicLootModifier(LootItemCondition[] conditionsIn, LootItem entry, LootItemFunction[] functions) {
        super(conditionsIn);
        this.entry = entry;
        this.functions = functions;
    }

    @Nonnull
    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        this.entry.m_6562_(context, generator -> generator.m_6941_(LootItemFunction.m_80724_((BiFunction)LootItemFunctions.m_80770_((BiFunction[])this.functions), arg_0 -> ((ObjectArrayList)generatedLoot).add(arg_0), (LootContext)context), context));
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)CodecRegistry.RELIC_LOOT.get();
    }
}

