/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import it.hurts.sskirillss.relics.utils.data.AnimationData;
import java.awt.Color;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix4f;

public class RenderUtils {
    public static void renderTextureFromCenter(PoseStack matrix, float centerX, float centerY, float texWidth, float texHeight, float patternWidth, float patternHeight, float scale, AnimationData animation) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level == null) {
            return;
        }
        RenderUtils.renderTextureFromCenter(matrix, centerX, centerY, texWidth, texHeight, patternWidth, patternHeight, scale, animation, level.m_46467_());
    }

    public static void renderTextureFromCenter(PoseStack matrix, float centerX, float centerY, float texWidth, float texHeight, float patternWidth, float patternHeight, float scale, AnimationData animation, long ticks) {
        Pair<Integer, Integer> pair;
        int index = 0;
        for (long time = ticks % (long)animation.getLength(); time > 0L; time -= (long)((Integer)pair.getRight()).intValue()) {
            pair = animation.getFrames().get(index);
            index = index >= animation.getFrames().size() - 1 ? 0 : index + 1;
        }
        pair = animation.getFrames().get(index);
        RenderUtils.renderTextureFromCenter(matrix, centerX, centerY, 0.0f, patternHeight * (float)((Integer)pair.getKey()).intValue(), texWidth, texHeight, patternWidth, patternHeight, scale);
    }

    public static void renderTextureFromCenter(PoseStack matrix, float centerX, float centerY, float width, float height, float scale) {
        RenderUtils.renderTextureFromCenter(matrix, centerX, centerY, 0.0f, 0.0f, width, height, width, height, scale);
    }

    public static void renderTextureFromCenter(PoseStack matrix, float centerX, float centerY, float texOffX, float texOffY, float texWidth, float texHeight, float width, float height, float scale) {
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        RenderSystem.setShader(GameRenderer::m_172817_);
        builder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        matrix.m_85836_();
        matrix.m_252880_(centerX, centerY, 0.0f);
        matrix.m_85841_(scale, scale, scale);
        Matrix4f m = matrix.m_85850_().m_252922_();
        float u1 = texOffX / texWidth;
        float u2 = (texOffX + width) / texWidth;
        float v1 = texOffY / texHeight;
        float v2 = (texOffY + height) / texHeight;
        float w2 = width / 2.0f;
        float h2 = height / 2.0f;
        builder.m_252986_(m, -w2, h2, 0.0f).m_7421_(u1, v2).m_5752_();
        builder.m_252986_(m, w2, h2, 0.0f).m_7421_(u2, v2).m_5752_();
        builder.m_252986_(m, w2, -h2, 0.0f).m_7421_(u2, v1).m_5752_();
        builder.m_252986_(m, -w2, -h2, 0.0f).m_7421_(u1, v1).m_5752_();
        matrix.m_85849_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)builder.m_231175_());
    }

    public static void renderBeams(PoseStack matrixStack, MultiBufferSource bufferIn, float partialTicks, int amount, float size, Color color) {
        matrixStack.m_85836_();
        Random random = new Random(1488L);
        for (int i = 1; i < amount; ++i) {
            matrixStack.m_252781_(Axis.f_252529_.m_252977_(random.nextFloat() * 360.0f + partialTicks));
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(random.nextFloat() * 360.0f + partialTicks));
            matrixStack.m_252781_(Axis.f_252403_.m_252977_(random.nextFloat() * 360.0f + partialTicks));
            RenderUtils.renderBeam(matrixStack, bufferIn, partialTicks, size, color);
        }
        matrixStack.m_85849_();
    }

    public static void renderBeam(PoseStack matrixStack, MultiBufferSource bufferIn, float partialTicks, float size, Color color) {
        VertexConsumer builder = bufferIn.m_6299_(RenderType.m_110502_());
        Matrix4f matrix4f = matrixStack.m_85850_().m_252922_();
        float length = size * 0.2f;
        int red = Mth.m_14045_((int)color.getRed(), (int)0, (int)255);
        int green = Mth.m_14045_((int)color.getGreen(), (int)0, (int)255);
        int blue = Mth.m_14045_((int)color.getBlue(), (int)0, (int)255);
        int alpha = (int)(255.0f * (1.0f - partialTicks / 200.0f));
        builder.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, alpha).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, alpha).m_5752_();
        builder.m_252986_(matrix4f, -((float)(Math.sqrt(3.0) / 2.0)) * length, size, -0.5f * length).m_6122_(red, green, blue, 0).m_5752_();
        builder.m_252986_(matrix4f, (float)(Math.sqrt(3.0) / 2.0) * length, size, -0.5f * length).m_6122_(red, green, blue, 0).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, alpha).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, alpha).m_5752_();
        builder.m_252986_(matrix4f, (float)(Math.sqrt(3.0) / 2.0) * length, size, -0.5f * length).m_6122_(red, green, blue, 0).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, size, length).m_6122_(red, green, blue, 0).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, alpha).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, alpha).m_5752_();
        builder.m_252986_(matrix4f, 0.0f, size, length).m_6122_(red, green, blue, 0).m_5752_();
        builder.m_252986_(matrix4f, -((float)(Math.sqrt(3.0) / 2.0)) * length, size, -0.5f * length).m_6122_(red, green, blue, 0).m_5752_();
    }
}

