/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.network.packets.leveling;

import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.utils.AbilityUtils;
import it.hurts.sskirillss.relics.items.relics.base.utils.LevelingUtils;
import it.hurts.sskirillss.relics.tiles.ResearchingTableTile;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class PacketRelicTweak {
    private final BlockPos pos;
    private final String ability;
    private final Operation operation;

    public PacketRelicTweak(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.ability = buf.m_130277_();
        this.operation = (Operation)buf.m_130066_(Operation.class);
    }

    public PacketRelicTweak(BlockPos pos, String ability, Operation operation) {
        this.pos = pos;
        this.ability = ability;
        this.operation = operation;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130070_(this.ability);
        buf.m_130068_((Enum)this.operation);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            Level world = player.m_9236_();
            BlockEntity patt1798$temp = world.m_7702_(this.pos);
            if (!(patt1798$temp instanceof ResearchingTableTile)) {
                return;
            }
            ResearchingTableTile tile = (ResearchingTableTile)patt1798$temp;
            ItemStack stack = tile.getStack();
            Item patt1949$temp = stack.m_41720_();
            if (!(patt1949$temp instanceof RelicItem)) {
                return;
            }
            RelicItem relic = (RelicItem)patt1949$temp;
            RelicAbilityData data = relic.getRelicData().getAbilityData();
            if (data == null) {
                return;
            }
            RelicAbilityEntry entry = data.getAbilities().get(this.ability);
            if (entry == null) {
                return;
            }
            switch (this.operation) {
                case INCREASE: {
                    if (!AbilityUtils.mayPlayerUpgrade((Player)player, stack, this.ability)) break;
                    player.m_6756_(-AbilityUtils.getUpgradeRequiredExperience(stack, this.ability));
                    AbilityUtils.setAbilityPoints(stack, this.ability, AbilityUtils.getAbilityPoints(stack, this.ability) + 1);
                    LevelingUtils.addPoints(stack, -entry.getRequiredPoints());
                    break;
                }
                case REROLL: {
                    if (!AbilityUtils.mayPlayerReroll((Player)player, stack, this.ability)) break;
                    player.m_6756_(-AbilityUtils.getRerollRequiredExperience(stack, this.ability));
                    AbilityUtils.randomizeStats(stack, this.ability);
                    break;
                }
                case RESET: {
                    if (!AbilityUtils.mayPlayerReset((Player)player, stack, this.ability)) break;
                    player.m_6756_(-AbilityUtils.getResetRequiredExperience(stack, this.ability));
                    LevelingUtils.addPoints(stack, AbilityUtils.getAbilityPoints(stack, this.ability) * entry.getRequiredPoints());
                    AbilityUtils.setAbilityPoints(stack, this.ability, 0);
                }
            }
            world.m_7260_(this.pos, world.m_8055_(this.pos), world.m_8055_(this.pos), 2);
        });
        return true;
    }

    public static enum Operation {
        RESET,
        INCREASE,
        REROLL;

    }
}

