/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.network.packets.abilities;

import it.hurts.sskirillss.relics.client.hud.abilities.ActiveAbilityUtils;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.AbilityCastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.AbilityCastType;
import it.hurts.sskirillss.relics.items.relics.base.utils.AbilityUtils;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class SpellCastPacket {
    private final AbilityCastType type;
    private final AbilityCastStage stage;
    private final String ability;
    private final int slot;

    public SpellCastPacket(FriendlyByteBuf buf) {
        this.ability = buf.m_130277_();
        this.slot = buf.readInt();
        this.type = (AbilityCastType)buf.m_130066_(AbilityCastType.class);
        this.stage = (AbilityCastStage)buf.m_130066_(AbilityCastStage.class);
    }

    public SpellCastPacket(AbilityCastType type, AbilityCastStage stage, String ability, int slot) {
        this.ability = ability;
        this.slot = slot;
        this.type = type;
        this.stage = stage;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130070_(this.ability);
        buf.writeInt(this.slot);
        buf.m_130068_((Enum)this.type);
        buf.m_130068_((Enum)this.stage);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player == null) {
                return;
            }
            ItemStack stack = ActiveAbilityUtils.getStackInCuriosSlot((Player)player, this.slot);
            Item patt1836$temp = stack.m_41720_();
            if (!(patt1836$temp instanceof RelicItem)) {
                return;
            }
            RelicItem relic = (RelicItem)patt1836$temp;
            if (!ActiveAbilityUtils.getRelicActiveAbilities(stack).contains(this.ability) || !AbilityUtils.canPlayerUseActiveAbility((Player)player, stack, this.ability)) {
                if (AbilityUtils.isAbilityTicking(stack, this.ability)) {
                    AbilityUtils.setAbilityTicking(stack, this.ability, false);
                    relic.castActiveAbility(stack, (Player)player, this.ability, this.type, AbilityCastStage.END);
                }
                return;
            }
            block0 : switch (this.type) {
                case CYCLICAL: {
                    switch (this.stage) {
                        case START: {
                            AbilityUtils.setAbilityTicking(stack, this.ability, true);
                            break;
                        }
                        case END: {
                            AbilityUtils.setAbilityTicking(stack, this.ability, false);
                        }
                    }
                    break;
                }
                case TOGGLEABLE: {
                    switch (this.stage) {
                        case START: {
                            AbilityUtils.setAbilityTicking(stack, this.ability, true);
                            break block0;
                        }
                        case END: {
                            AbilityUtils.setAbilityTicking(stack, this.ability, false);
                        }
                    }
                }
            }
            relic.castActiveAbility(stack, (Player)player, this.ability, this.type, this.stage);
        });
        return true;
    }
}

