/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.mixin;

import it.hurts.sskirillss.relics.api.events.common.EntityBlockSpeedFactorEvent;
import it.hurts.sskirillss.relics.api.events.common.FluidCollisionEvent;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Entity.class})
public class MixinEntity {
    @ModifyVariable(method={"move"}, ordinal=1, index=3, name={"vec32"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/world/entity/Entity;collide(Lnet/minecraft/world/phys/Vec3;)Lnet/minecraft/world/phys/Vec3;"))
    public Vec3 fluidCollision(Vec3 original) {
        Entity entity = (Entity)this;
        if (!(entity instanceof LivingEntity)) {
            return original;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        if (original.f_82480_ > 0.0) {
            return original;
        }
        Level level = entity2.m_20193_();
        int[][] offsets = new int[][]{{1, 0, 1}, {1, 0, 0}, {1, -1, 0}, {1, 0, -1}, {0, 0, 1}, {0, 0, 0}, {0, -1, 0}, {0, 0, -1}, {-1, 0, 1}, {-1, 0, 0}, {-1, -1, 0}, {-1, 0, -1}};
        double highestValue = original.f_82480_;
        FluidState highestFluid = null;
        for (int[] offset : offsets) {
            double height;
            VoxelShape shape;
            BlockPos sourcePos = entity2.m_20183_();
            BlockPos pos = new BlockPos(sourcePos.m_123341_() + offset[0], sourcePos.m_123342_() + offset[1], sourcePos.m_123343_() + offset[2]);
            FluidState fluidState = level.m_6425_(pos);
            if (fluidState.m_76178_() || !Shapes.m_83157_((VoxelShape)(shape = Shapes.m_83144_().m_83216_((double)pos.m_123341_(), (double)((float)pos.m_123342_() + fluidState.m_76182_()), (double)pos.m_123343_())), (VoxelShape)Shapes.m_83064_((AABB)entity2.m_20191_().m_82400_(0.5)), (BooleanOp)BooleanOp.f_82689_) || !(highestValue < (height = shape.m_83297_(Direction.Axis.Y) - entity2.m_20186_() - 1.0))) continue;
            highestValue = height;
            highestFluid = fluidState;
        }
        if (highestFluid == null) {
            return original;
        }
        FluidCollisionEvent event = new FluidCollisionEvent(entity2, highestFluid);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            entity2.f_19789_ = 0.0f;
            entity2.m_6853_(true);
            return new Vec3(original.f_82479_, highestValue, original.f_82481_);
        }
        return original;
    }

    @Inject(at={@At(value="RETURN")}, method={"isInWaterOrRain"}, cancellable=true)
    public void setWet(CallbackInfoReturnable<Boolean> info) {
        Entity entity = (Entity)this;
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        if (!EntityUtils.findEquippedCurio(entity, (Item)ItemRegistry.DROWNED_BELT.get()).m_41619_()) {
            info.setReturnValue((Object)true);
        }
    }

    @Inject(method={"getBlockSpeedFactor"}, at={@At(value="RETURN")}, cancellable=true)
    public void getBlockSpeedFactor(CallbackInfoReturnable<Float> cir) {
        Entity entity = (Entity)this;
        EntityBlockSpeedFactorEvent event = new EntityBlockSpeedFactorEvent(entity, entity.m_9236_().m_8055_(entity.m_20097_()), ((Float)cir.getReturnValue()).floatValue());
        MinecraftForge.EVENT_BUS.post((Event)event);
        cir.setReturnValue((Object)Float.valueOf(event.getSpeedFactor()));
    }
}

