/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.talisman;

import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.entities.SporeEntity;
import it.hurts.sskirillss.relics.init.EntityRegistry;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.AbilityCastPredicate;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.AbilityCastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.AbilityCastType;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.data.PredicateInfo;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.items.relics.base.utils.AbilityUtils;
import it.hurts.sskirillss.relics.items.relics.base.utils.LevelingUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;

public class SporeSackItem
extends RelicItem {
    private static final String TAG_SPORES = "spores";

    @Override
    public RelicData constructRelicData() {
        return RelicData.builder().abilityData(RelicAbilityData.builder().ability("spore", RelicAbilityEntry.builder().maxLevel(10).stat("size", RelicAbilityStat.builder().initialValue(0.1, 0.5).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.15).formatValue(value -> MathUtils.round(value, 2)).build()).stat("damage", RelicAbilityStat.builder().initialValue(0.25, 0.5).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_TOTAL, 0.1).formatValue(value -> MathUtils.round(value, 2)).build()).stat("cooldown", RelicAbilityStat.builder().initialValue(15.0, 10.0).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_TOTAL, -0.1).formatValue(value -> MathUtils.round(value, 1)).build()).stat("duration", RelicAbilityStat.builder().initialValue(2.0, 4.0).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_TOTAL, 0.2).formatValue(value -> MathUtils.round(value, 1)).build()).build()).ability("buffer", RelicAbilityEntry.builder().requiredLevel(5).maxLevel(10).stat("capacity", RelicAbilityStat.builder().initialValue(2.0, 5.0).upgradeModifier(RelicAbilityStat.Operation.ADD, 1.0).formatValue(value -> (int)MathUtils.round(value, 0)).build()).stat("chance", RelicAbilityStat.builder().initialValue(0.025, 0.075).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_TOTAL, 0.1).formatValue(value -> MathUtils.round(value * 100.0, 1)).build()).build()).ability("multiplying", RelicAbilityEntry.builder().requiredLevel(10).maxLevel(10).stat("chance", RelicAbilityStat.builder().initialValue(0.05, 0.15).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_TOTAL, 0.128).formatValue(value -> (int)Math.round(MathUtils.round(value, 3) * 100.0)).build()).stat("size", RelicAbilityStat.builder().initialValue(0.05, 0.1).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_TOTAL, 0.1775).formatValue(value -> (int)Math.round(MathUtils.round(value, 3) * 100.0)).build()).stat("amount", RelicAbilityStat.builder().initialValue(0.05, 0.15).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.4).formatValue(value -> MathUtils.round(value, 2)).build()).build()).ability("explosion", RelicAbilityEntry.builder().requiredLevel(15).maxLevel(10).active(AbilityCastType.INSTANTANEOUS, AbilityCastPredicate.builder().predicate("spore", data -> {
            int spores = NBTUtils.getInt(data.getStack(), TAG_SPORES, 0);
            return PredicateInfo.builder().description(spores, 1).condition(spores > 0).build();
        })).stat("size", RelicAbilityStat.builder().initialValue(0.05, 0.25).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.15).formatValue(value -> MathUtils.round(value, 2)).build()).build()).build()).levelingData(new RelicLevelingData(100, 20, 100)).styleData(RelicStyleData.builder().borders("#ffe0d2", "#9c756b").build()).build();
    }

    public static int getMaxSpores(ItemStack stack) {
        return (int)Math.round(AbilityUtils.canUseAbility(stack, "buffer") ? AbilityUtils.getAbilityValue(stack, "buffer", "capacity") : 1.0);
    }

    public static int getSpores(ItemStack stack) {
        return NBTUtils.getInt(stack, TAG_SPORES, 0);
    }

    public static void setSpores(ItemStack stack, int amount) {
        NBTUtils.setInt(stack, TAG_SPORES, Mth.m_14045_((int)amount, (int)0, (int)SporeSackItem.getMaxSpores(stack)));
    }

    public static void addSpores(ItemStack stack, int amount) {
        if (AbilityUtils.canUseAbility(stack, "buffer") && amount < 0) {
            Random random = new Random();
            if ((double)random.nextFloat() <= AbilityUtils.getAbilityValue(stack, "buffer", "chance")) {
                return;
            }
        }
        SporeSackItem.setSpores(stack, SporeSackItem.getSpores(stack) + amount);
    }

    @Override
    public void castActiveAbility(ItemStack stack, Player player, String ability, AbilityCastType type, AbilityCastStage stage) {
        Level level = player.m_20193_();
        RandomSource random = level.m_213780_();
        if (ability.equals("explosion") && SporeSackItem.getSpores(stack) > 0) {
            ParticleUtils.createBall((ParticleOptions)ParticleTypes.f_123764_, player.m_20182_().m_82520_(0.0, (double)(player.m_20206_() / 2.0f), 0.0), level, 2, 0.5f);
            level.m_5594_(null, player.m_20183_(), SoundEvents.f_12290_, SoundSource.MASTER, 1.0f, 1.0f);
            while (SporeSackItem.getSpores(stack) > 0) {
                float mul = player.m_20206_() / 1.5f;
                float speed = 0.25f + random.m_188501_() * 0.2f;
                Vec3 motion = new Vec3((double)(MathUtils.randomFloat(random) * speed), (double)speed, (double)(MathUtils.randomFloat(random) * speed));
                SporeEntity spore = new SporeEntity((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.SPORE.get()), level);
                spore.m_5602_((Entity)player);
                spore.setStack(stack);
                spore.m_20256_(motion);
                spore.m_146884_(player.m_20182_().m_82520_(0.0, (double)mul, 0.0).m_82549_(motion.m_82541_().m_82490_((double)mul)));
                spore.setSize((float)Math.min((double)player.m_21233_(), (double)0.1f + (double)(player.m_21233_() - player.m_21223_()) * AbilityUtils.getAbilityValue(stack, "explosion", "size")));
                level.m_7967_((Entity)spore);
                SporeSackItem.addSpores(stack, -1);
            }
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).m_9236_().m_5776_() || SporeSackItem.getSpores(stack) >= SporeSackItem.getMaxSpores(stack) || (long)player.f_19797_ % Math.round(AbilityUtils.getAbilityValue(stack, "spore", "cooldown") * 20.0) != 0L) {
            return;
        }
        SporeSackItem.addSpores(stack, 1);
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class Events {
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.SPORE_SACK.get());
            if (stack.m_41619_() || SporeSackItem.getSpores(stack) < 1) {
                return;
            }
            Level level = player.m_9236_();
            if (level.m_5776_()) {
                return;
            }
            RandomSource random = player.m_217043_();
            float mul = player.m_20206_() / 1.5f;
            float speed = 0.25f + random.m_188501_() * 0.2f;
            Vec3 motion = new Vec3((double)(MathUtils.randomFloat(random) * speed), (double)speed, (double)(MathUtils.randomFloat(random) * speed));
            SporeEntity spore = new SporeEntity((EntityType<? extends ThrowableProjectile>)((EntityType)EntityRegistry.SPORE.get()), level);
            spore.m_5602_((Entity)player);
            spore.setStack(stack.m_41777_());
            spore.m_20256_(motion);
            spore.m_146884_(player.m_20182_().m_82520_(0.0, (double)mul, 0.0).m_82549_(motion.m_82541_().m_82490_((double)mul)));
            spore.setSize((float)Math.min((double)player.m_21233_(), (double)0.1f + (double)event.getAmount() * AbilityUtils.getAbilityValue(stack, "spore", "size")));
            level.m_7967_((Entity)spore);
            SporeSackItem.addSpores(stack, -1);
            LevelingUtils.addExperience((Entity)player, stack, 1);
        }
    }
}

