/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.necklace;

import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.entities.LifeEssenceEntity;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.items.relics.base.utils.AbilityUtils;
import it.hurts.sskirillss.relics.items.relics.base.utils.LevelingUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class HolyLocketItem
extends RelicItem {
    @Override
    public RelicData constructRelicData() {
        return RelicData.builder().abilityData(RelicAbilityData.builder().ability("steal", RelicAbilityEntry.builder().stat("radius", RelicAbilityStat.builder().initialValue(2.0, 6.0).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.25).formatValue(value -> MathUtils.round(value, 1)).build()).stat("amount", RelicAbilityStat.builder().initialValue(0.1, 0.25).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.2).formatValue(value -> (int)(MathUtils.round(value, 3) * 100.0)).build()).build()).build()).levelingData(new RelicLevelingData(100, 10, 200)).styleData(RelicStyleData.builder().borders("#dc41ff", "#832698").build()).build();
    }

    @Mod.EventBusSubscriber
    static class Events {
        Events() {
        }

        @SubscribeEvent
        public static void onLivingHurt(LivingHealEvent event) {
            LivingEntity entity = event.getEntity();
            Level level = entity.m_20193_();
            for (Player player : level.m_45976_(Player.class, entity.m_20191_().m_82400_(32.0))) {
                ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.HOLY_LOCKET.get());
                if (stack.m_41619_() || AbilityUtils.getAbilityValue(stack, "steal", "radius") < player.m_20182_().m_82554_(entity.m_20182_()) || entity.m_20149_().equals(player.m_20149_())) continue;
                float amount = (float)((double)event.getAmount() * AbilityUtils.getAbilityValue(stack, "steal", "amount"));
                LifeEssenceEntity essence = new LifeEssenceEntity((LivingEntity)player, amount);
                essence.m_146884_(entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0));
                essence.m_5602_((Entity)player);
                level.m_7967_((Entity)essence);
                if (event.getAmount() >= 1.0f) {
                    LevelingUtils.addExperience((Entity)player, stack, 1 + Math.round(amount));
                }
                event.setAmount(event.getAmount() - amount);
            }
        }
    }
}

