/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.hands;

import it.hurts.sskirillss.relics.client.particles.circle.CircleTintData;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.init.SoundRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.AbilityCastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.AbilityCastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.items.relics.base.utils.AbilityUtils;
import it.hurts.sskirillss.relics.items.relics.base.utils.LevelingUtils;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.network.packets.PacketPlayerMotion;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;

public class RageGloveItem
extends RelicItem {
    public static final String TAG_STACKS = "stacks";
    public static final String TAG_TIME = "time";

    @Override
    public RelicData constructRelicData() {
        return RelicData.builder().abilityData(RelicAbilityData.builder().ability("rage", RelicAbilityEntry.builder().maxLevel(10).stat("incoming_damage", RelicAbilityStat.builder().initialValue(0.05, 0.025).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.05).formatValue(value -> MathUtils.round(MathUtils.round(value, 3) * 100.0, 3)).build()).stat("dealt_damage", RelicAbilityStat.builder().initialValue(0.025, 0.075).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round(MathUtils.round(value, 3) * 100.0, 3)).build()).stat("duration", RelicAbilityStat.builder().initialValue(2.0, 4.0).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round(value, 1)).build()).build()).ability("phlebotomy", RelicAbilityEntry.builder().requiredLevel(5).maxLevel(10).stat("heal", RelicAbilityStat.builder().initialValue(1.0E-4, 2.5E-4).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round(MathUtils.round(value, 5) * 20.0, 5)).build()).stat("movement_speed", RelicAbilityStat.builder().initialValue(0.01, 0.025).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round(MathUtils.round(value, 3) * 100.0, 3)).build()).stat("attack_speed", RelicAbilityStat.builder().initialValue(0.005, 0.01).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.05).formatValue(value -> MathUtils.round(MathUtils.round(value, 3) * 100.0, 3)).build()).build()).ability("spurt", RelicAbilityEntry.builder().requiredLevel(10).maxLevel(10).active(AbilityCastType.INSTANTANEOUS).stat("damage", RelicAbilityStat.builder().initialValue(0.1, 0.25).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round(value, 2)).build()).stat("distance", RelicAbilityStat.builder().initialValue(3.0, 8.0).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.3).formatValue(value -> MathUtils.round(value, 1)).build()).stat("cooldown", RelicAbilityStat.builder().initialValue(20.0, 15.0).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_TOTAL, -0.075).formatValue(value -> MathUtils.round(value, 1)).build()).build()).build()).levelingData(new RelicLevelingData(100, 20, 100)).styleData(RelicStyleData.builder().borders("#eed551", "#dcbe1d").build()).build();
    }

    @Override
    public void castActiveAbility(ItemStack stack, Player player, String ability, AbilityCastType type, AbilityCastStage stage) {
        Level level = player.m_20193_();
        RandomSource random = level.m_213780_();
        if (ability.equals("spurt")) {
            Vec3 target;
            int stacks = NBTUtils.getInt(stack, TAG_STACKS, 0);
            double maxDistance = AbilityUtils.getAbilityValue(stack, "spurt", "distance");
            Vec3 view = player.m_20252_(0.0f);
            Vec3 eyeVec = player.m_20299_(0.0f);
            BlockHitResult ray = level.m_45547_(new ClipContext(eyeVec, eyeVec.m_82520_(view.f_82479_ * maxDistance, view.f_82480_ * maxDistance, view.f_82481_ * maxDistance), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
            Vec3 current = player.m_20182_();
            int distance = (int)Math.ceil(current.m_82554_(target = ray.m_82450_()));
            if (distance <= 0) {
                return;
            }
            Vec3 motion = player.m_20184_().m_82549_(target.m_82546_(current).m_82541_());
            player.m_6021_(target.f_82479_, target.f_82480_, target.f_82481_);
            if (!level.m_5776_()) {
                NetworkHandler.sendToClient(new PacketPlayerMotion(motion.f_82479_, motion.f_82480_, motion.f_82481_), (ServerPlayer)player);
                AbilityUtils.setAbilityCooldown(stack, "spurt", (int)Math.round(AbilityUtils.getAbilityValue(stack, "spurt", "cooldown") * 20.0));
            }
            player.f_19789_ = 0.0f;
            level.m_5594_(null, player.m_20183_(), (SoundEvent)SoundRegistry.SPURT.get(), SoundSource.MASTER, 1.0f, 0.75f + random.m_188501_() * 0.5f);
            Vec3 start = current.m_82520_(0.0, 1.0, 0.0);
            Vec3 end = target.m_82520_(0.0, 1.0, 0.0);
            Vec3 delta = end.m_82546_(start);
            Vec3 dir = delta.m_82541_();
            for (int i = 0; i < distance * 10; ++i) {
                double progress = (double)i * delta.m_82553_() / (double)(distance * 10);
                level.m_7106_((ParticleOptions)new CircleTintData(new Color(255, 60 + random.m_188503_(60), 0), 0.2f + random.m_188501_() * 0.5f, 60 + random.m_188503_(60), 0.95f, true), start.f_82479_ + dir.f_82479_ * progress, start.f_82480_ + dir.f_82480_ * progress, start.f_82481_ + dir.f_82481_ * progress, 0.0, (double)(MathUtils.randomFloat(random) * 0.075f), 0.0);
            }
            ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>();
            for (int i = 0; i < distance; ++i) {
                double progress = (double)i * delta.m_82553_() / (double)distance;
                for (LivingEntity entity : level.m_45976_(LivingEntity.class, new AABB(new BlockPos((int)(start.f_82479_ + dir.f_82479_ * progress), (int)(start.f_82480_ + dir.f_82480_ * progress), (int)(start.f_82481_ + dir.f_82481_ * progress))).m_82377_(0.5, 1.0, 0.5))) {
                    if (entity.m_20149_().equals(player.m_20149_()) || entity.m_21224_()) continue;
                    targets.add(entity);
                }
            }
            if (!targets.isEmpty()) {
                EntityUtils.resetAttribute((LivingEntity)player, stack, Attributes.f_22283_, 2.1474836E9f, AttributeModifier.Operation.MULTIPLY_BASE);
                EntityUtils.resetAttribute((LivingEntity)player, stack, Attributes.f_22281_, (float)(AbilityUtils.getAbilityValue(stack, "spurt", "damage") * (double)stacks), AttributeModifier.Operation.ADDITION);
                for (LivingEntity entity : targets) {
                    player.m_5706_((Entity)entity);
                    LevelingUtils.addExperience((Entity)player, stack, 1);
                    entity.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.BLEEDING.get(), 100, 0));
                    entity.m_20254_(5);
                }
                EntityUtils.removeAttribute((LivingEntity)player, stack, Attributes.f_22281_, AttributeModifier.Operation.ADDITION);
                EntityUtils.removeAttribute((LivingEntity)player, stack, Attributes.f_22283_, AttributeModifier.Operation.MULTIPLY_BASE);
            }
            NBTUtils.clearTag(stack, TAG_STACKS);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        int stacks;
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (AbilityUtils.canUseAbility(stack, "phlebotomy")) {
            float percentage = 100.0f - player.m_21223_() / player.m_21233_() * 100.0f;
            player.m_5634_((float)AbilityUtils.getAbilityValue(stack, "phlebotomy", "heal") * percentage);
            EntityUtils.resetAttribute((LivingEntity)player, stack, Attributes.f_22283_, (float)(AbilityUtils.getAbilityValue(stack, "phlebotomy", "attack_speed") * (double)percentage), AttributeModifier.Operation.MULTIPLY_TOTAL);
            EntityUtils.resetAttribute((LivingEntity)player, stack, Attributes.f_22279_, (float)(AbilityUtils.getAbilityValue(stack, "phlebotomy", "movement_speed") * (double)percentage), AttributeModifier.Operation.MULTIPLY_TOTAL);
        }
        if (AbilityUtils.canUseAbility(stack, "rage") && (stacks = NBTUtils.getInt(stack, TAG_STACKS, 0)) > 0) {
            int time = NBTUtils.getInt(stack, TAG_TIME, 0);
            if (time > 0) {
                NBTUtils.setInt(stack, TAG_TIME, --time);
            } else {
                NBTUtils.setInt(stack, TAG_STACKS, 0);
                LevelingUtils.addExperience((Entity)player, stack, (int)Math.floor((float)stacks / 3.0f));
            }
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        Player player;
        block3: {
            block2: {
                LivingEntity livingEntity = slotContext.entity();
                if (!(livingEntity instanceof Player)) break block2;
                player = (Player)livingEntity;
                if (stack.m_41720_() != newStack.m_41720_()) break block3;
            }
            return;
        }
        EntityUtils.removeAttribute((LivingEntity)player, stack, Attributes.f_22283_, AttributeModifier.Operation.MULTIPLY_TOTAL);
        EntityUtils.removeAttribute((LivingEntity)player, stack, Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_TOTAL);
        NBTUtils.clearTag(stack, TAG_STACKS);
        NBTUtils.clearTag(stack, TAG_TIME);
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class Events {
        @SubscribeEvent
        public static void onLivingHurt(LivingHurtEvent event) {
            Entity source = event.getSource().m_7640_();
            if (source instanceof Player) {
                Player player = (Player)source;
                if (!(event.getSource().m_7639_() instanceof Player)) {
                    return;
                }
                ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.RAGE_GLOVE.get());
                if (stack.m_41619_()) {
                    return;
                }
                if (AbilityUtils.canUseAbility(stack, "rage")) {
                    int stacks = NBTUtils.getInt(stack, RageGloveItem.TAG_STACKS, 0);
                    NBTUtils.setInt(stack, RageGloveItem.TAG_STACKS, ++stacks);
                    NBTUtils.setInt(stack, RageGloveItem.TAG_TIME, (int)Math.round(AbilityUtils.getAbilityValue(stack, "rage", "duration") * 20.0));
                    event.setAmount((float)((double)event.getAmount() + (double)event.getAmount() * ((double)stacks * AbilityUtils.getAbilityValue(stack, "rage", "dealt_damage"))));
                }
            } else {
                LivingEntity stack = event.getEntity();
                if (stack instanceof Player) {
                    Player player = (Player)stack;
                    if ((stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.RAGE_GLOVE.get())).m_41619_()) {
                        return;
                    }
                    if (AbilityUtils.canUseAbility((ItemStack)stack, "rage")) {
                        int stacks = NBTUtils.getInt((ItemStack)stack, RageGloveItem.TAG_STACKS, 0);
                        if (stacks <= 0) {
                            return;
                        }
                        event.setAmount((float)((double)event.getAmount() + (double)event.getAmount() * ((double)stacks * AbilityUtils.getAbilityValue((ItemStack)stack, "rage", "incoming_damage"))));
                    }
                }
            }
        }
    }
}

