/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.feet;

import it.hurts.sskirillss.relics.api.events.common.EntityBlockSpeedFactorEvent;
import it.hurts.sskirillss.relics.api.events.common.LivingSlippingEvent;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.items.relics.base.utils.AbilityUtils;
import it.hurts.sskirillss.relics.items.relics.base.utils.LevelingUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.SlotContext;

public class RollerSkatesItem
extends RelicItem {
    public static final String TAG_SKATING_DURATION = "duration";

    @Override
    public RelicData constructRelicData() {
        return RelicData.builder().abilityData(RelicAbilityData.builder().ability("skating", RelicAbilityEntry.builder().stat("speed", RelicAbilityStat.builder().initialValue(0.001, 0.005).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.15).formatValue(value -> (int)(MathUtils.round(value, 3) * 100.0 * 100.0)).build()).stat(TAG_SKATING_DURATION, RelicAbilityStat.builder().initialValue(15.0, 35.0).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.2).formatValue(value -> MathUtils.round(value / 5.0, 1)).build()).build()).build()).levelingData(new RelicLevelingData(100, 10, 200)).styleData(RelicStyleData.builder().borders("#dc41ff", "#832698").build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        int duration = NBTUtils.getInt(stack, TAG_SKATING_DURATION, 0);
        if (player.m_20142_() && !player.m_6144_() && !player.m_20069_() && !player.m_20077_()) {
            if (player.f_19797_ % 20 == 0) {
                LevelingUtils.addExperience((Entity)player, stack, 1);
            }
            if ((double)duration < AbilityUtils.getAbilityValue(stack, "skating", TAG_SKATING_DURATION) && player.f_19797_ % 4 == 0) {
                NBTUtils.setInt(stack, TAG_SKATING_DURATION, duration + 1);
            }
        } else if (duration > 0) {
            NBTUtils.setInt(stack, TAG_SKATING_DURATION, --duration);
        }
        EntityUtils.removeAttribute((LivingEntity)player, stack, Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_TOTAL);
        if (duration > 0) {
            EntityUtils.applyAttribute((LivingEntity)player, stack, Attributes.f_22279_, (float)((double)duration * AbilityUtils.getAbilityValue(stack, "skating", "speed")), AttributeModifier.Operation.MULTIPLY_TOTAL);
            EntityUtils.applyAttribute((LivingEntity)player, stack, (Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 0.6f, AttributeModifier.Operation.ADDITION);
        } else {
            EntityUtils.removeAttribute((LivingEntity)player, stack, (Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), AttributeModifier.Operation.ADDITION);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (stack.m_41720_() == newStack.m_41720_()) {
            return;
        }
        LivingEntity entity = slotContext.entity();
        EntityUtils.removeAttribute(entity, stack, Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_TOTAL);
        EntityUtils.removeAttribute(entity, stack, (Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), AttributeModifier.Operation.ADDITION);
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class Events {
        @SubscribeEvent
        public static void onLivingSlipping(LivingSlippingEvent event) {
            Player player;
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).m_20069_() || player.m_21255_()) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.ROLLER_SKATES.get());
            if (stack.m_41619_()) {
                return;
            }
            event.setFriction(1.075f);
        }

        @SubscribeEvent
        public static void onSpeedFactor(EntityBlockSpeedFactorEvent event) {
            Player player;
            Entity entity = event.getEntity();
            if (!(entity instanceof Player) || (player = (Player)entity).m_20069_() || player.m_21255_()) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.ROLLER_SKATES.get());
            if (stack.m_41619_()) {
                return;
            }
            event.setSpeedFactor(1.0f);
        }
    }
}

