/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.feet;

import it.hurts.sskirillss.relics.api.events.common.FluidCollisionEvent;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.items.relics.base.utils.AbilityUtils;
import it.hurts.sskirillss.relics.items.relics.base.utils.LevelingUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="relics")
public class MagmaWalkerItem
extends RelicItem {
    public static final String TAG_HEAT = "heat";

    @Override
    public RelicData constructRelicData() {
        return RelicData.builder().abilityData(RelicAbilityData.builder().ability("heat_resistance", RelicAbilityEntry.builder().maxLevel(0).build()).ability("pace", RelicAbilityEntry.builder().stat("time", RelicAbilityStat.builder().initialValue(20.0, 50.0).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)MathUtils.round(value, 0)).build()).build()).build()).levelingData(new RelicLevelingData(100, 10, 200)).styleData(RelicStyleData.builder().borders("#dc41ff", "#832698").build()).build();
    }

    @Override
    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        Player player;
        int heat;
        block7: {
            block6: {
                heat = NBTUtils.getInt(stack, TAG_HEAT, 0);
                if (!(entity instanceof Player)) break block6;
                player = (Player)entity;
                if (player.f_19797_ % 20 == 0) break block7;
            }
            return;
        }
        if (heat > 0) {
            if ((double)heat > AbilityUtils.getAbilityValue(stack, "pace", "time")) {
                player.m_6469_(level.m_269111_().m_269047_(), (float)(1.0 + ((double)heat - AbilityUtils.getAbilityValue(stack, "pace", "time")) / 10.0));
            }
            if (!level.m_6425_(player.m_20183_().m_7495_()).m_205070_(FluidTags.f_13132_) && !level.m_6425_(player.m_20183_()).m_205070_(FluidTags.f_13132_)) {
                NBTUtils.setInt(stack, TAG_HEAT, --heat);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)event.getEntity(), (Item)ItemRegistry.MAGMA_WALKER.get());
        if (!stack.m_41619_() && event.getSource() == event.getEntity().m_9236_().m_269111_().m_269047_() && (double)NBTUtils.getInt(stack, TAG_HEAT, 0) <= AbilityUtils.getAbilityValue(stack, "pace", "time")) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onFluidCollide(FluidCollisionEvent event) {
        Player player;
        ItemStack stack;
        block6: {
            block5: {
                stack = EntityUtils.findEquippedCurio((Entity)event.getEntity(), (Item)ItemRegistry.MAGMA_WALKER.get());
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block5;
                player = (Player)livingEntity;
                if (!stack.m_41619_() && event.getFluid().m_205070_(FluidTags.f_13132_) && !player.m_6144_()) break block6;
            }
            return;
        }
        if (player.f_19797_ % 20 == 0) {
            int heat = NBTUtils.getInt(stack, TAG_HEAT, 0);
            NBTUtils.setInt(stack, TAG_HEAT, ++heat);
            if (heat % 5 == 0) {
                LevelingUtils.addExperience((Entity)player, stack, 1);
            }
        }
        event.setCanceled(true);
    }
}

