/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.feet;

import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.items.relics.base.utils.AbilityUtils;
import it.hurts.sskirillss.relics.items.relics.base.utils.LevelingUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import it.hurts.sskirillss.relics.utils.WorldUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import top.theillusivec4.curios.api.SlotContext;

public class IceSkatesItem
extends RelicItem {
    private static final String TAG_SKATING_DURATION = "duration";

    @Override
    public RelicData constructRelicData() {
        return RelicData.builder().abilityData(RelicAbilityData.builder().ability("skating", RelicAbilityEntry.builder().stat("speed", RelicAbilityStat.builder().initialValue(0.01, 0.035).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.15).formatValue(value -> (int)(MathUtils.round(value, 3) * 10.0 * 100.0)).build()).stat(TAG_SKATING_DURATION, RelicAbilityStat.builder().initialValue(25.0, 50.0).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round(value / 10.0, 1)).build()).build()).ability("ram", RelicAbilityEntry.builder().requiredLevel(5).stat("damage", RelicAbilityStat.builder().initialValue(0.05, 0.25).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)(MathUtils.round(value, 1) * 10.0)).build()).build()).build()).levelingData(new RelicLevelingData(100, 10, 200)).styleData(RelicStyleData.builder().borders("#dc41ff", "#832698").build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Level level = player.m_20193_();
        BlockPos pos = WorldUtils.getSolidBlockUnderFeet(level, player.m_20183_());
        int duration = NBTUtils.getInt(stack, TAG_SKATING_DURATION, 0);
        int maxDuration = (int)Math.round(AbilityUtils.getAbilityValue(stack, "skating", TAG_SKATING_DURATION));
        if (player.m_20142_() && !player.m_6144_() && !player.m_20069_() && !player.m_20077_() && pos != null && level.m_8055_(pos).m_204336_(BlockTags.f_13047_)) {
            if (player.f_19797_ % 20 == 0) {
                LevelingUtils.addExperience((Entity)player, stack, 1);
            }
            if (duration < maxDuration && player.f_19797_ % 2 == 0) {
                NBTUtils.setInt(stack, TAG_SKATING_DURATION, ++duration);
            }
            if (level.m_213780_().m_188503_(maxDuration) < duration) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123796_, player.m_20185_(), player.m_20186_() + (double)0.15f, player.m_20189_(), 0.0, 0.25, 0.0);
            }
        } else if (duration > 0) {
            NBTUtils.setInt(stack, TAG_SKATING_DURATION, Math.max(0, duration - 2));
        }
        if (AbilityUtils.canUseAbility(stack, "ram") && duration >= 10) {
            for (LivingEntity entity : level.m_45976_(LivingEntity.class, player.m_20191_())) {
                if (entity == player || entity.f_20916_ > 0) continue;
                entity.m_6469_(level.m_269111_().m_269075_(player), (float)((double)duration * AbilityUtils.getAbilityValue(stack, "ram", "damage")));
                double factor = Mth.m_14008_((double)((double)duration * 0.025), (double)1.0, (double)2.0);
                entity.m_20256_(entity.m_20182_().m_82520_(0.0, 0.5, 0.0).m_82546_(player.m_20182_()).m_82541_().m_82542_(factor, Math.max(1.0, factor / 2.0), factor));
            }
        }
        EntityUtils.removeAttribute((LivingEntity)player, stack, Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_TOTAL);
        if (duration > 0) {
            EntityUtils.applyAttribute((LivingEntity)player, stack, Attributes.f_22279_, (float)((double)duration * AbilityUtils.getAbilityValue(stack, "skating", "speed")), AttributeModifier.Operation.MULTIPLY_TOTAL);
            EntityUtils.applyAttribute((LivingEntity)player, stack, (Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), 0.6f, AttributeModifier.Operation.ADDITION);
        } else {
            EntityUtils.removeAttribute((LivingEntity)player, stack, (Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), AttributeModifier.Operation.ADDITION);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (stack.m_41720_() == newStack.m_41720_()) {
            return;
        }
        LivingEntity entity = slotContext.entity();
        EntityUtils.removeAttribute(entity, stack, Attributes.f_22279_, AttributeModifier.Operation.MULTIPLY_TOTAL);
        EntityUtils.removeAttribute(entity, stack, (Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get(), AttributeModifier.Operation.ADDITION);
    }
}

