/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.feet;

import it.hurts.sskirillss.relics.api.events.common.LivingSlippingEvent;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.entities.ShockwaveEntity;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicAttributeModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.AbilityCastPredicate;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.AbilityCastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.AbilityCastType;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.data.PredicateInfo;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.items.relics.base.utils.AbilityUtils;
import it.hurts.sskirillss.relics.items.relics.base.utils.LevelingUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class IceBreakerItem
extends RelicItem {
    public static final String TAG_FALLING = "falling";

    @Override
    public RelicData constructRelicData() {
        return RelicData.builder().abilityData(RelicAbilityData.builder().ability("sustainability", RelicAbilityEntry.builder().stat("modifier", RelicAbilityStat.builder().initialValue(0.75, 0.5).upgradeModifier(RelicAbilityStat.Operation.ADD, -0.05).formatValue(value -> (int)(MathUtils.round(1.0 - value, 1) * 100.0)).build()).build()).ability("impact", RelicAbilityEntry.builder().maxLevel(10).active(AbilityCastType.INSTANTANEOUS, AbilityCastPredicate.builder().predicate(TAG_FALLING, data -> {
            Player player = data.getPlayer();
            return PredicateInfo.builder().condition(!player.m_20096_() && !player.m_5833_()).build();
        })).stat("size", RelicAbilityStat.builder().initialValue(2.5, 5.0).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.3).formatValue(value -> MathUtils.round(value, 1)).build()).stat("damage", RelicAbilityStat.builder().initialValue(2.5, 5.0).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.25).formatValue(value -> MathUtils.round(value, 1)).build()).build()).build()).levelingData(new RelicLevelingData(100, 10, 200)).styleData(RelicStyleData.builder().borders("#dc41ff", "#832698").build()).build();
    }

    @Override
    public RelicAttributeModifier getAttributeModifiers(ItemStack stack) {
        return RelicAttributeModifier.builder().attribute(new RelicAttributeModifier.Modifier(Attributes.f_22278_, (float)AbilityUtils.getAbilityValue(stack, "sustainability", "modifier"))).build();
    }

    @Override
    public void castActiveAbility(ItemStack stack, Player player, String ability, AbilityCastType type, AbilityCastStage stage) {
        if (ability.equals("impact")) {
            NBTUtils.setBoolean(stack, TAG_FALLING, true);
        }
    }

    public void curioTick(String identifier, int index, LivingEntity livingEntity, ItemStack stack) {
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        boolean isFalling = NBTUtils.getBoolean(stack, TAG_FALLING, false);
        if (!isFalling) {
            return;
        }
        Vec3 motion = player.m_20184_();
        if (player.m_20096_() || player.m_5833_()) {
            NBTUtils.setBoolean(stack, TAG_FALLING, false);
            return;
        }
        player.m_36321_();
        player.m_150110_().f_35935_ = false;
        player.m_20334_(motion.m_7096_(), Math.min((double)-0.01f, motion.m_7098_() * (double)1.075f), motion.m_7094_());
    }

    @Mod.EventBusSubscriber(modid="relics")
    public static class Events {
        @SubscribeEvent
        public static void onLivingSlipping(LivingSlippingEvent event) {
            Player player;
            LivingEntity livingEntity;
            if (event.getFriction() <= 0.6f || !((livingEntity = event.getEntity()) instanceof Player) || (player = (Player)livingEntity).m_20069_() || player.m_20077_()) {
                return;
            }
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.ICE_BREAKER.get());
            if (stack.m_41619_()) {
                return;
            }
            event.setFriction(0.6f);
        }

        @SubscribeEvent
        public static void onEntityFall(LivingFallEvent event) {
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)ItemRegistry.ICE_BREAKER.get());
            if (stack.m_41619_()) {
                return;
            }
            float distance = event.getDistance();
            Level world = player.m_20193_();
            if (distance < 2.0f || !NBTUtils.getBoolean(stack, IceBreakerItem.TAG_FALLING, false)) {
                return;
            }
            LevelingUtils.addExperience((Entity)player, stack, Math.min(10, Math.round(distance / 3.0f)));
            ShockwaveEntity shockwave = new ShockwaveEntity(world, (int)Math.round(Math.min(AbilityUtils.getAbilityValue(stack, "impact", "size"), (double)distance * 0.25)), (float)AbilityUtils.getAbilityValue(stack, "impact", "damage"));
            BlockPos pos = player.m_20097_();
            shockwave.m_5602_((Entity)player);
            shockwave.m_6034_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            world.m_7967_((Entity)shockwave);
            world.m_5594_(null, player.m_20183_(), SoundEvents.f_12555_, SoundSource.MASTER, 0.75f, 1.0f);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123812_, player.m_20185_(), player.m_20186_(), player.m_20189_(), 0.0, 0.0, 0.0);
            event.setDamageMultiplier(0.0f);
        }
    }
}

