/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.feet;

import it.hurts.sskirillss.relics.api.events.common.FluidCollisionEvent;
import it.hurts.sskirillss.relics.client.tooltip.base.RelicStyleData;
import it.hurts.sskirillss.relics.init.ItemRegistry;
import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.items.relics.base.utils.AbilityUtils;
import it.hurts.sskirillss.relics.items.relics.base.utils.LevelingUtils;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="relics")
public class AquaWalkerItem
extends RelicItem {
    public static final String TAG_DRENCH = "drench";

    @Override
    public RelicData constructRelicData() {
        return RelicData.builder().abilityData(RelicAbilityData.builder().ability("walking", RelicAbilityEntry.builder().stat("time", RelicAbilityStat.builder().initialValue(30.0, 60.0).upgradeModifier(RelicAbilityStat.Operation.MULTIPLY_BASE, 0.1).formatValue(value -> (int)MathUtils.round(value, 0)).build()).build()).build()).levelingData(new RelicLevelingData(100, 10, 100)).styleData(RelicStyleData.builder().borders("#ff6900", "#ff2e00").build()).build();
    }

    @Override
    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean isSelected) {
        Player player;
        int drench;
        block5: {
            block4: {
                drench = NBTUtils.getInt(stack, TAG_DRENCH, 0);
                if (!(entity instanceof Player)) break block4;
                player = (Player)entity;
                if (player.f_19797_ % 20 == 0) break block5;
            }
            return;
        }
        if (drench > 0 && !player.m_20069_() && !player.m_9236_().m_6425_(player.m_20183_().m_7495_()).m_205070_(FluidTags.f_13131_)) {
            NBTUtils.setInt(stack, TAG_DRENCH, --drench);
        }
    }

    @SubscribeEvent
    public static void onFluidCollide(FluidCollisionEvent event) {
        Player player;
        int drench;
        ItemStack stack;
        block6: {
            block5: {
                stack = EntityUtils.findEquippedCurio((Entity)event.getEntity(), (Item)ItemRegistry.AQUA_WALKER.get());
                drench = NBTUtils.getInt(stack, TAG_DRENCH, 0);
                LivingEntity livingEntity = event.getEntity();
                if (!(livingEntity instanceof Player)) break block5;
                player = (Player)livingEntity;
                if (!stack.m_41619_() && !((double)drench > AbilityUtils.getAbilityValue(stack, "walking", "time")) && event.getFluid().m_205070_(FluidTags.f_13131_) && !player.m_6144_()) break block6;
            }
            return;
        }
        if (player.f_19797_ % 20 == 0) {
            NBTUtils.setInt(stack, TAG_DRENCH, ++drench);
            if (drench % 5 == 0) {
                LevelingUtils.addExperience((Entity)player, stack, 1);
            }
        }
        event.setCanceled(true);
    }
}

