/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.base.utils;

import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.utils.AbilityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class QualityUtils {
    public static final int MAX_QUALITY = 10;

    public static int getStatQuality(ItemStack stack, String ability, String stat) {
        double max;
        RelicAbilityStat statData = AbilityUtils.getRelicAbilityStat(stack.m_41720_(), ability, stat);
        if (statData == null) {
            return 0;
        }
        Function<Double, ? extends Number> format = statData.getFormatValue();
        double initial = format.apply(AbilityUtils.getAbilityInitialValue(stack, ability, stat)).doubleValue();
        double min = format.apply((Double)statData.getInitialValue().getKey()).doubleValue();
        if (min == (max = format.apply((Double)statData.getInitialValue().getValue()).doubleValue())) {
            return 10;
        }
        return Mth.m_14045_((int)((int)Math.round((initial - min) / ((max - min) / 10.0))), (int)0, (int)10);
    }

    public static double getStatByQuality(Item item, String ability, String stat, int quality) {
        double max;
        RelicAbilityStat statData = AbilityUtils.getRelicAbilityStat(item, ability, stat);
        if (statData == null) {
            return 0.0;
        }
        double min = (Double)statData.getInitialValue().getKey();
        if (min == (max = ((Double)statData.getInitialValue().getValue()).doubleValue())) {
            return 10.0;
        }
        return MathUtils.round(min + (max - min) / 10.0 * (double)quality, 5);
    }

    public static int getAbilityQuality(ItemStack stack, String ability) {
        RelicAbilityEntry entry = AbilityUtils.getRelicAbilityEntry(stack.m_41720_(), ability);
        if (entry == null) {
            return 0;
        }
        Map<String, RelicAbilityStat> stats = entry.getStats();
        if (stats.isEmpty()) {
            return 0;
        }
        int sum = 0;
        for (String stat : stats.keySet()) {
            sum += QualityUtils.getStatQuality(stack, ability, stat);
        }
        return Mth.m_14045_((int)(sum / stats.size()), (int)0, (int)10);
    }

    public static int getRelicQuality(ItemStack stack) {
        RelicAbilityData data = AbilityUtils.getRelicAbilityData(stack.m_41720_());
        if (data == null) {
            return 0;
        }
        Map<String, RelicAbilityEntry> abilities = data.getAbilities();
        if (abilities.isEmpty()) {
            return 0;
        }
        int size = abilities.size();
        int sum = 0;
        for (String ability : abilities.keySet()) {
            RelicAbilityEntry abilityData = AbilityUtils.getRelicAbilityEntry(stack.m_41720_(), ability);
            if (abilityData == null || abilityData.getMaxLevel() == 0) {
                --size;
                continue;
            }
            sum += QualityUtils.getAbilityQuality(stack, ability);
        }
        return Mth.m_14045_((int)(sum / size), (int)0, (int)10);
    }
}

