/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.base.utils;

import it.hurts.sskirillss.relics.api.events.leveling.ExperienceAddEvent;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicLevelingData;
import it.hurts.sskirillss.relics.items.relics.base.utils.DataUtils;
import it.hurts.sskirillss.relics.utils.NBTUtils;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class LevelingUtils {
    public static final String TAG_EXPERIENCE = "experience";
    public static final String TAG_LEVELING = "leveling";
    public static final String TAG_POINTS = "points";
    public static final String TAG_LEVEL = "level";

    @Nullable
    public static RelicLevelingData getRelicLevelingData(Item item) {
        RelicData relicData = DataUtils.getRelicData(item);
        if (relicData == null) {
            return null;
        }
        return relicData.getLevelingData();
    }

    public static CompoundTag getLevelingTag(ItemStack stack) {
        return NBTUtils.getCompound(stack, TAG_LEVELING, new CompoundTag());
    }

    public static void setLevelingTag(ItemStack stack, CompoundTag data) {
        NBTUtils.setCompound(stack, TAG_LEVELING, data);
    }

    public static int getPoints(ItemStack stack) {
        return LevelingUtils.getLevelingTag(stack).m_128451_(TAG_POINTS);
    }

    public static void setPoints(ItemStack stack, int amount) {
        CompoundTag tag = LevelingUtils.getLevelingTag(stack);
        tag.m_128405_(TAG_POINTS, Math.max(0, amount));
        LevelingUtils.setLevelingTag(stack, tag);
    }

    public static void addPoints(ItemStack stack, int amount) {
        LevelingUtils.setPoints(stack, LevelingUtils.getPoints(stack) + amount);
    }

    public static int getLevel(ItemStack stack) {
        return LevelingUtils.getLevelingTag(stack).m_128451_(TAG_LEVEL);
    }

    public static void setLevel(ItemStack stack, int level) {
        RelicLevelingData levelingData = LevelingUtils.getRelicLevelingData(stack.m_41720_());
        if (levelingData == null) {
            return;
        }
        CompoundTag tag = LevelingUtils.getLevelingTag(stack);
        tag.m_128405_(TAG_LEVEL, Mth.m_14045_((int)level, (int)0, (int)levelingData.getMaxLevel()));
        LevelingUtils.setLevelingTag(stack, tag);
    }

    public static void addLevel(ItemStack stack, int amount) {
        RelicLevelingData levelingData = LevelingUtils.getRelicLevelingData(stack.m_41720_());
        if (levelingData == null) {
            return;
        }
        if (amount > 0) {
            LevelingUtils.addPoints(stack, Mth.m_14045_((int)amount, (int)0, (int)(levelingData.getMaxLevel() - LevelingUtils.getLevel(stack))));
        }
        LevelingUtils.setLevel(stack, LevelingUtils.getLevel(stack) + amount);
    }

    public static int getExperience(ItemStack stack) {
        return LevelingUtils.getLevelingTag(stack).m_128451_(TAG_EXPERIENCE);
    }

    public static void setExperience(ItemStack stack, int experience) {
        int level = LevelingUtils.getLevel(stack);
        RelicLevelingData levelingData = LevelingUtils.getRelicLevelingData(stack.m_41720_());
        if (levelingData == null || level >= levelingData.getMaxLevel()) {
            return;
        }
        int requiredExp = LevelingUtils.getExperienceBetweenLevels(stack, level, level + 1);
        CompoundTag data = LevelingUtils.getLevelingTag(stack);
        if (experience >= requiredExp) {
            int sumExp = LevelingUtils.getTotalExperienceForLevel(stack, level) + experience;
            int resultLevel = LevelingUtils.getLevelFromExperience(stack, sumExp);
            data.m_128405_(TAG_EXPERIENCE, Math.max(0, sumExp - LevelingUtils.getTotalExperienceForLevel(stack, resultLevel)));
            LevelingUtils.setLevelingTag(stack, data);
            LevelingUtils.addPoints(stack, resultLevel - level);
            LevelingUtils.setLevel(stack, resultLevel);
        } else {
            data.m_128405_(TAG_EXPERIENCE, Math.max(0, experience));
            LevelingUtils.setLevelingTag(stack, data);
        }
    }

    public static void addExperience(ItemStack stack, int amount) {
        LevelingUtils.addExperience(null, stack, amount);
    }

    public static void addExperience(Entity entity, ItemStack stack, int amount) {
        ExperienceAddEvent event = new ExperienceAddEvent(entity instanceof Player ? (Player)entity : null, stack, amount);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (!event.isCanceled()) {
            LevelingUtils.setExperience(stack, LevelingUtils.getExperience(stack) + event.getAmount());
        }
    }

    public static int getExperienceLeftForLevel(ItemStack stack, int level) {
        int currentLevel = LevelingUtils.getLevel(stack);
        return LevelingUtils.getExperienceBetweenLevels(stack, currentLevel, level) - LevelingUtils.getExperience(stack);
    }

    public static int getExperienceBetweenLevels(ItemStack stack, int from, int to) {
        return LevelingUtils.getTotalExperienceForLevel(stack, to) - LevelingUtils.getTotalExperienceForLevel(stack, from);
    }

    public static int getTotalExperienceForLevel(ItemStack stack, int level) {
        if (level <= 0) {
            return 0;
        }
        RelicLevelingData levelingData = LevelingUtils.getRelicLevelingData(stack.m_41720_());
        if (levelingData == null) {
            return 0;
        }
        int result = levelingData.getInitialCost();
        for (int i = 1; i < level; ++i) {
            result += levelingData.getInitialCost() + levelingData.getStep() * i;
        }
        return result;
    }

    public static int getLevelFromExperience(ItemStack stack, int experience) {
        int amount;
        int result = 0;
        while ((amount = LevelingUtils.getTotalExperienceForLevel(stack, ++result)) <= experience) {
        }
        return result - 1;
    }
}

