/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.base.utils;

import it.hurts.sskirillss.relics.items.relics.base.RelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.base.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityEntry;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import it.hurts.sskirillss.relics.items.relics.base.utils.CastUtils;
import it.hurts.sskirillss.relics.items.relics.base.utils.DataUtils;
import it.hurts.sskirillss.relics.items.relics.base.utils.LevelingUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class AbilityUtils {
    public static final String TAG_COOLDOWN_CAP = "cooldown_cap";
    public static final String TAG_COOLDOWN = "cooldown";
    public static final String TAG_TICKING = "ticking";
    public static final String TAG_ABILITIES = "abilities";
    public static final String TAG_POINTS = "points";
    public static final String TAG_STATS = "stats";
    public static final String TAG_TEMP = "temp";

    @Nullable
    public static RelicAbilityData getRelicAbilityData(Item item) {
        RelicData relicData = DataUtils.getRelicData(item);
        if (relicData == null) {
            return null;
        }
        return relicData.getAbilityData();
    }

    @Nullable
    public static RelicAbilityEntry getRelicAbilityEntry(Item item, String ability) {
        if (!(item instanceof RelicItem)) {
            return null;
        }
        RelicAbilityData abilityData = AbilityUtils.getRelicAbilityData(item);
        if (abilityData == null) {
            return null;
        }
        return abilityData.getAbilities().get(ability);
    }

    @Nullable
    public static RelicAbilityStat getRelicAbilityStat(Item item, String ability, String stat) {
        if (!(item instanceof RelicItem)) {
            return null;
        }
        RelicAbilityEntry abilityEntry = AbilityUtils.getRelicAbilityEntry(item, ability);
        if (abilityEntry == null) {
            return null;
        }
        return abilityEntry.getStats().get(stat);
    }

    public static CompoundTag getAbilitiesTag(ItemStack stack) {
        return stack.m_41784_().m_128469_(TAG_ABILITIES);
    }

    public static void setAbilitiesTag(ItemStack stack, CompoundTag nbt) {
        stack.m_41784_().m_128365_(TAG_ABILITIES, (Tag)nbt);
    }

    public static CompoundTag getAbilityTag(ItemStack stack, String ability) {
        CompoundTag data = AbilityUtils.getAbilitiesTag(stack);
        if (data.m_128456_()) {
            return new CompoundTag();
        }
        return data.m_128469_(ability);
    }

    public static void setAbilityTag(ItemStack stack, String ability, CompoundTag nbt) {
        CompoundTag data = AbilityUtils.getAbilitiesTag(stack);
        data.m_128365_(ability, (Tag)nbt);
        AbilityUtils.setAbilitiesTag(stack, data);
    }

    public static CompoundTag getAbilityTempTag(ItemStack stack, String ability) {
        CompoundTag data = AbilityUtils.getAbilityTag(stack, ability);
        if (data.m_128456_()) {
            return new CompoundTag();
        }
        return data.m_128469_(TAG_TEMP);
    }

    public static void setAbilityTempTag(ItemStack stack, String ability, CompoundTag nbt) {
        CompoundTag data = AbilityUtils.getAbilityTag(stack, ability);
        data.m_128365_(TAG_TEMP, (Tag)nbt);
        AbilityUtils.setAbilityTag(stack, ability, data);
    }

    public static Map<String, Double> getAbilityInitialValues(ItemStack stack, String ability) {
        CompoundTag abilityTag = AbilityUtils.getAbilityTag(stack, ability);
        HashMap<String, Double> result = new HashMap<String, Double>();
        if (abilityTag.m_128456_()) {
            return result;
        }
        CompoundTag statTag = abilityTag.m_128469_(TAG_STATS);
        if (statTag.m_128456_()) {
            return result;
        }
        statTag.m_128431_().forEach(entry -> result.put((String)entry, statTag.m_128459_(entry)));
        return result;
    }

    public static double getAbilityInitialValue(ItemStack stack, String ability, String stat) {
        double result;
        try {
            result = AbilityUtils.getAbilityInitialValues(stack, ability).get(stat);
        }
        catch (NullPointerException exception) {
            if (AbilityUtils.getRelicAbilityStat(stack.m_41720_(), ability, stat) != null) {
                AbilityUtils.randomizeStats(stack, ability);
                result = AbilityUtils.getAbilityInitialValues(stack, ability).get(stat);
            }
            result = 0.0;
        }
        return result;
    }

    public static double getAbilityValue(ItemStack stack, String ability, String stat, int points) {
        RelicAbilityStat data = AbilityUtils.getRelicAbilityStat(stack.m_41720_(), ability, stat);
        double result = 0.0;
        if (data == null) {
            return result;
        }
        double current = AbilityUtils.getAbilityInitialValue(stack, ability, stat);
        double step = (Double)data.getUpgradeModifier().getValue();
        switch ((RelicAbilityStat.Operation)((Object)data.getUpgradeModifier().getKey())) {
            case ADD: {
                result = current + (double)points * step;
                break;
            }
            case MULTIPLY_BASE: {
                result = current + current * step * (double)points;
                break;
            }
            case MULTIPLY_TOTAL: {
                result = current * Math.pow(step + 1.0, points);
            }
        }
        Pair<Double, Double> threshold = data.getThresholdValue();
        return threshold == null ? MathUtils.round(result, 5) : MathUtils.round(Math.max((Double)threshold.getKey(), Math.min((Double)threshold.getValue(), result)), 5);
    }

    public static double getAbilityValue(ItemStack stack, String ability, String stat) {
        return AbilityUtils.getAbilityValue(stack, ability, stat, AbilityUtils.getAbilityPoints(stack, ability));
    }

    public static void setAbilityValue(ItemStack stack, String ability, String stat, double value) {
        CompoundTag data = AbilityUtils.getAbilitiesTag(stack);
        CompoundTag abilityTag = AbilityUtils.getAbilityTag(stack, ability);
        CompoundTag statTag = abilityTag.m_128469_(TAG_STATS);
        statTag.m_128347_(stat, value);
        abilityTag.m_128365_(TAG_STATS, (Tag)statTag);
        data.m_128365_(ability, (Tag)abilityTag);
        AbilityUtils.setAbilitiesTag(stack, data);
    }

    public static void addAbilityValue(ItemStack stack, String ability, String stat, double value) {
        AbilityUtils.setAbilityValue(stack, ability, stat, AbilityUtils.getAbilityValue(stack, ability, stat) + value);
    }

    public static int getAbilityPoints(ItemStack stack, String ability) {
        CompoundTag tag = AbilityUtils.getAbilityTag(stack, ability);
        if (tag.m_128456_()) {
            return 0;
        }
        return tag.m_128451_(TAG_POINTS);
    }

    public static void setAbilityPoints(ItemStack stack, String ability, int amount) {
        AbilityUtils.getAbilityTag(stack, ability).m_128405_(TAG_POINTS, Math.max(0, amount));
    }

    public static void addAbilityPoints(ItemStack stack, String ability, int amount) {
        AbilityUtils.getAbilityTag(stack, ability).m_128405_(TAG_POINTS, Math.max(0, AbilityUtils.getAbilityPoints(stack, ability) + amount));
    }

    public static boolean canUseAbility(ItemStack stack, String ability) {
        RelicAbilityEntry entry = AbilityUtils.getRelicAbilityEntry(stack.m_41720_(), ability);
        return entry != null && LevelingUtils.getLevel(stack) >= entry.getRequiredLevel();
    }

    public static boolean randomizeStat(ItemStack stack, String ability, String stat) {
        RelicAbilityStat entry = AbilityUtils.getRelicAbilityStat(stack.m_41720_(), ability, stat);
        if (entry == null) {
            return false;
        }
        double result = MathUtils.round(MathUtils.randomBetween(new Random(), (Double)entry.getInitialValue().getKey(), (Double)entry.getInitialValue().getValue()), 5);
        AbilityUtils.setAbilityValue(stack, ability, stat, result);
        return true;
    }

    public static boolean randomizeStats(ItemStack stack, String ability) {
        RelicAbilityEntry entry = AbilityUtils.getRelicAbilityEntry(stack.m_41720_(), ability);
        if (entry == null) {
            return false;
        }
        for (String stat : entry.getStats().keySet()) {
            AbilityUtils.randomizeStat(stack, ability, stat);
        }
        return true;
    }

    public static int getUpgradeRequiredExperience(ItemStack stack, String ability) {
        RelicAbilityEntry entry = AbilityUtils.getRelicAbilityEntry(stack.m_41720_(), ability);
        if (entry == null) {
            return 0;
        }
        int count = entry.getStats().size();
        if (count == 0) {
            return 0;
        }
        return (AbilityUtils.getAbilityPoints(stack, ability) + 1) * entry.getRequiredPoints() * count * 15;
    }

    public static boolean isAbilityMaxLevel(ItemStack stack, String ability) {
        RelicAbilityEntry entry = AbilityUtils.getRelicAbilityEntry(stack.m_41720_(), ability);
        if (entry == null) {
            return false;
        }
        return entry.getStats().size() == 0 || AbilityUtils.getAbilityPoints(stack, ability) >= (entry.getMaxLevel() == -1 ? LevelingUtils.getRelicLevelingData(stack.m_41720_()).getMaxLevel() / entry.getRequiredPoints() : entry.getMaxLevel());
    }

    public static boolean mayUpgrade(ItemStack stack, String ability) {
        RelicAbilityEntry entry = AbilityUtils.getRelicAbilityEntry(stack.m_41720_(), ability);
        if (entry == null) {
            return false;
        }
        return entry.getStats().size() > 0 && !AbilityUtils.isAbilityMaxLevel(stack, ability) && LevelingUtils.getPoints(stack) >= entry.getRequiredPoints() && AbilityUtils.canUseAbility(stack, ability);
    }

    public static boolean mayPlayerUpgrade(Player player, ItemStack stack, String ability) {
        return AbilityUtils.mayUpgrade(stack, ability) && player.f_36079_ >= AbilityUtils.getUpgradeRequiredExperience(stack, ability);
    }

    public static int getRerollRequiredExperience(ItemStack stack, String ability) {
        RelicAbilityEntry entry = AbilityUtils.getRelicAbilityEntry(stack.m_41720_(), ability);
        int count = entry.getStats().size();
        if (count == 0) {
            return 0;
        }
        return 100 / count;
    }

    public static boolean mayReroll(ItemStack stack, String ability) {
        RelicAbilityEntry entry = AbilityUtils.getRelicAbilityEntry(stack.m_41720_(), ability);
        if (entry == null) {
            return false;
        }
        return entry.getStats().size() > 0 && AbilityUtils.getRerollRequiredExperience(stack, ability) > 0 && AbilityUtils.canUseAbility(stack, ability);
    }

    public static boolean mayPlayerReroll(Player player, ItemStack stack, String ability) {
        return AbilityUtils.mayReroll(stack, ability) && player.f_36079_ >= AbilityUtils.getRerollRequiredExperience(stack, ability);
    }

    public static int getResetRequiredExperience(ItemStack stack, String ability) {
        return AbilityUtils.getAbilityPoints(stack, ability) * 50;
    }

    public static boolean mayReset(ItemStack stack, String ability) {
        return AbilityUtils.getResetRequiredExperience(stack, ability) > 0 && AbilityUtils.canUseAbility(stack, ability);
    }

    public static boolean mayPlayerReset(Player player, ItemStack stack, String ability) {
        RelicAbilityEntry entry = AbilityUtils.getRelicAbilityEntry(stack.m_41720_(), ability);
        if (entry == null) {
            return false;
        }
        return entry.getStats().size() > 0 && AbilityUtils.mayReset(stack, ability) && player.f_36079_ >= AbilityUtils.getResetRequiredExperience(stack, ability);
    }

    public static int getAbilityCooldownCap(ItemStack stack, String ability) {
        return AbilityUtils.getAbilityTempTag(stack, ability).m_128451_(TAG_COOLDOWN_CAP);
    }

    public static void setAbilityCooldownCap(ItemStack stack, String ability, int amount) {
        CompoundTag data = AbilityUtils.getAbilityTempTag(stack, ability);
        data.m_128405_(TAG_COOLDOWN_CAP, amount);
        AbilityUtils.setAbilityTempTag(stack, ability, data);
    }

    public static int getAbilityCooldown(ItemStack stack, String ability) {
        return AbilityUtils.getAbilityTempTag(stack, ability).m_128451_(TAG_COOLDOWN);
    }

    public static void setAbilityCooldown(ItemStack stack, String ability, int amount) {
        CompoundTag data = AbilityUtils.getAbilityTempTag(stack, ability);
        data.m_128405_(TAG_COOLDOWN, amount);
        data.m_128405_(TAG_COOLDOWN_CAP, amount);
        AbilityUtils.setAbilityTempTag(stack, ability, data);
    }

    public static void addAbilityCooldown(ItemStack stack, String ability, int amount) {
        CompoundTag data = AbilityUtils.getAbilityTempTag(stack, ability);
        data.m_128405_(TAG_COOLDOWN, AbilityUtils.getAbilityCooldown(stack, ability) + amount);
        AbilityUtils.setAbilityTempTag(stack, ability, data);
    }

    public static void setAbilityTicking(ItemStack stack, String ability, boolean ticking) {
        CompoundTag data = AbilityUtils.getAbilityTempTag(stack, ability);
        data.m_128379_(TAG_TICKING, ticking);
        AbilityUtils.setAbilityTempTag(stack, ability, data);
    }

    public static boolean isAbilityTicking(ItemStack stack, String ability) {
        return AbilityUtils.getAbilityTempTag(stack, ability).m_128471_(TAG_TICKING);
    }

    public static boolean isAbilityOnCooldown(ItemStack stack, String ability) {
        return AbilityUtils.getAbilityCooldown(stack, ability) > 0;
    }

    public static boolean canPlayerUseActiveAbility(Player player, ItemStack stack, String ability) {
        return AbilityUtils.canUseAbility(stack, ability) && !AbilityUtils.isAbilityOnCooldown(stack, ability) && CastUtils.testAbilityCastPredicates(player, stack, ability);
    }
}

