/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.items.relics.base.data.leveling;

import it.hurts.sskirillss.relics.items.relics.base.data.cast.AbilityCastPredicate;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.AbilityCastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.RelicAbilityStat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class RelicAbilityEntry {
    private Map<String, RelicAbilityStat> stats;
    private int maxLevel;
    private int requiredLevel;
    private int requiredPoints;
    private Pair<AbilityCastType, AbilityCastPredicate> castData;

    private static int $default$maxLevel() {
        return 10;
    }

    private static int $default$requiredLevel() {
        return 0;
    }

    private static int $default$requiredPoints() {
        return 1;
    }

    RelicAbilityEntry(Map<String, RelicAbilityStat> stats, int maxLevel, int requiredLevel, int requiredPoints, Pair<AbilityCastType, AbilityCastPredicate> castData) {
        this.stats = stats;
        this.maxLevel = maxLevel;
        this.requiredLevel = requiredLevel;
        this.requiredPoints = requiredPoints;
        this.castData = castData;
    }

    public static RelicAbilityEntryBuilder builder() {
        return new RelicAbilityEntryBuilder();
    }

    public Map<String, RelicAbilityStat> getStats() {
        return this.stats;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public int getRequiredLevel() {
        return this.requiredLevel;
    }

    public int getRequiredPoints() {
        return this.requiredPoints;
    }

    public Pair<AbilityCastType, AbilityCastPredicate> getCastData() {
        return this.castData;
    }

    public void setStats(Map<String, RelicAbilityStat> stats) {
        this.stats = stats;
    }

    public void setMaxLevel(int maxLevel) {
        this.maxLevel = maxLevel;
    }

    public void setRequiredLevel(int requiredLevel) {
        this.requiredLevel = requiredLevel;
    }

    public void setRequiredPoints(int requiredPoints) {
        this.requiredPoints = requiredPoints;
    }

    public void setCastData(Pair<AbilityCastType, AbilityCastPredicate> castData) {
        this.castData = castData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RelicAbilityEntry)) {
            return false;
        }
        RelicAbilityEntry other = (RelicAbilityEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxLevel() != other.getMaxLevel()) {
            return false;
        }
        if (this.getRequiredLevel() != other.getRequiredLevel()) {
            return false;
        }
        if (this.getRequiredPoints() != other.getRequiredPoints()) {
            return false;
        }
        Map<String, RelicAbilityStat> this$stats = this.getStats();
        Map<String, RelicAbilityStat> other$stats = other.getStats();
        if (this$stats == null ? other$stats != null : !((Object)this$stats).equals(other$stats)) {
            return false;
        }
        Pair<AbilityCastType, AbilityCastPredicate> this$castData = this.getCastData();
        Pair<AbilityCastType, AbilityCastPredicate> other$castData = other.getCastData();
        return !(this$castData == null ? other$castData != null : !this$castData.equals(other$castData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RelicAbilityEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMaxLevel();
        result = result * 59 + this.getRequiredLevel();
        result = result * 59 + this.getRequiredPoints();
        Map<String, RelicAbilityStat> $stats = this.getStats();
        result = result * 59 + ($stats == null ? 43 : ((Object)$stats).hashCode());
        Pair<AbilityCastType, AbilityCastPredicate> $castData = this.getCastData();
        result = result * 59 + ($castData == null ? 43 : $castData.hashCode());
        return result;
    }

    public String toString() {
        return "RelicAbilityEntry(stats=" + this.getStats() + ", maxLevel=" + this.getMaxLevel() + ", requiredLevel=" + this.getRequiredLevel() + ", requiredPoints=" + this.getRequiredPoints() + ", castData=" + this.getCastData() + ")";
    }

    public static class RelicAbilityEntryBuilder {
        private ArrayList<String> stats$key;
        private ArrayList<RelicAbilityStat> stats$value;
        private boolean maxLevel$set;
        private int maxLevel$value;
        private boolean requiredLevel$set;
        private int requiredLevel$value;
        private boolean requiredPoints$set;
        private int requiredPoints$value;
        private Pair<AbilityCastType, AbilityCastPredicate> castData = Pair.of((Object)((Object)AbilityCastType.NONE), (Object)new AbilityCastPredicate());

        public RelicAbilityEntryBuilder active(AbilityCastType type) {
            this.castData = Pair.of((Object)((Object)type), (Object)new AbilityCastPredicate());
            return this;
        }

        public RelicAbilityEntryBuilder active(AbilityCastType type, AbilityCastPredicate predicates) {
            this.castData = Pair.of((Object)((Object)type), (Object)predicates);
            return this;
        }

        RelicAbilityEntryBuilder() {
        }

        public RelicAbilityEntryBuilder stat(String statKey, RelicAbilityStat statValue) {
            if (this.stats$key == null) {
                this.stats$key = new ArrayList();
                this.stats$value = new ArrayList();
            }
            this.stats$key.add(statKey);
            this.stats$value.add(statValue);
            return this;
        }

        public RelicAbilityEntryBuilder stats(Map<? extends String, ? extends RelicAbilityStat> stats) {
            if (stats == null) {
                throw new NullPointerException("stats cannot be null");
            }
            if (this.stats$key == null) {
                this.stats$key = new ArrayList();
                this.stats$value = new ArrayList();
            }
            for (Map.Entry<? extends String, ? extends RelicAbilityStat> $lombokEntry : stats.entrySet()) {
                this.stats$key.add($lombokEntry.getKey());
                this.stats$value.add($lombokEntry.getValue());
            }
            return this;
        }

        public RelicAbilityEntryBuilder clearStats() {
            if (this.stats$key != null) {
                this.stats$key.clear();
                this.stats$value.clear();
            }
            return this;
        }

        public RelicAbilityEntryBuilder maxLevel(int maxLevel) {
            this.maxLevel$value = maxLevel;
            this.maxLevel$set = true;
            return this;
        }

        public RelicAbilityEntryBuilder requiredLevel(int requiredLevel) {
            this.requiredLevel$value = requiredLevel;
            this.requiredLevel$set = true;
            return this;
        }

        public RelicAbilityEntryBuilder requiredPoints(int requiredPoints) {
            this.requiredPoints$value = requiredPoints;
            this.requiredPoints$set = true;
            return this;
        }

        public RelicAbilityEntryBuilder castData(Pair<AbilityCastType, AbilityCastPredicate> castData) {
            this.castData = castData;
            return this;
        }

        public RelicAbilityEntry build() {
            Map<Object, Object> stats;
            switch (this.stats$key == null ? 0 : this.stats$key.size()) {
                case 0: {
                    stats = Collections.emptyMap();
                    break;
                }
                case 1: {
                    stats = Collections.singletonMap(this.stats$key.get(0), this.stats$value.get(0));
                    break;
                }
                default: {
                    stats = new LinkedHashMap(this.stats$key.size() < 0x40000000 ? 1 + this.stats$key.size() + (this.stats$key.size() - 3) / 3 : Integer.MAX_VALUE);
                    for (int $i = 0; $i < this.stats$key.size(); ++$i) {
                        stats.put(this.stats$key.get($i), this.stats$value.get($i));
                    }
                    stats = Collections.unmodifiableMap(stats);
                }
            }
            int maxLevel$value = this.maxLevel$value;
            if (!this.maxLevel$set) {
                maxLevel$value = RelicAbilityEntry.$default$maxLevel();
            }
            int requiredLevel$value = this.requiredLevel$value;
            if (!this.requiredLevel$set) {
                requiredLevel$value = RelicAbilityEntry.$default$requiredLevel();
            }
            int requiredPoints$value = this.requiredPoints$value;
            if (!this.requiredPoints$set) {
                requiredPoints$value = RelicAbilityEntry.$default$requiredPoints();
            }
            return new RelicAbilityEntry(stats, maxLevel$value, requiredLevel$value, requiredPoints$value, this.castData);
        }

        public String toString() {
            return "RelicAbilityEntry.RelicAbilityEntryBuilder(stats$key=" + this.stats$key + ", stats$value=" + this.stats$value + ", maxLevel$value=" + this.maxLevel$value + ", requiredLevel$value=" + this.requiredLevel$value + ", requiredPoints$value=" + this.requiredPoints$value + ", castData=" + this.castData + ")";
        }
    }
}

